<?php
// partials/sidebar-categories.php — menu lateral estilizado (cartão)
// (seguro para incluir em qualquer home)

include_once __DIR__ . '/cat-i18n.php';

// Fonte de dados (se não veio do caller)
if (!isset($menuCategories) || !is_array($menuCategories) || empty($menuCategories)) {
  if (isset($connect)) {
    try { $menuCategories = getMenuCategories($connect); } catch (\Exception $e) { $menuCategories = []; }
  } else {
    $menuCategories = [];
  }
}

// Fallback mínimo de $urlPath->search()
if (!isset($urlPath) || !is_object($urlPath) || !method_exists($urlPath, 'search')) {
  $base = rtrim((isset($_SERVER['REQUEST_SCHEME'])?$_SERVER['REQUEST_SCHEME'].'://':'') . ($_SERVER['HTTP_HOST'] ?? ''), '/');
  $urlPath = new class($base){private $b;function __construct($b){$this->b=rtrim($b,'/');}function search(){return $this->b.'/search';}};
}

if (empty($menuCategories)) { return; }
?>
<div class="tas-sidecats">
  <div class="sidecat-card">
    <?php foreach ($menuCategories as $cat):
      $slug  = $cat['category_slug']  ?? '';
      $title = $cat['category_title'] ?? '';
      $icon  = $cat['category_icon']  ?? 'dot';
      $href  = $slug ? ($urlPath->search() . '?category=' . urlencode($slug)) : '#';
      $label = cat_label_i18n($slug, $title); // do cat-i18n.php
    ?>
      <a class="sidecat-item" href="<?php echo htmlspecialchars($href, ENT_QUOTES, 'UTF-8'); ?>">
        <i class="ti ti-<?php echo htmlspecialchars($icon ?: 'dot', ENT_QUOTES, 'UTF-8'); ?>"></i>
        <span><?php echo htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?></span>
      </a>
    <?php endforeach; ?>
  </div>
</div>
