<?php
// partials/subcat-i18n.php — i18n de SUBCATEGORIAS por texto (PT -> EN/ES)
if (!function_exists('sub_label_i18n')) {
  function sub_label_i18n(string $pt_text): string {
    if (session_status() === PHP_SESSION_NONE) { @session_start(); }
    $lang = isset($_SESSION['lang']) ? strtolower($_SESSION['lang']) : 'en';
    $lang = in_array($lang, ['pt-br','en','es'], true) ? $lang : 'en';

    // normalizador simples
    $k = trim(mb_strtolower($pt_text));

    // Mapa PT => EN/ES (adicione mais entradas quando quiser)
    static $MAP = [
      // Food & Drink
      'cafés & guloseimas'      => ['en'=>'Cafés & Sweets',          'es'=>'Cafés y dulces'],
      'mercearias e mercados'   => ['en'=>'Groceries & Markets',     'es'=>'Supermercados y mercados'],
      'restaurantes'            => ['en'=>'Restaurants',              'es'=>'Restaurantes'],

      // Hotels & Travel
      'aluguel de carro'        => ['en'=>'Car Rental',               'es'=>'Alquiler de autos'],
      'praia'                   => ['en'=>'Beach',                    'es'=>'Playa'],
      'viagens românticas'      => ['en'=>'Romantic Getaways',        'es'=>'Escapadas románticas'],

      // Things to do / Entretenimento
      'atividades kids'         => ['en'=>'Kids Activities',          'es'=>'Actividades para niños'],
      'esportes & atividades'   => ['en'=>'Sports & Activities',      'es'=>'Deportes y actividades'],
      'vida noturna'            => ['en'=>'Nightlife',                'es'=>'Vida nocturna'],
      'ingressos & eventos'     => ['en'=>'Tickets & Events',         'es'=>'Entradas y eventos'],

      // Beauty & Spas
      'depilação'               => ['en'=>'Hair Removal',             'es'=>'Depilación'],
      'procedimentos cosméticos'=> ['en'=>'Cosmetic Procedures',      'es'=>'Procedimientos cosméticos'],
      'rosto & pele'            => ['en'=>'Face & Skin',              'es'=>'Rostro y piel'],

      // Health & Fitness
      'academias'               => ['en'=>'Gyms',                     'es'=>'Gimnasios'],
      'médicos'                 => ['en'=>'Doctors',                  'es'=>'Médicos'],
      'odontologia'             => ['en'=>'Dentistry',                'es'=>'Odontología'],

      // Retail
      'flores, doces e cestas'  => ['en'=>'Flowers, Sweets & Baskets','es'=>'Flores, dulces y cestas'],
      'presentes personalizados'=> ['en'=>'Personalized Gifts',       'es'=>'Regalos personalizados'],
      'roupas & acessórios'     => ['en'=>'Clothing & Accessories',   'es'=>'Ropa y accesorios'],

      // Automotive
      'manutenção de automóveis'=> ['en'=>'Car Maintenance',          'es'=>'Mantenimiento de automóviles'],
    ];

    // Se estiver em PT, devolve o texto original
    if ($lang === 'pt-br') return $pt_text;

    if (isset($MAP[$k][$lang])) return $MAP[$k][$lang];

    // fallback: mantém o texto original caso não mapeado
    return $pt_text;
  }
}
