<?php
// Rotas usadas no menu
$__AUTH = [
  'login'   => (isset($urlPath) && method_exists($urlPath, 'login'))    ? $urlPath->login()    : '/signin',
  // 👇 força usar signout(); fallback fixo /signout (nada de /logout)
  'logout'  => (isset($urlPath) && method_exists($urlPath, 'signout'))  ? $urlPath->signout()  : '/signout',
  'profile' => 'https://conecta.ndmidia.com.br/dashboard/profile.php',
];

$__IS_LOGGED = function_exists('isLogged') ? isLogged() : (!empty($_SESSION['user_id']) || !empty($_SESSION['user']['id']));
$__NAME = trim((string)($_SESSION['user_name'] ?? 'Minha conta'));

if ($__IS_LOGGED):
?>
<div id="ndUserMount" class="nd-userbox nd-userbox-inline">
  <button class="nd-userbtn" id="ndUserBtn" aria-haspopup="menu" aria-expanded="false">
    <span class="nd-avatar" aria-hidden="true">👤</span>
    <span class="nd-username"><?php echo htmlspecialchars($__NAME, ENT_QUOTES, 'UTF-8'); ?></span>
    <svg class="nd-caret" width="10" height="6" viewBox="0 0 10 6" aria-hidden="true">
      <path d="M1 1l4 4 4-4" fill="none" stroke="currentColor" stroke-width="1.6"/>
    </svg>
  </button>
  <div class="nd-usermenu" id="ndUserMenu" role="menu" hidden>
    <a role="menuitem" href="<?php echo htmlspecialchars($__AUTH['profile'], ENT_QUOTES, 'UTF-8'); ?>">Ver perfil</a>
    <form method="post" action="<?php echo htmlspecialchars($__AUTH['logout'], ENT_QUOTES, 'UTF-8'); ?>" class="nd-logout">
      <button type="submit" name="logout" value="1" role="menuitem">Sair</button>
    </form>
  </div>
</div>
<?php endif; ?>
