<?php
/**
 * ND User Menu (drop-in)
 * - Inclua este arquivo no header.view.php onde hoje aparece o botão "Login"/avatar.
 * - Depende de $__AUTH (login, logout, profile, isLogged) exposto pelo header.php.
 * - Não fecha/abre PHP desnecessariamente; seguro para ser incluído em views.
 */

$ndIsLogged = function_exists('isLogged') ? isLogged() : (!empty($_SESSION['user_id']) || !empty($_SESSION['user']['id']));
$ndProfile  = ($__AUTH['profile'] ?? './profile');
$ndLogout   = ($__AUTH['logout']  ?? './logout');
$ndLogin    = ($__AUTH['login']   ?? '/signin');
$ndName     = $_SESSION['user_name'] ?? '';

?>
<div class="nd-userbox">
  <?php if ($ndIsLogged): ?>
    <button class="nd-userbtn" id="ndUserBtn" aria-haspopup="menu" aria-expanded="false">
      <span class="nd-avatar" aria-hidden="true">👤</span>
      <span class="nd-username"><?= htmlspecialchars($ndName ?: 'Minha conta', ENT_QUOTES, 'UTF-8') ?></span>
      <svg class="nd-caret" width="10" height="6" viewBox="0 0 10 6" aria-hidden="true"><path d="M1 1l4 4 4-4" fill="none" stroke="currentColor" stroke-width="1.6"/></svg>
    </button>
    <div class="nd-usermenu" id="ndUserMenu" role="menu" hidden>
      <a role="menuitem" href="<?= htmlspecialchars($ndProfile, ENT_QUOTES, 'UTF-8') ?>">Ver perfil</a>
      <form method="post" action="<?= htmlspecialchars($ndLogout, ENT_QUOTES, 'UTF-8') ?>" class="nd-logout">
        <button type="submit" name="logout" value="1" role="menuitem">Sair</button>
      </form>
      <!-- Se seu logout for apenas GET, comente o <form> acima e descomente a linha abaixo:
      <a role="menuitem" href="<?= htmlspecialchars($ndLogout, ENT_QUOTES, 'UTF-8') ?>">Sair</a>
      -->
    </div>
  <?php else: ?>
  <a class="nd-loginbtn" href="<?= htmlspecialchars($ndLogin, ENT_QUOTES, 'UTF-8') ?>">Entrar</a>
  <a class="nd-loginbtn" href="https://conecta.ndmidia.com.br/dashboard/home.php">Anunciante</a>
  <a class="nd-loginbtn" href="https://conecta.ndmidia.com.br/dashboard/associate_login.php">Associado</a>
<?php endif; ?>

</div>

<style>
/* Ensure header-3 shows labels on auth buttons */
.button-header .label{display:inline !important;margin-left:.35rem}
.button-header{white-space:nowrap}
</style>
