<?php
// Inicia buffer só se não estiver ativo (evita "headers already sent")
if (function_exists('ob_get_level') && ob_get_level() === 0) { ob_start(); }

require __DIR__ . '/core.php';

/* --------------------------------------------
 * i18n + helpers (FALLBACKS SEGUROS)
 * -------------------------------------------- */
if (!isset($translation) || !is_array($translation)) { $translation = []; }

$translation += [
  'tr_profilepage' => $translation['PROFILE'] ?? 'Perfil',
  'tr_1'           => $translation['tr_1'] ?? 'Home',
  'tr_3'           => $translation['tr_3'] ?? 'Descrição do site',
];

if (!function_exists('tr')) {
  function tr(string $k, string $d = ''): string {
    $t = $GLOBALS['translation'] ?? [];
    return htmlspecialchars((string)($t[$k] ?? $d), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}

/* --------------------------------------------
 * Polyfills de funções do tema (defensivos)
 * -------------------------------------------- */
if (!function_exists('isSeller')) {
  function isSeller(): bool {
    $u = $GLOBALS['userInfo'] ?? [];
    // heurísticas comuns no tema
    if (isset($u['user_role']) && strtolower((string)$u['user_role']) === 'seller') return true;
    if (!empty($u['user_is_seller'])) return true;
    if (!empty($u['is_seller'])) return true;
    return false;
  }
}

/* --------------------------------------------
 * SEO com fallback
 * -------------------------------------------- */
$titleSeoHeader       = $titleSeoHeader       ?? tr('tr_profilepage', 'Perfil');
$descriptionSeoHeader = $descriptionSeoHeader ?? tr('tr_3', 'Descrição do site');

/* --------------------------------------------
 * Se exigir login, redireciona (mantém padrão do tema)
 * -------------------------------------------- */
if (function_exists('isLogged') && !isLogged()) {
  // $urlPath costuma existir via core.php
  $signin = (isset($urlPath) && method_exists($urlPath, 'login')) ? $urlPath->login() : './signin';
  while (function_exists('ob_get_length') && ob_get_length()) { @ob_end_clean(); }
  if (!headers_sent()) {
    header('Location: ' . $signin, true, 302);
    exit;
  }
  echo '<!doctype html><meta http-equiv="refresh" content="0;url=' . htmlspecialchars($signin, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') . '">';
  exit;
}

/* --------------------------------------------
 * Renderização
 * -------------------------------------------- */
require __DIR__ . '/header.php';
require __DIR__ . '/views/profile.view.php';
require __DIR__ . '/footer.php';
