<?php


declare(strict_types=1);
require_once "core.php";

$itemID = clearGetData(getItemId());

if(empty($itemID) || !isset($itemID)){

	header('Location: '. $urlPath->home());
    exit;

}else{

    $statement = $connect->prepare("SELECT * FROM deals WHERE deal_id = :deal_id AND deal_status = 1 LIMIT 1");
    $statement->execute(array(':deal_id' => $itemID));
    $result = $statement->fetch();
  
    if ($result != false) {

      // ND: registra clique no CTA (link externo)
      if (function_exists('nd_track_event') && isset($connect) && $connect) {
        try {
          $storeId = isset($result['deal_store']) ? (int)$result['deal_store'] : 0;
          nd_track_event($connect, 'click_deal_link', [
            'deal_id'  => (int)$itemID,
            'store_id' => ($storeId > 0 ? $storeId : null),
          ]);
        } catch (Throwable $e) {}
      }

      
	    header('Location: '. $result['deal_link']);
        exit;

    }else{

	    header('Location: '. $urlPath->error());
        
    }

}

?>