<?php declare(strict_types=1);
/**
 * /reset.php — versão limpa e padronizada
 * - strict_types primeiro, sem BOM/sem espaços antes
 * - Sem saída antes do PHP
 * - Apenas UM require de core.php
 * - Sem "?>" final
 */

if (function_exists('ob_get_level') && ob_get_level() === 0) { ob_start(); }
require __DIR__ . '/core.php';

// i18n com fallbacks
if (!isset($translation) || !is_array($translation)) { $translation = []; }
$translation += [
    'tr_resetpage' => $translation['tr_resetpage'] ?? 'Create New Password',
    'tr_1'         => $translation['tr_1'] ?? 'Home',
    'tr_3'         => $translation['tr_3'] ?? 'Descrição do site',
    'tr_158'       => $translation['tr_158'] ?? 'Por favor, informe o e-mail.',
    'tr_160'       => $translation['tr_160'] ?? 'Por favor, informe a senha.',
    'tr_401'       => $translation['tr_401'] ?? 'As senhas não coincidem.',
    'tr_404'       => $translation['tr_404'] ?? 'Token inválido ou expirado.',
    'tr_405'       => $translation['tr_405'] ?? 'Senha redefinida com sucesso. Faça login.',
];

$titleSeoHeader       = getSeoTitle($translation['tr_1'], $translation['tr_resetpage']);
$descriptionSeoHeader = getSeoDescription($translation['tr_3']);

$errors = [];
$success = '';

$email = (string)($_GET['email'] ?? '');
$key   = (string)($_GET['key']   ?? '');

if ($email === '' || $key === '') {
    $errors[] = $translation['tr_404'];
} else {
    $email = strtolower($email);
    $email = filter_var($email, FILTER_SANITIZE_EMAIL);
}

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST' && empty($errors)) {
    $pass  = (string)($_POST['user_password'] ?? '');
    $pass2 = (string)($_POST['user_password_confirm'] ?? '');

    if ($pass === '' || $pass2 === '') {
        $errors[] = $translation['tr_160'];
    } elseif ($pass !== $pass2) {
        $errors[] = $translation['tr_401'];
    }

    if (empty($errors)) {
        try {
            // Confere token válido
            $now = date("Y-m-d H:i:s");
            $st  = $connect->prepare("SELECT * FROM tokens WHERE token_email = :email AND token_key = :key AND token_date >= :now LIMIT 1");
            $st->execute([':email' => $email, ':key' => $key, ':now' => $now]);
            $tk = $st->fetch();

            if (!$tk) {
                $errors[] = $translation['tr_404'];
            } else {
                // Atualiza senha e elimina token
                $hash = hash('sha512', $pass);
                $up = $connect->prepare("UPDATE users SET user_password = :pwd WHERE user_email = :email");
                $up->execute([':pwd' => $hash, ':email' => $email]);

                $del = $connect->prepare("DELETE FROM tokens WHERE token_email = :email");
                $del->execute([':email' => $email]);

                $success = $translation['tr_405'];
            }
        } catch (Throwable $e) {
            $errors.append($translation['tr_168'] ?? 'Algo deu errado. Tente novamente.');
        }
    }
}

require __DIR__ . '/header.php';
require __DIR__ . '/views/reset.view.php';
require __DIR__ . '/footer.php';
