<?php

declare(strict_types=1);
require_once __DIR__ . '/core.php';
require_once __DIR__ . '/routes.php';
$__pageSlug = 'search';
$__view     = __DIR__ . '/pages/views/search.view.php';

if (!isset($itemDetails) || !is_array($itemDetails)) { $itemDetails = array(); }
$itemDetails += array(
  'page_title'       => ucfirst(str_replace('-', ' ', $__pageSlug)),
  'page_show_title'  => 1,
  'page_ad_header'   => 0,
  'page_show_footer' => 0,
  'page_content'     => '',
  'page_template'    => $__pageSlug,
);

if (!function_exists('array_get')){
  function array_get($arr,$key,$default=null){ return (is_array($arr)&&array_key_exists($key,$arr))?$arr[$key]:$default; }
}

$pageTitle = isset($itemDetails['page_title']) ? $itemDetails['page_title'] : ucfirst(str_replace('-', ' ', $__pageSlug));

// === Controller da página /search (compacto) ===
$perPage = (int)($site_config['page_limit'] ?? 12);
if (isset($_GET['per_page'])) {
    $pp = (int)$_GET['per_page'];
    if ($pp > 0) { $perPage = $pp; }
}

// ND_SHOW_ALL_HARDENED: ensure server-side unlimited when show-all flags present
$nearby = $_GET['nearby'] ?? '1';
$show   = isset($_GET['show']) ? strtolower((string)$_GET['show']) : '';
$all    = isset($_GET['all']) ? (int)$_GET['all'] : 0;
$IS_SHOW_ALL = ($nearby === '0') || ($show === 'all') || ($all === 1);
if ($IS_SHOW_ALL) { $perPage = 100000; $_GET['page'] = 1; }
$__res = getSearch($connect, (int)$perPage);
$items = array_get($__res,'items',[]);
$total = (int) array_get($__res,'total', is_array($items)?count($items):0);
$pp    = max(1,(int)$perPage);
$numPages = max(1, (int)ceil($total / $pp));



// ND_AFTER_GET_OVERRIDE: show-all: align totals with rendered items
if (!empty($IS_SHOW_ALL)) {
    $total    = is_array($items) ? count($items) : (int)$total;
    $numPages = 1;
}
require __DIR__ . '/views/header.view.php';
if (file_exists($__view)) { require $__view; } else {
  echo '<main class="uk-container uk-margin-large-top"><h1>'
     . htmlspecialchars($pageTitle)
     . '</h1><p>Template não encontrado: '
     . htmlspecialchars(basename($__view)) . '</p></main>';
}
require __DIR__ . '/views/footer.view.php';
