<?php
// Section: Exemplos de campanhas (Home)
// Usa UIkit e os SVGs em /assets/img
?>

<div class="uk-section uk-section-default uk-padding-small">
  <div class="uk-container">
    <div class="uk-flex uk-flex-between uk-flex-middle" style="gap:10px" uk-grid>
      <div class="uk-width-expand">
        <h3 class="uk-margin-remove">Campanhas prontas (ideias para você copiar)</h3>
        <p class="uk-text-small uk-text-muted uk-margin-small-top" style="max-width: 80ch">
          Se você é um anunciante local, dá pra começar já com uma oferta simples e um CTA direto. Quer anunciar? Conheça os planos.
        </p>
      </div>
      <div class="uk-width-auto@s">
        <a href="/anunciantes" class="uk-button uk-button-primary uk-border-pill">Quero anunciar</a>
      </div>
    </div>

    <div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m uk-margin-top" uk-grid>
      <div>
        <div class="uk-card uk-card-default uk-card-small uk-border-rounded" style="overflow:hidden; box-shadow: 0 8px 22px rgba(15,23,42,.06)">
          <img src="<?php echo $urlPath->assets_img('campaign-restaurant.svg'); ?>" alt="Campanha para restaurante" style="width:100%; height:150px; object-fit:cover; display:block">
          <div class="uk-card-body">
            <div class="uk-text-bold">Restaurante</div>
            <div class="uk-text-small uk-text-muted uk-margin-small-top"><strong>Oferta:</strong> Combo almoço + bebida com <strong>10% OFF</strong>.</div>
            <div class="uk-text-small uk-text-muted uk-margin-small-top"><strong>CTA:</strong> “Mostrar este cupom no caixa”.</div>
          </div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-small uk-border-rounded" style="overflow:hidden; box-shadow: 0 8px 22px rgba(15,23,42,.06)">
          <img src="<?php echo $urlPath->assets_img('campaign-pharmacy.svg'); ?>" alt="Campanha para farmácia" style="width:100%; height:150px; object-fit:cover; display:block">
          <div class="uk-card-body">
            <div class="uk-text-bold">Farmácia</div>
            <div class="uk-text-small uk-text-muted uk-margin-small-top"><strong>Oferta:</strong> Higiene/beleza com <strong>leve 3</strong> (itens selecionados).</div>
            <div class="uk-text-small uk-text-muted uk-margin-small-top"><strong>CTA:</strong> “Chamar no WhatsApp e reservar”.</div>
          </div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-small uk-border-rounded" style="overflow:hidden; box-shadow: 0 8px 22px rgba(15,23,42,.06)">
          <img src="<?php echo $urlPath->assets_img('campaign-market.svg'); ?>" alt="Campanha para mercado" style="width:100%; height:150px; object-fit:cover; display:block">
          <div class="uk-card-body">
            <div class="uk-text-bold">Mercado</div>
            <div class="uk-text-small uk-text-muted uk-margin-small-top"><strong>Oferta:</strong> Churrasco do fim de semana com <strong>desconto</strong> + brinde.</div>
            <div class="uk-text-small uk-text-muted uk-margin-small-top"><strong>CTA:</strong> “Ver ofertas do dia”.</div>
          </div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-small uk-border-rounded" style="overflow:hidden; box-shadow: 0 8px 22px rgba(15,23,42,.06)">
          <img src="<?php echo $urlPath->assets_img('campaign-barbershop.svg'); ?>" alt="Campanha para barbearia" style="width:100%; height:150px; object-fit:cover; display:block">
          <div class="uk-card-body">
            <div class="uk-text-bold">Barbearia</div>
            <div class="uk-text-small uk-text-muted uk-margin-small-top"><strong>Oferta:</strong> Corte + barba com <strong>R$X OFF</strong> no 1º agendamento.</div>
            <div class="uk-text-small uk-text-muted uk-margin-small-top"><strong>CTA:</strong> “Agendar agora”.</div>
          </div>
        </div>
      </div>
    </div>

    <div class="uk-flex uk-flex-center uk-margin-top" style="gap:10px">
      <a href="/pricing" class="uk-button uk-button-default uk-border-pill">Ver planos</a>
      <a href="/associados" class="uk-button uk-button-text">Quero ser associado</a>
    </div>
  </div>
</div>
