<?php
/**
 * Destaque Locations (controller)
 * - Mantém sua estrutura e a view original.
 * - Enriquecimento:
 *   • detail_link / permalink prontos (usando rota de busca com ?location=slug)
 *   • location_image_url montado com $urlPath->image() quando disponível
 *   • location_title cai para location_name
 *   • location_slug cai para slug_location/slug
 */

$counter = 0;

$featuredLocations = getFeaturedLocations($connect, $site_config['featured_locations']);

if (isset($featuredLocations) && is_array($featuredLocations)) {

    foreach ($featuredLocations as &$__loc) {

        // --------- Slug / ID base ---------
        $slug  = trim($__loc['location_slug'] ?? ($__loc['slug_location'] ?? ($__loc['slug'] ?? '')));
        $locId = isset($__loc['location_id']) ? (int)$__loc['location_id'] : 0;

        // --------- Link principal (sempre via página de busca) ---------
        if (empty($__loc['detail_link']) || $__loc['detail_link'] === '#') {

            if ($slug !== '') {
                // Preferimos usar a rota de busca configurada
                if (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'search')) {
                    $__loc['detail_link'] = $urlPath->search([
                        'location' => $slug
                    ]);
                } else {
                    // Fallback simples relativo
                    $__loc['detail_link'] = './search?' . http_build_query([
                        'location' => $slug
                    ]);
                }
            } elseif ($locId > 0) {
                // Último recurso: por ID (mantém compatibilidade com rotas legadas)
                $__loc['detail_link'] = './?location_id=' . $locId;
            } else {
                $__loc['detail_link'] = '#';
            }
        }

        // permalink sempre acompanha o detail_link, se não vier algo específico do BD
        if (!isset($__loc['permalink']) || $__loc['permalink'] === '') {
            $__loc['permalink'] = $__loc['detail_link'];
        }

        // --------- Título (fallback) ---------
        if (!isset($__loc['location_title']) || $__loc['location_title'] === '') {
            $__loc['location_title'] = $__loc['location_name'] ?? 'Location';
        }

        // --------- Slug normalizado ---------
        if (!isset($__loc['location_slug']) || $__loc['location_slug'] === '') {
            $__loc['location_slug'] = $slug;
        }

        // --------- Imagem pronta ---------
        if (!isset($__loc['location_image_url']) || $__loc['location_image_url'] === '') {

            $img = $__loc['location_image'] ?? ($__loc['image'] ?? '');

            if ($img) {
                if (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'image')) {
                    $__loc['location_image_url'] = $urlPath->image($img);
                } else {
                    $__loc['location_image_url'] = $img;
                }
            } else {
                $__loc['location_image_url'] = '';
            }
        }

        // --------- Total de itens (normaliza int) ---------
        if (isset($__loc['total_items'])) {
            $__loc['total_items'] = (int)$__loc['total_items'];
        }
    }
    unset($__loc);
}

require './sections/views/featured-locations.view.php';
?>
