<?php
/**
 * Destaque Stores (controller)
 * - Mantém sua estrutura e a view original
 * - Enriquecimento:
 *   • detail_link/permalink -> ./store/{slug}
 *   • store_name cai para store_title
 *   • store_logo_url monta com $urlPath->image() quando disponível
 */

$featuredStores = getFeaturedStores($connect, $site_config['featured_stores']);

if (isset($featuredStores) && is_array($featuredStores)) {
    foreach ($featuredStores as &$__store) {
        // Nome da loja
        if (!isset($__store['store_name']) || $__store['store_name'] === '') {
            $__store['store_name'] = $__store['store_title'] ?? 'Store';
        }

        // Link para a página da loja
        $slug = trim($__store['store_slug'] ?? $__store['slug_store'] ?? '');
        if (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'store')) {
            $href = $slug !== '' ? $urlPath->store($slug) : '#';
        } else {
            $href = $slug !== '' ? ('./store/' . rawurlencode($slug)) : '#';
        }

        if (!isset($__store['detail_link']) || $__store['detail_link'] === '') {
            $__store['detail_link'] = $href;
        }
        if (!isset($__store['permalink']) || $__store['permalink'] === '') {
            $__store['permalink'] = $href;
        }

        // Logo completo
        if (!isset($__store['store_logo_url']) || $__store['store_logo_url'] === '') {
            $logo = $__store['store_logo'] ?? $__store['logo'] ?? '';
            if ($logo) {
                if (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'image')) {
                    $__store['store_logo_url'] = $urlPath->image($logo);
                } else {
                    $__store['store_logo_url'] = $logo;
                }
            }
        }
    }
    unset($__store);
}

require './sections/views/featured-stores.view.php';
?>
