    <?php
    // Carrega os modais ANTES dos JS para garantir que o UIkit encontre os nós.
    if (isset($itemDetails) && is_array($itemDetails)) {
      $base = __DIR__ . '/../sections/views/';
      $load = function($f) use ($base) { $p = $base.$f; if (file_exists($p)) require $p; };
      // Estes arquivos devem existir no seu tema/projeto
      if (!empty($settings['st_enable_report_form'])) $load('report-modal.view.php');
      $load('submit-review.view.php');
      $load('reviews-modal.view.php');
    }
    ?>

    <!-- Vendor scripts (uma única vez) -->
    <script src="<?php echo $urlPath->assets_js('cookieconsent.min.js'); ?>"></script>
    <script src="<?php echo $urlPath->assets_js('nice-select.min.js'); ?>"></script>
    <script src="<?php echo $urlPath->assets_js('datatables.min.js'); ?>"></script>
    <script src="<?php echo $urlPath->assets_js('datatables.uikit.min.js'); ?>"></script>
    <script src="<?php echo $urlPath->assets_js('rating.min.js'); ?>"></script>
    <script src="<?php echo $urlPath->assets_js('jquery.upload.js'); ?>"></script>
    <!-- main.js já é incluído no header com defer -->

    <!-- Pacote de modais: CSS + JS -->
    <link rel="stylesheet" href="/assets/css/nd-offer-modals.css?v=2">
    <script src="/assets/js/nd-offer-modals.js?v=2" defer></script>

    <?php if (!empty($settings['st_cookie_consent'])): ?>
    <script>
    window.cookieconsent && window.cookieconsent.initialise({
      palette: {
        popup:   { background: '#efefef', text: '#404040' },
        button:  { background: '#8ec760', text: '#ffffff' }
      },
      theme: 'classic',
      content: {
        message: "<?php echo echoOutput($translation['tr_115']); ?>",
        dismiss: "<?php echo echoOutput($translation['tr_117']); ?>",
        link:    "<?php echo echoOutput($translation['tr_114']); ?>",
        href:    "https://conecta.ndmidia.com.br/politicadeprivacidade"
      }
    });
    </script>
    <?php endif; ?>
  
<script>
(function(){
  function drawStars(avg){ avg=Math.max(0,Math.min(5,avg||0)); var full=Math.round(avg); var s=''; for(var i=0;i<5;i++) s+=(i<full?'★':'☆'); return s; }
  function updateJsonLD(avg,count){ var tag=document.getElementById('nd-jsonld'); if(!tag) return; try{ var d=JSON.parse(tag.textContent); if(!d.aggregateRating) d.aggregateRating={"@type":"AggregateRating"}; d.aggregateRating.ratingValue=(avg||0).toFixed(2); d.aggregateRating.reviewCount=count||0; d.aggregateRating.bestRating="5"; d.aggregateRating.worstRating="1"; tag.textContent=JSON.stringify(d); }catch(e){} }
  function fetchReviews(item){ return fetch('/controllers/get-reviews.php?item='+encodeURIComponent(item),{credentials:'same-origin'}).then(r=>r.json()); }
  function renderReviews(list){ var box=document.getElementById('nd-reviews'); if(!box||!Array.isArray(list)) return; box.innerHTML=list.map(r=>{var stars=drawStars(+r.rating); var when=(r.created||'').slice(0,10); return '<div class="uk-comment uk-margin"><div class="uk-comment-body"><div class="uk-text-small uk-text-muted">'+when+'</div><div class="uk-text-large">'+stars+' <span class="uk-text-bold">'+(+r.rating)+'/5</span></div><p>'+ (r.comment? String(r.comment).replace(/[<>]/g,'') : '') +'</p></div></div>';}).join(''); }
  function init(){ var it=window.ND_RATING&&window.ND_RATING.item; if(!it) return; fetchReviews(it).then(data=>{ var avg=data&&data.stats?+data.stats.avg:0; var cnt=data&&data.stats?+data.stats.count:0; var s=document.getElementById('nd-stars'), sc=document.getElementById('nd-score'), c=document.getElementById('nd-count'); if(s) s.textContent=drawStars(avg); if(sc) sc.textContent=(avg?avg.toFixed(1):'0.0')+'/5'; if(c) c.textContent='('+cnt+' avaliações)'; updateJsonLD(avg,cnt); renderReviews(data&&data.items); }).catch(()=>{}); }
  if (document.readyState==='loading') document.addEventListener('DOMContentLoaded', init); else init();
})();
</script>

</body>
</html>

<script src="/assets/js/nd-reviews-submit.js?v=11" defer></script>
