<?php
/**
 * Latest Deals (controller)
 * - Mantém sua estrutura e a view original
 * - Enriquecimento:
 *   • detail_link / permalink usam ?slug=... quando existir; fallback para ?deal_id=...
 *   • store_name cai para store_title/store se faltar
 *   • deal_image_url monta com $urlPath->image() quando disponível
 */

$latestDeals = getLatestDeals($connect, $site_config['latest_items']);

if (isset($latestDeals) && is_array($latestDeals)) {
    foreach ($latestDeals as &$__deal) {
        // Preferir SLUG para link interno
        $slug   = trim($__deal['deal_slug'] ?? $__deal['slug'] ?? '');
        $dealId = isset($__deal['deal_id']) ? (int)$__deal['deal_id'] : 0;

        if ($slug !== '') {
            $__internal = './?slug=' . rawurlencode($slug);
        } elseif ($dealId > 0) {
            $__internal = './?deal_id=' . $dealId;
        } else {
            $__internal = '#';
        }

        // Preenche detail_link / permalink SEM sobrescrever se já vierem
        if (!isset($__deal['detail_link']) || $__deal['detail_link'] === '') {
            $__deal['detail_link'] = $__internal;
        }
        if (!isset($__deal['permalink']) || $__deal['permalink'] === '') {
            $__deal['permalink'] = $__internal;
        }

        // Normaliza nome da loja para a view
        if (!isset($__deal['store_name']) || $__deal['store_name'] === '') {
            $__deal['store_name'] = $__deal['store_title'] ?? ($__deal['store'] ?? '');
        }

        // URL completa da imagem (se existir helper no projeto)
        if (!isset($__deal['deal_image_url']) || $__deal['deal_image_url'] === '') {
            $img = $__deal['deal_image'] ?? '';
            if ($img) {
                if (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'image')) {
                    $__deal['deal_image_url'] = $urlPath->image($img);
                } else {
                    $__deal['deal_image_url'] = $img;
                }
            }
        }
    }
    unset($__deal);
}

require './sections/views/latest-deals.view.php';
?>
