<?php
// sections/lib/cat-i18n.php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

function cat_current_lang(): string {
  $l = strtolower($_SESSION['lang'] ?? 'en');
  return in_array($l, ['pt-br','en','es'], true) ? $l : 'en';
}

/**
 * Extrai o slug do href (…?category=slug). Se não achar, retorna ''.
 */
function cat_slug_from_href(string $href): string {
  // lida com URLs absolutas/relativas
  $href = trim($href);
  if ($href === '') return '';
  // tenta parsear a query
  $qpos = strpos($href, '?');
  if ($qpos === false) return '';
  parse_str(parse_url($href, PHP_URL_QUERY) ?? '', $qs);
  $slug = strtolower(trim($qs['category'] ?? ''));
  // normaliza
  $slug = preg_replace('~[^a-z0-9\-]~', '', $slug ?? '');
  return $slug ?: '';
}

/**
 * Retorna o rótulo traduzido para o slug informado.
 * Se não houver no mapa, devolve o $fallback.
 */
function cat_i18n(string $slug, string $fallback): string {
  static $MAP = [
    'comida-e-bebida' => [
      'pt-br' => 'Comida & Bebida',
      'en'    => 'Food & Drink',
      'es'    => 'Comida y Bebida',
    ],
    'hoteis-e-viagens' => [
      'pt-br' => 'Hotéis & Viagens',
      'en'    => 'Hotels & Travel',
      'es'    => 'Hoteles y Viajes',
    ],
    'coisas-para-fazer' => [
      'pt-br' => 'Coisas para fazer',
      'en'    => 'Things to do',
      'es'    => 'Cosas para hacer',
    ],
    'beleza-spas' => [
      'pt-br' => 'Beleza & Spas',
      'en'    => 'Beauty & Spas',
      'es'    => 'Belleza & Spas',
    ],
    'saude-fitness' => [
      'pt-br' => 'Saúde & Fitness',
      'en'    => 'Health & Fitness',
      'es'    => 'Salud & Fitness',
    ],
    'varejo' => [
      'pt-br' => 'Varejo',
      'en'    => 'Retail',
      'es'    => 'Venta al por menor',
    ],
    'automotivo' => [
      'pt-br' => 'Automotivo',
      'en'    => 'Automotive',
      'es'    => 'Automotriz',
    ],
  ];

  $slug = strtolower(trim($slug));
  $lang = cat_current_lang();
  if (isset($MAP[$slug])) {
    return $MAP[$slug][$lang] ?? $MAP[$slug]['en'] ?? $fallback;
  }
  return $fallback;
}
