<?php
$ratingItemId = $ratingItemId ?? ($deal['id'] ?? ($itemDetails['deal_id'] ?? null));
?>
<link rel="stylesheet" href="/assets/css/nd-share.css?v=4"><!-- reuse stars font size -->

<div id="nd-reviews-wrap" class="uk-margin-large-top" data-item="<?= htmlspecialchars((string)$ratingItemId) ?>">
  <h3 class="uk-heading-bullet">
    <span>Avaliações de clientes</span>
    <span class="uk-text-meta" id="nd-count" style="margin-left:8px"></span>
  </h3>

  <div class="uk-flex uk-flex-middle uk-margin-small">
    <div id="nd-score" class="uk-h2 uk-margin-remove">0.0/5</div>
    <div class="nd-stars uk-margin-small-left" id="nd-stars">☆☆☆☆☆</div>
    <div class="uk-margin-auto-left">
      <a class="uk-button uk-button-default uk-button-small uk-border-pill" href="#submit-review" uk-toggle>Escrever avaliação</a>
    </div>
  </div>

  <hr>
  <div id="nd-reviews"></div>
</div>

<script>
(function(){
  function drawStars(avg){ avg=Math.max(0,Math.min(5,avg||0)); var full=Math.round(avg); var s=''; for(var i=0;i<5;i++) s+=(i<full?'★':'☆'); return s; }
  function updateJsonLD(avg,count){ var tag=document.getElementById('nd-jsonld'); if(!tag) return; try{ var d=JSON.parse(tag.textContent); if(!d.aggregateRating) d.aggregateRating={"@type":"AggregateRating"}; d.aggregateRating.ratingValue=(avg||0).toFixed(2); d.aggregateRating.reviewCount=count||0; d.aggregateRating.bestRating="5"; d.aggregateRating.worstRating="1"; tag.textContent=JSON.stringify(d); }catch(e){} }
  function fetchReviews(item){ if(!item) return Promise.resolve({items:[],stats:{avg:0,count:0}}); return fetch('/controllers/get-reviews.php?item='+encodeURIComponent(item),{credentials:'same-origin'}).then(function(r){return r.json()}).catch(function(){return {items:[],stats:{avg:0,count:0}}}); }
  function renderReviews(list){ var box=document.getElementById('nd-reviews'); if(!box) return; box.innerHTML=''; if(!Array.isArray(list)||!list.length){ return; } list.forEach(function(r){ var wrap=document.createElement('div'); wrap.className='uk-comment uk-margin'; wrap.innerHTML='<div class="uk-comment-body"><div class="uk-text-small uk-text-muted">'+(r.created||'').slice(0,10)+'</div><div class="uk-text-large">'+drawStars(+r.rating)+' <span class="uk-text-bold">'+(+r.rating)+'/5</span></div><p>'+ (r.comment? String(r.comment).replace(/[<>]/g,'') : '') +'</p></div>'; box.appendChild(wrap); }); }
  function init(){ var wrap=document.getElementById('nd-reviews-wrap'); if(!wrap) return; var item=wrap.getAttribute('data-item'); fetchReviews(item).then(function(data){ var avg=data&&data.stats?+data.stats.avg:0; var cnt=data&&data.stats?+data.stats.count:0; document.getElementById('nd-stars').textContent=drawStars(avg); document.getElementById('nd-score').textContent=(avg?avg.toFixed(1):'0.0')+'/5'; document.getElementById('nd-count').textContent='('+cnt+' avaliações)'; updateJsonLD(avg,cnt); renderReviews(data&&data.items); }); }
  if (document.readyState==='loading') document.addEventListener('DOMContentLoaded', init); else init();
})();
</script>
