<?php
$deal      = $deal      ?? ($itemDetails ?? []);
$dealTitle = $deal['title'] ?? ($title ?? 'Oferta');
$dealImage = $deal['image'] ?? ($image ?? '');
$shareUrl  = $shareUrl  ?? ((defined('SITEURL') ? SITEURL : (rtrim($_SERVER['REQUEST_SCHEME']."://".$_SERVER['HTTP_HOST'], '/'))) . $_SERVER['REQUEST_URI']);
$shareImage= $shareImage?? $dealImage;
?>
<link rel="stylesheet" href="/assets/css/nd-share.css?v=4">
<script src="/assets/js/nd-share.js?v=1" defer></script>

<div class="uk-margin">
  <div class="uk-text-bold uk-margin-small-bottom">Compartilhar esta oferta</div>
  
<style id="nd-share-fallback-v4">
ul.nd-share-circles{display:flex!important;flex-wrap:wrap!important;gap:6px;padding:0 16px 8px;max-width:100%;overflow:visible!important}
ul.nd-share-circles a{width:36px;height:36px;border-radius:9999px;display:inline-flex;align-items:center;justify-content:center;box-sizing:border-box}
ul.nd-share-circles svg{width:18px;height:18px}
@media(min-width:421px){ul.nd-share-circles{gap:10px;padding:0 14px 8px}ul.nd-share-circles a{width:44px;height:44px}ul.nd-share-circles svg{width:20px;height:20px}}
</style>

<ul class="nd-share-circles">
    <li><a class="nd-share--facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?= urlencode($shareUrl) ?>" target="_blank" rel="noopener" aria-label="Facebook">
      <svg viewBox="0 0 24 24"><path d="M22 12.07C22 6.48 17.52 2 11.93 2S2 6.48 2 12.07c0 5.02 3.66 9.19 8.44 9.93v-7.02H7.9V12.1h2.54V9.8c0-2.5 1.49-3.89 3.77-3.89 1.09 0 2.23.2 2.23.2v2.45h-1.26c-1.24 0-1.63.77-1.63 1.56v1.87h2.78l-.44 2.88h-2.34V22c4.78-.74 8.44-4.91 8.44-9.93z"/></svg>
    </a></li>
    <li><a class="nd-share--instagram" href="<?= htmlspecialchars($shareUrl) ?>" onclick="return ND.shareOffer(event);" aria-label="Instagram">
      <svg viewBox="0 0 24 24"><path d="M7 2h10a5 5 0 0 1 5 5v10a5 5 0 0 1-5 5H7a5 5 0 0 1-5-5V7a5 5 0 0 1 5-5zm5 3.5A5.5 5.5 0 1 1 6.5 13 5.5 5.5 0 0 1 12 7.5zm6.25-.75a1.25 1.25 0 1 1-1.25 1.25 1.25 1.25 0 0 1 1.25-1.25z"/></svg>
    </a></li>
    <li><a class="nd-share--twitter" href="https://twitter.com/intent/tweet?url=<?= urlencode($shareUrl) ?>&text=<?= urlencode($dealTitle) ?>" target="_blank" rel="noopener" aria-label="Twitter">
      <svg viewBox="0 0 24 24"><path d="M22.46 6c-.77.35-1.6.58-2.46.69a4.3 4.3 0 0 0 1.88-2.37 8.59 8.59 0 0 1-2.72 1.04 4.28 4.28 0 0 0-7.3 3.9A12.14 12.14 0 0 1 3.15 5.15a4.27 4.27 0 0 0 1.33 5.71 4.25 4.25 0 0 1-1.94-.54v.05a4.29 4.29 0 0 0 3.44 4.2 4.26 4.26 0  0 1-1.93.07 4.29 4.29 0 0 0 4 2.97A8.6 8.6 0 0 1 2 19.54 12.14 12.14 0 0 0 8.56 21c7.34 0 11.36-6.08 11.36-11.36l-.01-.52A8.12 8.12 0 0 0 22.46 6z"/></svg>
    </a></li>
    <li><a class="nd-share--linkedin" href="https://www.linkedin.com/sharing/share-offsite/?url=<?= urlencode($shareUrl) ?>" target="_blank" rel="noopener" aria-label="LinkedIn">
      <svg viewBox="0 0 24 24"><path d="M6.94 6.5A2.44 2.44 0 1 1 4.5 4.06 2.44 2.44 0 0 1 6.94 6.5zM5 8.89h3.89V20H5zM13.22 8.89h3.73v1.52h.05a4.09 4.09 0 0 1 3.68-2.03c3.94 0 4.66 2.6 4.66 5.98V20h-3.89v-5.06c0-1.21-.02-2.77-1.69-2.77-1.69 0-1.95 1.32-1.95 2.68V20H13.2z"/></svg>
    </a></li>
    <li><a class="nd-share--pinterest" href="https://pinterest.com/pin/create/button/?url=<?= urlencode($shareUrl) ?>&media=<?= urlencode($shareImage) ?>&description=<?= urlencode($dealTitle) ?>" target="_blank" rel="noopener" aria-label="Pinterest">
      <svg viewBox="0 0 24 24"><path d="M12.04 2C6.58 2 4 5.66 4 8.9c0 1.8.99 4.06 2.58 4.76.24.11.36.06.41-.16.04-.17.26-1 .36-1.39.03-.11.02-.21-.08-.32-.52-.61-.86-1.41-.86-2.54 0-3.28 2.46-6.23 6.4-6.23 3.49 0 5.41 2.13 5.41 4.98 0 3.75-1.86 6.35-4.28 6.35-1.34 0-2.35-1.1-2.02-2.44.38-1.58 1.1-3.28 1.1-4.41 0-1.02-.55-1.88-1.68-1.88-1.33 0-2.39 1.37-2.39 3.2 0 1.17.4 1.96.4 1.96l-1.62 6.84c-.48 2.02-.07 4.49-.04 4.74.02.13.18.16.25.06.11-.15 1.56-2.08 2.06-4.08.13-.52.8-3.24.8-3.24.39.74 1.54 1.39 2.77 1.39 3.65 0 6.13-3.32 6.13-7.77C18.21 4.87 15.6 2 12.04 2z"/></svg>
    </a></li>
    <li><a class="nd-share--whatsapp" href="https://api.whatsapp.com/send?text=<?= urlencode($dealTitle.' - '.$shareUrl) ?>" target="_blank" rel="noopener" aria-label="WhatsApp">
      <svg viewBox="0 0 24 24"><path d="M20.52 3.48A11.91 11.91 0 0 0 12 .1C5.37.1.1 5.37.1 12c0 2.1.55 4.15 1.59 5.95L.12 24l6.2-1.6A12 12 0 1 0 20.52 3.48zM12 21.5a9.5 9.5 0 0 1-4.83-1.3l-.35-.2-3.68.95.98-3.59-.23-.37A9.5 9.5 0 1 1 12 21.5zm5.5-6.92c-.3-.15-1.78-.88-2.06-.98-.28-.1-.49-.15-.7.15-.21.3-.8.98-.98 1.18-.18.2-.36.22-.66.07-.3-.15-1.26-.46-2.4-1.48-.89-.79-1.5-1.77-1.68-2.07-.18-.3-.02-.46.13-.6.13-.13.3-.36.44-.54.15-.18.2-.3.3-.5.1-.2.05-.38-.02-.53-.07-.15-.7-1.68-.96-2.3-.25-.6-.5-.5-.7-.5h-.6c-.2 0-.53.07-.8.38-.27.3-1.04 1.02-1.04 2.48s1.07 2.88 1.22 3.08c.15.2 2.1 3.2 5.06 4.48.71.31 1.26.49 1.69.63.71.23 1.35.2 1.86.12.57-.08 1.78-.73 2.03-1.44.25-.71.25-1.33.17-1.46-.07-.13-.27-.2-.56-.35z"/></svg>
    </a></li>
    <li><a class="nd-share--telegram" href="https://t.me/share/url?url=<?= urlencode($shareUrl) ?>&text=<?= urlencode($dealTitle) ?>" target="_blank" rel="noopener" aria-label="Telegram">
      <svg viewBox="0 0 24 24"><path d="M21.944 3.164c.33-.144.688.177.57.62l-3.14 12.03c-.12.459-.47.66-.95.46l-5.01-2.16-2.42 2.35c-.27.266-.49.49-1 .49l.36-5.14 9.37-8.49c.41-.37-.09-.57-.64-.21L6.53 11.61l-5.06-1.58c-.53-.16-.54-.52.12-.78L21.944 3.164z"/></svg>
    </a></li>
    </ul>
</div>
