<div class="uk-container uk-margin-top uk-margin-large-bottom" uk-scrollspy="target: > div; cls: uk-animation-fade; delay: 100">

  <div class="tas_heading uk-grid-collapse uk-flex uk-flex-middle" uk-grid>
    <div class="uk-width-expand">
      <h3 class="uk-h4">
        <?php
echo (isset($translation['HOME_FEATURED_LOCATIONS']) ? $translation['HOME_FEATURED_LOCATIONS'] : 'Locais em Destaque'); ?>
      </h3>
    </div>
    <div class="uk-width-auto">
      <a href="<?php echo $urlPath->locations(); ?>" class="uk-button uk-button-default uk-border-pill btn">
        <?php echo (isset($translation['BTN_VIEW_ALL']) ? $translation['BTN_VIEW_ALL'] : 'Ver tudo'); ?>
        <i class="ti ti-chevron-right"></i>
      </a>
    </div>
  </div>

  <div class="uk-grid-small uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-2@m uk-child-width-1-5@l uk-margin-medium-top" uk-grid>

    <?php if (!empty($featuredLocations) && is_array($featuredLocations)): ?>
      <?php foreach ($featuredLocations as $item): ?>
        <?php
          // ----- HREF robusto (ordem de preferência) -----
          $href = $item['detail_link'] ?? ($item['permalink'] ?? '');
          if ($href === '' || $href === null) {
              $slug = trim($item['location_slug'] ?? ($item['slug_location'] ?? ($item['slug'] ?? '')));
              $locId = isset($item['location_id']) ? (int)$item['location_id'] : 0;

              if ($slug !== '') {
                  if (method_exists($urlPath, 'search')) {
                      $href = $urlPath->search([
                          'location' => $slug
                      ]);
                  } else {
                      // Fallback simples relativo
                      $href = './search?' . http_build_query([
                          'location' => $slug
                      ]);
                  }
              } elseif ($locId > 0) {
                  // fallback por ID (ajuste se a sua rota for diferente)
                  $href = './?location_id=' . $locId;
              } else {
                  $href = '#';
              }
          }

          // ----- Imagem (usa a pré-montada quando existir) -----
          $imgUrl = $item['location_image_url'] ?? '';
          if ($imgUrl === '' || $imgUrl === null) {
              $img = $item['location_image'] ?? ($item['image'] ?? '');
              $imgUrl = $img ? $urlPath->image($img) : $urlPath->image('');
          }

          // ----- Título -----
          $title = $item['location_title'] ?? ($item['location_name'] ?? 'Location');

          // ----- Contagem -----
          $count = isset($item['total_items']) ? (int)$item['total_items'] : 0;
        ?>

        <a href="<?php echo htmlspecialchars($href, ENT_QUOTES, 'UTF-8'); ?>">
          <div class="cat_2 uk-cover-container">
            <img src="<?php echo htmlspecialchars($imgUrl, ENT_QUOTES, 'UTF-8'); ?>" alt="<?php echo echoOutput($title); ?>" uk-cover>
            <canvas width="600" height="300"></canvas>

            <div class="uk-overlay-primary uk-position-cover"></div>
            <div class="uk-overlay uk-position-center uk-light">
              <p><?php echo echoOutput($title); ?></p>
              <span>
                <?php echo (int)$count; ?>
                <?php echo (isset($translation['LOCATIONS_ITEMS']) ? $translation['LOCATIONS_ITEMS'] : 'itens'); ?>
              </span>
            </div>
          </div>
        </a>

      <?php endforeach; ?>
    <?php else: ?>
      <div class="uk-width-1-1">
        <p class="uk-text-muted">—</p>
      </div>
    <?php endif; ?>

  </div>

</div>
