<div class="uk-container uk-margin-large-top uk-margin-large-bottom" uk-scrollspy="target: > div; cls: uk-animation-fade; delay: 100">

  <div class="tas_heading uk-grid-collapse uk-flex uk-flex-middle" uk-grid>
    <div class="uk-width-expand">
      <h3 class="uk-h4">
        <?php
echo $translation['HOME_FEATURED_STORES'] ?? 'Lojas em Destaque'; ?>
      </h3>
    </div>
    <div class="uk-width-auto">
      <a href="<?php echo $urlPath->stores(); ?>" class="uk-button uk-button-default uk-border-pill btn">
        <?php echo $translation['BTN_VIEW_ALL'] ?? 'Ver tudo'; ?>
        <i class="ti ti-chevron-right"></i>
      </a>
    </div>
  </div>

  <div class="uk-grid-small uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-4@m uk-child-width-1-5@l uk-grid-small" uk-grid>

    <?php if (!empty($featuredStores) && is_array($featuredStores)): ?>
      <?php foreach ($featuredStores as $item): ?>
        <?php
          // Nome da loja (com fallbacks)
          $storeName = $item['store_name'] ?? ($item['store_title'] ?? 'Store');

          // Slug da loja
          $slug = trim($item['store_slug'] ?? ($item['slug_store'] ?? ''));

          // Link do card (ordem de preferência):
          // 1) detail_link/permalink vindos do controller (se houver)
          // 2) busca por loja (mantém sua compatibilidade atual)
          // 3) fallback '#'
          $href = $item['detail_link'] ?? ($item['permalink'] ?? '');
          if ($href === '' || $href === null) {
              $href = $slug ? $urlPath->search(['store' => $slug]) : '#';
          }

          // Imagem/logo da loja (com fallbacks)
          $logoUrl = $item['store_logo_url'] ?? '';
          if ($logoUrl === '' || $logoUrl === null) {
              $img = $item['store_image'] ?? ($item['logo'] ?? '');
              $logoUrl = $img ? $urlPath->image($img) : '';
          }
        ?>

        <div class="cat_3">
          <a href="<?php echo htmlspecialchars($href, ENT_QUOTES, 'UTF-8'); ?>">
            <div class="uk-grid-collapse uk-flex uk-flex-middle" uk-grid>
              <div class="uk-width-auto">
                <div class="cover uk-cover-container">
                  <?php if ($logoUrl): ?>
                    <img src="<?php echo htmlspecialchars($logoUrl, ENT_QUOTES, 'UTF-8'); ?>" alt="<?php echo echoOutput($storeName); ?>" uk-cover>
                  <?php else: ?>
                    <!-- Se não houver imagem, mantém o canvas vazio para não quebrar o layout -->
                  <?php endif; ?>
                  <canvas width="60" height="60"></canvas>
                </div>
              </div>
              <div class="uk-width-expand">
                <!-- Aqui agora mostra o NOME DA LOJA -->
                <h2 class="uk-h4 title"><?php echo echoOutput($storeName); ?></h2>
              </div>
            </div>
          </a>
        </div>

      <?php endforeach; ?>
    <?php else: ?>
      <div class="uk-width-1-1">
        <p class="uk-text-muted">—</p>
      </div>
    <?php endif; ?>

  </div>
</div>
