<!-- i18n fixes css (funciona mesmo fora do <head>) -->
<link rel="stylesheet" href="/assets/css/ndm-i18n-fixes.css">

<div class="uk-section-primary uk-preserve-color uk-visible@m">
<div class="uk-container">

    <nav class="tas_search_nav uk-padding-small uk-flex uk-flex-center uk-flex-middle" uk-navbar>

        <div class="uk-navbar-left">
            <a class="uk-navbar-item uk-logo" href="<?php echo $urlPath->home(); ?>">
                <img src="<?php echo $urlPath->image($theme['th_whitelogo']); ?>" alt="<?php echo $translation['tr_1']; ?>">
            </a>
        </div>

        <div class="uk-width-expand search">
            <form method="get" action="<?php echo $urlPath->search(); ?>">
            <div class="uk-inline uk-width-1-1">
                <span class="uk-form-icon uk-form-icon-flip"><i class="ti ti-search"></i></span>

                <?php if(!getSearchQuery() && empty(getSearchQuery())): ?>
                <input class="uk-input uk-width-1-1 uk-border-pill uk-form-large" name="query" placeholder="<?php echo $translation['tr_4']; ?>">
                <?php endif; ?>

                <?php if(getSearchQuery() && !empty(getSearchQuery())): ?>
                <input class="uk-input uk-width-1-1 uk-border-pill uk-form-large" name="query" value="<?php echo echoOutput(getSearchQuery()); ?>" placeholder="<?php echo $translation['tr_4']; ?>">
                <?php endif; ?>

            </div>
            </form>
        </div>

     <div class="uk-navbar-right">

<?php if (isLogged()): ?>

    <div class="uk-grid-small uk-flex-middle" uk-grid>
        <div class="uk-width-auto">
        <div class="uk-cover-container uk-border-circle">
            <img src="<?php echo $urlPath->image($userInfo['user_avatar']); ?>" alt="<?php echo echoOutput($userInfo['user_name']); ?>" uk-cover>
            <canvas width="50" height="50"></canvas>
        </div>
        </div>
        <div class="uk-width-expand">
            
        <?php
          $ndProfile = 'https://conecta.ndmidia.com.br/dashboard/profile.php';
          $ndLogout  = isset($urlPath) && method_exists($urlPath, 'logout')  ? $urlPath->logout()  : '/logout';
          $ndName    = $_SESSION['user_name'] ?? 'Minha conta';
        ?>
        <div class="nd-userbox">
          <button class="nd-userbtn button-header" type="button">
            <i class="ti ti-user-circle" aria-hidden="true"></i>
            <span class="nd-username"><?= htmlspecialchars($ndName, ENT_QUOTES, 'UTF-8') ?></span>
            <i class="ti ti-chevron-down nd-caret" aria-hidden="true"></i>
          </button>

          <div class="nd-usermenu uk-dropdown" uk-dropdown="mode: click; pos: bottom-right; offset:8">
            <div class="nd-userinfo">
              <div class="nd-userfullname"><?= htmlspecialchars($ndName, ENT_QUOTES, 'UTF-8') ?></div>
              <?php if (!empty($_SESSION['user_email'])): ?>
                <div class="nd-useremail"><?= htmlspecialchars($_SESSION['user_email'], ENT_QUOTES, 'UTF-8') ?></div>
              <?php endif; ?>
            </div>
            <div class="nd-divider" role="separator" aria-hidden="true"></div>

            <a role="menuitem" href="<?= htmlspecialchars($ndProfile, ENT_QUOTES, 'UTF-8') ?>">
              <i class="ti ti-id"></i> Ver perfil
            </a>

            <div class="nd-divider" role="separator" aria-hidden="true"></div>

            <form action="<?= htmlspecialchars($ndLogout, ENT_QUOTES, 'UTF-8') ?>" method="post" class="nd-logout">
              <button type="submit" role="menuitem">
                <i class="ti ti-logout"></i> Sair
              </button>
            </form>
          </div>
        </div>
    </div>
    </div>

<?php endif; ?>

<?php if (!isLogged()): ?>
    <div class="nd-auth-actions">
        <a href="https://conecta.ndmidia.com.br/signin" class="uk-button uk-button-default uk-button-large uk-text-bold uk-border-pill button-header">
          <i class="ti ti-user-plus"></i> <span class="label">Entrar</span>
        </a>

        <a href="https://conecta.ndmidia.com.br/dashboard/home.php" class="uk-button uk-button-primary uk-button-large uk-text-bold uk-border-pill button-header">
          <i class="ti ti-lock"></i> <span class="label">Anunciante</span>
        </a>

        <a href="https://conecta.ndmidia.com.br/dashboard/associate_login.php" class="uk-button uk-button-default uk-button-large uk-text-bold uk-border-pill button-header">
          <i class="ti ti-qrcode"></i> <span class="label">Associado</span>
        </a>
    </div>
<?php endif; ?>

</div>

</nav>
</div>

<div class="uk-section-default uk-visible@m">

<nav class="tas_search_nav tas_search_nav_2" uk-navbar>
    <div class="uk-navbar-center">
        <ul class="uk-navbar-nav">
        <?php foreach($navigationHeader as $item): ?>
                 <?php if ($item['navigation_type'] == 'custom') { ?>
                    <?php if($item['navigation_url'] == '/'){ ?>
                    <li <?php if ($index_url == "index.php") echo ' class="uk-active"'; ?>><a href="<?php echo $urlPath->home(); ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
                    <?php }else{ ?>
                    <li <?php if ($current_url == $item['navigation_url']) echo ' class="uk-active"'; ?>><a href="<?php echo $item['navigation_url']; ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
                    <?php } ?>
                 <?php } else { ?>
                     <li <?php if ($current_url == $item['navigation_url']) echo ' class="uk-active"'; ?>><a href="<?php echo $urlPath->page($item['navigation_url']); ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
                 <?php } ?>
             <?php endforeach; ?>
        </ul>
    </div>

</nav>
<script>
(function(){
  try {
    var anchors = document.querySelectorAll('a.button-header, a[href$="/login"], a[href="./login"]');
    anchors.forEach(function(a){

 try{
          if (!a) return;
          var txt = (a.textContent || '').toLowerCase();
//          if (txt.indexOf('login') !== -1 || /(^|\\.\\/|\\/)login(\\/)?(\\?|#|$)/i.test(a.getAttribute('href')||'')) {
 //             a.setAttribute('href', '/signin');
  //        }
      }catch (e){}


    });
  } catch (e) {}
})();
</script>

</div>
</div>

<?php require './sections/mobile-header.php'; ?>

<!-- === Mobile Offcanvas (sidemenu) === -->
<?php if (file_exists(__DIR__ . '/../sidemenu.php')) { require __DIR__ . '/../sidemenu.php'; } ?>


<style>
/* ===== Consolidação e ajustes finos ===== */
.uk-navbar-container, .uk-navbar, .tas_head_wrap { overflow: visible !important; }
.nd-usermenu { z-index: 10000 !important; }

/* Ícone + texto nos botões */
.button-header .label{display:inline !important;margin-left:.5rem}

/* Bloco dos botões (visitante) */
.nd-auth-actions{ display:flex; align-items:center; gap:12px; }

/* Tamanho/altura idênticos */
.nd-auth-actions .button-header{
  height:42px; padding:0 16px; border-radius:9999px;
  display:inline-flex; align-items:center; line-height:42px; border-width:1px;
}
.nd-auth-actions .button-header i{ font-size:1rem; line-height:1; }

/* Cadastro = outline */
.nd-auth-actions .uk-button-default{
  background:transparent; border:1px solid rgba(255,255,255,.45); color:#fff;
}
.nd-auth-actions .uk-button-default:hover{
  border-color:#fff; background:rgba(255,255,255,.08);
}

/* Entrar = sólido sutil */
.nd-auth-actions a.button-header:not(.uk-button-default){
  background:rgba(255,255,255,.12); color:#fff; border:1px solid rgba(255,255,255,.25);
}
.nd-auth-actions a.button-header:not(.uk-button-default):hover{
  filter:brightness(1.08);
}

/* Responsivo */
@media (max-width:1200px){
  .nd-auth-actions .button-header{ height:38px; padding:0 12px; line-height:38px; }
}

/* Dropdown inline (logado) */
.nd-userbox{position:relative;display:flex;align-items:center;gap:.5rem}
.nd-userbtn{display:inline-flex;align-items:center;gap:.45rem;border-radius:9999px;padding:.40rem .90rem;font-weight:600}
.nd-userbtn i{font-size:1.05rem;line-height:1}
.nd-caret{margin-left:.2rem}
.nd-usermenu{
  background:#fff;border:1px solid rgba(0,0,0,.06);border-radius:12px;
  box-shadow:0 12px 32px rgba(16,24,40,.10), 0 2px 8px rgba(16,24,40,.06);
  min-width:220px;padding:.35rem;
}
.nd-usermenu a,.nd-usermenu button{
  display:flex;align-items:center;gap:.5rem;width:100%;text-align:left;
  padding:.625rem .75rem;border:0;background:none;font-weight:500;border-radius:10px;cursor:pointer;
}
.nd-usermenu a:hover,.nd-usermenu button:hover{background:#f6f7fb}
.nd-usermenu .nd-logout button{color:#b42318}
.nd-userinfo{padding:.5rem .75rem .35rem .75rem}
.nd-userfullname{font-weight:700}
.nd-useremail{font-size:.85rem;color:#6b7280}
.nd-divider{height:1px;background:rgba(0,0,0,.06);margin:.25rem .35rem}
</style>
