<?php
if (!function_exists('nd_val')) {
  function nd_val($src, $key) {
    if (is_array($src)) return array_key_exists($key,$src) ? $src[$key] : null;
    if (is_object($src)) return isset($src->$key) ? $src->$key : null;
    return null;
  }
}
if (!function_exists('nd_compute_time_left')) {
  function nd_compute_time_left($item) {
    $now = time();
    $startAliases = ['start_date','start_at','start_time','start','start_data','valid_from','begins_at'];
    $endAliases   = ['expire_date','expire_at','expires_at','expire_time','expiry','end_date','end_time','valid_until','valid_to','data_fim'];
    $startTs = null; $endTs = null;
    foreach ($startAliases as $k) {
      $v = nd_val($item,$k);
      if ($v !== null && $v !== '') { $ts = is_numeric($v) ? (int)$v : @strtotime((string)$v); if ($ts) { $startTs = $ts; break; } }
    }
    foreach ($endAliases as $k) {
      $v = nd_val($item,$k);
      if ($v !== null && $v !== '') { $ts = is_numeric($v) ? (int)$v : @strtotime((string)$v); if ($ts) { $endTs = $ts; break; } }
    }
    if (!$endTs) return null;
    if ($endTs <= $now) return null;
    if ($startTs && $now < $startTs) return null;
    return $endTs - $now;
  }
}

/* sections/views/latest-deals.view.php — robusto c/ fallbacks e i18n */

$deals = $latestDeals ?? [];
$h = fn($v) => htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
?>
<div class="uk-container uk-margin-top uk-margin-large-bottom" uk-scrollspy="target: > div; cls: uk-animation-fade; delay: 100">

  <div class="tas_heading uk-grid-collapse uk-flex uk-flex-middle" uk-grid>
    <div class="uk-width-expand">
      <h3 class="uk-h4">
        <?= isset($translation['HOME_LATEST_DEALS']) ? $translation['HOME_LATEST_DEALS'] : 'Últimas Ofertas'; ?>
      </h3>
    </div>
    <div class="uk-width-auto">
      <a href="<?php echo $urlPath->search(['sort'=>'latest']); ?>" class="uk-button uk-button-default uk-border-pill btn">
        <?= isset($translation['BTN_VIEW_ALL']) ? $translation['BTN_VIEW_ALL'] : 'Ver tudo'; ?>
        <i class="ti ti-chevron-right"></i>
      </a>
    </div>
  </div>

  <div class="nd-grid uk-margin-medium-top">

    <?php if (!empty($deals) && is_array($deals)): ?>
      <?php foreach ($deals as $item): ?>
        <?php
          // --------- Título ---------
          $title = $item['deal_title'] ?? ($item['title'] ?? ($item['coupon_title'] ?? ''));

          // --------- HREF robusto (ordem de preferência) ---------
          $href = $item['detail_link'] ?? $item['permalink'] ?? '';
          if ($href === '' || $href === null) {
              $slug   = trim($item['deal_slug'] ?? ($item['slug'] ?? ''));
              $dealId = isset($item['deal_id']) ? (int)$item['deal_id'] : 0;

              if ($slug !== '') {
                  $href = './?slug=' . rawurlencode($slug);
              } elseif ($dealId > 0) {
                  $href = './?deal_id=' . $dealId;
              } else {
                  $href = '#';
              }
          }

          // --------- Imagem (usa deal_image_url se o controller já montou) ---------
          $imgUrl = $item['deal_image_url'] ?? '';
          if ($imgUrl === '' || $imgUrl === null) {
              $img = $item['deal_image'] ?? ($item['image'] ?? '');
              $imgUrl = $img ? $urlPath->image($img) : $urlPath->image('');
          }

          // Preço (opcional)
          $price = $item['deal_price'] ?? null;
        ?>
        <?php

        
        include_once __DIR__ . '/../../partials/card-deal-pro.php';
                        // EXTENDED COMPAT SHIM (array|object): converte campos do DB para aliases novos
      if (is_array($item)) {
        if (isset($item['ends_at'])     && !isset($item['expire_at'])) $item['expire_at'] = $item['ends_at'];
        if (isset($item['endtime'])     && !isset($item['end_time']))  $item['end_time']  = $item['endtime'];
        if (isset($item['starts_at'])   && !isset($item['start_at']))  $item['start_at']  = $item['starts_at'];
        if (isset($item['deal_expire']) && !isset($item['expire_at'])) $item['expire_at'] = $item['deal_expire'];
        if (isset($item['deal_start'])  && !isset($item['start_at']))  $item['start_at']  = $item['deal_start'];
      } elseif (is_object($item)) {
        if (isset($item->ends_at)     && !isset($item->expire_at)) $item->expire_at = $item->ends_at;
        if (isset($item->endtime)     && !isset($item->end_time))  $item->end_time  = $item->endtime;
        if (isset($item->starts_at)   && !isset($item->start_at))  $item->start_at  = $item->starts_at;
        if (isset($item->deal_expire) && !isset($item->expire_at)) $item->expire_at = $item->deal_expire;
        if (isset($item->deal_start)  && !isset($item->start_at))  $item->start_at  = $item->deal_start;
      }

      $item['time_left'] = nd_compute_time_left($item);
echo nd_render_deal_card($item, $urlPath, $translation);
    ?>
      <?php endforeach; ?>
    <?php else: ?>
      <div class="uk-width-1-1">
        <p class="uk-text-muted">—</p>
      </div>
    <?php endif; ?>

  </div>

</div>
