<?php
// Modal de denúncia de oferta
// Este arquivo é incluído pelo footer em praticamente todas as páginas,
// então precisamos garantir que ele NUNCA quebre se variáveis não existirem.

// Traduções seguras
if (!isset($translation) || !is_array($translation)) { $translation = []; }
$__tr = function($key, $fallback){
    return isset($translation[$key]) ? $translation[$key] : $fallback;
};

// Garante estrutura básica de $itemDetails (nem toda página define isso)
if (!isset($itemDetails) || !is_array($itemDetails)) {
    $itemDetails = [
        'deal_id'    => '',
        'deal_title' => '',
        'deal_image' => '',
        'deal_slug'  => '',
    ];
}

// Caminhos auxiliares
$__signin  = '/signin';
$__itemImg = '';
$__itemUrl = '';

if (isset($urlPath) && is_object($urlPath)) {
    if (method_exists($urlPath, 'signin')) {
        $__signin = $urlPath->signin();
    }
    if (method_exists($urlPath, 'image') && !empty($itemDetails['deal_image'])) {
        $__itemImg = $urlPath->image($itemDetails['deal_image']);
    }
    if (method_exists($urlPath, 'deal') && !empty($itemDetails['deal_id'])) {
        $__itemUrl = $urlPath->deal($itemDetails['deal_id'], $itemDetails['deal_slug'] ?? '');
    }
}

$__isLogged = function_exists('isLogged') ? isLogged() : false;
?>
<div id="report-modal" class="uk-flex-top" uk-modal>
    <div class="tas-modal uk-modal-dialog uk-margin-auto-vertical">
        <button class="uk-modal-close-default" type="button" uk-close></button>

        <div class="uk-modal-header">
            <h2 class="modal_title">
                <?php echo echoOutput($__tr('tr_346','Denunciar oferta')); ?>
            </h2>
        </div>

        <div class="uk-modal-body">

        <?php if ($__isLogged): ?>

            <form class="uk-form" method="post" id="reportForm">
                <div class="form_fields">
                    <input value="<?php echo echoOutput($itemDetails['deal_id']); ?>" name="item_id" type="text" hidden>
                    <input value="<?php echo echoOutput($itemDetails['deal_title']); ?>" name="item_title" type="text" hidden>
                    <input value="<?php echo echoOutput($__itemImg); ?>" name="item_image" type="text" hidden>
                    <input value="<?php echo echoOutput($__itemUrl); ?>" name="item_url" type="text" hidden>

                    <div class="uk-margin-small">
                        <div class="uk-width-1-1 uk-inline">
                            <span class="uk-form-icon" uk-icon="icon: user"></span>
                            <input class="uk-input uk-border-rounded uk-form-large"
                                   placeholder="<?php echo echoOutput($__tr('tr_139','Seu nome')); ?>"
                                   name="name" type="text" required>
                        </div>
                    </div>

                    <div class="uk-margin-small">
                        <div class="uk-width-1-1 uk-inline">
                            <span class="uk-form-icon" uk-icon="icon: mail"></span>
                            <input class="uk-input uk-border-rounded uk-form-large"
                                   placeholder="<?php echo echoOutput($__tr('tr_145','Seu e-mail')); ?>"
                                   name="email" type="email" required>
                        </div>
                    </div>

                    <div class="uk-margin-small">
                        <textarea class="uk-textarea uk-border-rounded uk-form-large"
                                  rows="4"
                                  placeholder="<?php echo echoOutput($__tr('tr_347','Descreva o problema com esta oferta')); ?>"
                                  name="message" required></textarea>
                    </div>

                    <div class="uk-margin-small">
                        <button class="uk-button uk-button-primary uk-border-rounded uk-width-1-1"
                                type="submit">
                            <?php echo echoOutput($__tr('tr_346','Enviar denúncia')); ?>
                        </button>
                    </div>
                </div>
            </form>

        <?php else: ?>

            <p>
                <?php echo echoOutput($__tr('tr_347','Para denunciar você precisa estar logado.')); ?>
            </p>
            <a href="<?php echo $__signin; ?>"
               class="uk-button uk-button-primary uk-border-rounded">
               <?php echo echoOutput($__tr('tr_48','Entrar')); ?>
            </a>

        <?php endif; ?>

        </div>
    </div>
</div>
