<?php
$totalValid      = isset($totalValid) ? (int)$totalValid : null;
$resultsReviews  = isset($resultsReviews) && is_array($resultsReviews) ? $resultsReviews : [];
$derivedCount    = count($resultsReviews);
$totalReviews    = $totalValid !== null ? $totalValid : (int)($totalReviews ?? $derivedCount);
if ($totalReviews === 0) { $resultsReviews = []; } // força não listar quando vazio

$canWrite        = !empty($canWrite);
$loginUrl        = isset($loginUrl) ? $loginUrl : '/signin';
$avg             = isset($avgRating) ? max(0,min(5,(float)$avgRating)) : 0;
$full            = (int)round($avg);
?>
<div class="uk-width-1-1 reviews" id="reviews-item">
  <h4 class="section_title_details"><?php echo echoOutput($translation['tr_51']); ?> (<?= $totalReviews; ?>)</h4>

  <div class="nd-aggregate uk-flex uk-flex-middle uk-margin-small">
    <span class="nd-stars" aria-label="Média de avaliação">
      <?php for($i=0;$i<5;$i++): ?>
        <span class="nd-star<?= $i < $full ? ' nd-star--filled' : '' ?>">★</span>
      <?php endfor; ?>
    </span>
    <span class="nd-score uk-text-bold uk-margin-small-left"><?= number_format($avg,1,',','.'); ?>/5</span>
    <span class="nd-count uk-text-meta uk-margin-small-left">(<?= $totalReviews; ?> avaliações)</span>
  </div>

  <div class="uk-flex uk-flex-middle uk-margin-small">
    <div class="uk-margin-auto-left">
      <?php if ($canWrite): ?>
        <a href="#submit-review" class="uk-button uk-button-default uk-button-small uk-border-pill" uk-toggle>Escrever avaliação</a>
      <?php else: ?>
        <a href="<?= htmlspecialchars($loginUrl, ENT_QUOTES, 'UTF-8'); ?>" class="uk-button uk-button-primary uk-button-small uk-border-pill">Entrar para avaliar</a>
      <?php endif; ?>
    </div>
  </div>

  <hr>

  <?php if ($totalReviews > 0 && !empty($resultsReviews)): ?>
    <?php foreach ($resultsReviews as $item): ?>
      <div class="uk-comment uk-margin">
        <header class="uk-comment-header uk-grid-medium uk-flex-middle" uk-grid>
          <div class="uk-width-auto">
            <div class="uk-border-circle uk-background-muted" style="width:40px;height:40px;"></div>
          </div>
          <div class="uk-width-expand">
            <ul class="uk-comment-meta uk-subnav uk-subnav-divider uk-margin-remove-top">
              <li><?= htmlspecialchars(substr((string)($item['created'] ?? ''), 0, 10), ENT_QUOTES, 'UTF-8'); ?></li>
              <?php if (!empty($item['rating'])): ?>
                <li><span uk-icon="star" style="color:#FFC107"></span></li>
              <?php endif; ?>
            </ul>
          </div>
        </header>
        <div class="uk-comment-body">
          <?php if(!empty($item['comment'])): ?>
            <p><?= htmlspecialchars($item['comment'], ENT_QUOTES, 'UTF-8'); ?></p>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  <?php else: ?><?php endif; ?>
</div>
