
<style>
/* ND: reforço de contraste no offcanvas (mobile menu) */
.uk-offcanvas-bar {
  background:#ffffff;
  color:#222;
  border-radius: 16px 0 0 16px;
  box-shadow: -12px 0 30px rgba(15, 23, 42, 0.12);
  transition: transform .25s ease-out, box-shadow .25s ease-out;
}
.uk-offcanvas-bar a { color:#222; }
.tas-main-menu > li > a { color:#222 !important; }

/* ND append */
.tas-sidemenu .tas-btn{display:none!important}
.tas-main-menu a[href$="/signin"],.tas-main-menu a[href$="/signup"]{display:none!important}

/* Botões com borda mais suave e animação */
.nd-auth-btn--signin,
.nd-auth-btn--signup,
.nd-auth-btn--associate,
.nd-auth-btn--advertiser {
  background: transparent;
  border:1px solid rgba(0, 102, 204, 0.08);
  color:var(--primary-color);
}

.uk-offcanvas-bar .nd-auth-btn--signin:hover,
.uk-offcanvas-bar .nd-auth-btn--signup:hover,
.uk-offcanvas-bar .nd-auth-btn--associate:hover {
  background:#f5f7ff;
}

.nd-auth-block .button-header {
  text-align:left;
  justify-content:flex-start;
  border-radius:999px;
}

.nd-auth-block .uk-button {
  display:flex;
  align-items:center;
  gap:8px;
  box-shadow:0 2px 8px rgba(15, 23, 42, 0.06);
  transition: background-color .18s ease, border-color .18s ease, transform .12s ease, box-shadow .18s ease;
}

.nd-auth-block .uk-button:hover {
  transform: translateY(-1px);
  box-shadow:0 4px 14px rgba(15, 23, 42, 0.10);
}

/* menu links mais suaves */
.tas-main-menu li a {
  padding-top:6px;
  padding-bottom:6px;
  transition: color .15s ease, padding-left .15s ease;
}
.tas-main-menu li a:hover {
  padding-left:14px;
}
</style>

<!-- SIDEMENU -->

<div class="tas-sidemenu" id="sidemenu" uk-offcanvas="overlay: true;">

    <div class="uk-offcanvas-bar uk-flex uk-flex-column">

        <?php
if(!isLogged()): ?>

        <div class="uk-width-1-1 uk-flex uk-flex-middle uk-flex-center">
            <a href="<?php echo $urlPath->home(); ?>">
<?php if (!empty($theme['th_logo'])): ?>
  <img class="uk-logo" style="max-height:48px" src="<?php echo $urlPath->image($theme['th_logo']); ?>" alt="<?php echo $translation['tr_1']; ?>">
<?php else: ?>
  <span class="uk-text-bold uk-text-large"><?php echo $translation['tr_1']; ?></span>
<?php endif; ?>
<hr class="uk-margin-small"></a>
        </div><?php endif; ?>

        <?php if(isLogged()): ?>

            <div class="uk-flex uk-flex-left uk-padding-small">
                <article class="uk-comment tas-profile-header">
                <header class="uk-comment-header">
                    <div class="uk-grid-small uk-flex-middle" uk-grid>
                        <div class="uk-width-auto">

                        <div class="uk-cover-container uk-border-circle">
                            <img src="<?php echo $urlPath->image($userInfo['user_avatar']); ?>" alt="<?php echo echoOutput($userInfo['user_name']); ?>" class="uk-comment-avatar" uk-cover>
                            <canvas width="50" height="50"></canvas>
                        </div>

                        </div>
                            <div class="uk-width-expand">
                        <a class="uk-link-reset" href="https://conecta.ndmidia.com.br/dashboard/profile.php">
                            <h5 class="uk-comment-title uk-margin-remove uk-text-truncate"><?php echo echoOutput(textTruncate($userInfo['user_name'], 10)); ?></h5>
                        </a>
                            </div>
                    </div>
                </header>
            </article>
        </div>
        <?php endif; ?>


        <form class="uk-search uk-search-default uk-margin-small-top uk-margin-small-bottom" method="get" action="<?php echo $urlPath->search(); ?>">
    <span uk-search-icon></span>
    <?php if(!getSearchQuery() && empty(getSearchQuery())): ?>
                <input class="uk-search-input uk-border-rounded" name="query" placeholder="<?php echo $translation['tr_4']; ?>">
                <?php endif; ?>

                <?php if(getSearchQuery() && !empty(getSearchQuery())): ?>
                <input class="uk-search-input uk-border-rounded" name="query" value="<?php echo echoOutput(getSearchQuery()); ?>" placeholder="<?php echo $translation['tr_4']; ?>">
                <?php endif; ?>
</form>
<?php if (!isLogged()): ?>
<div class="uk-margin-small-top nd-auth-block">
  <a href="https://conecta.ndmidia.com.br/signin"
     class="uk-button uk-button-default uk-button-large uk-text-bold uk-border-pill button-header nd-auth-btn nd-auth-btn--signin uk-width-1-1">
     <i class="ti ti-user-plus uk-margin-small-right"></i> Entrar
  </a>

  <a href="https://conecta.ndmidia.com.br/dashboard/home.php"
     class="uk-button uk-button-default uk-button-large uk-text-bold uk-border-pill button-header nd-auth-btn nd-auth-btn--advertiser uk-width-1-1 uk-margin-small-top">
     <i class="ti ti-lock uk-margin-small-right"></i> Anunciante
  </a>

  <a href="https://conecta.ndmidia.com.br/dashboard/associate_login.php"
     class="uk-button uk-button-default uk-button-large uk-text-bold uk-border-pill button-header nd-auth-btn nd-auth-btn--associate uk-width-1-1 uk-margin-small-top">
     <i class="ti ti-qrcode uk-margin-small-right"></i> Associado
  </a>
</div>
<hr class="uk-margin-small">
<?php endif; ?>




        <ul class="tas-main-menu uk-nav-default uk-margin-small-bottom uk-margin-small-top" uk-nav>
        <?php foreach($navigationSidebar as $item): ?>
        <?php if ($item['navigation_type'] == 'custom') { ?>
        <?php if($item['navigation_url'] == '/'){ ?>
        <li><a href="<?php echo $urlPath->home(); ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
        <?php }else{ ?>
        <li><a href="<?php echo $item['navigation_url']; ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
        <?php } ?>
        <?php } else { ?>
        <li><a href="<?php echo $urlPath->page($item['navigation_url']); ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
        <?php } ?>
        <?php endforeach; ?>
        </ul>

        <?php if(isLogged()): ?>
        <hr class="uk-margin-small">
        <a href="<?php echo $urlPath->signout(); ?>" class="tas-btn uk-button uk-button-default uk-border-rounded">
        <?php echo $translation['tr_181']; ?>
        </a>
        <?php endif; ?>



    </div>

</div>

<!-- END SIDEMENU -->