<?php
// Safe defaults for this section (footer include)
if (!isset($translation) || !is_array($translation)) { $translation = []; }
$__tr = function($key, $fallback){ return isset($translation[$key]) ? $translation[$key] : $fallback; };
if (!isset($urlPath) || !is_object($urlPath) || !method_exists($urlPath, 'signin')) {
  $__signin = '/signin';
} else {
  $__signin = $urlPath->signin();
}
$__isLogged = function_exists('isLogged') ? isLogged() : false;

// Garante estrutura básica para $itemDetails (nem toda página define este array)
if (!isset($itemDetails) || !is_array($itemDetails)) {
  $itemDetails = ['deal_id' => ''];
}
?>
<link rel="stylesheet" href="/assets/css/nd-review-stars.css">
<div id="submit-review" class="uk-flex-top" uk-modal>
    <div class="tas-modal uk-modal-dialog uk-margin-auto-vertical">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="modal_title"><?php
echo echoOutput($__tr('tr_118','Avaliações')); ?></h2>
        </div>

        <div class="uk-modal-body">

        <?php if ($__isLogged): ?>

        <form class="uk-form" method="post" id="formRating" data-review-form>

        <div class="form_fields">

        <input value="<?php echo $itemDetails['deal_id']; ?>" name="item" type="text" hidden>

        <div class="uk-margin-small">
  <label class="uk-form-label">Nota (0–5)</label>
  <div class="nd-stars-input">
    <input type="radio" id="star-5" name="rating" value="5" checked>
    <label for="star-5">★</label>
    <input type="radio" id="star-4" name="rating" value="4">
    <label for="star-4">★</label>
    <input type="radio" id="star-3" name="rating" value="3">
    <label for="star-3">★</label>
    <input type="radio" id="star-2" name="rating" value="2">
    <label for="star-2">★</label>
    <input type="radio" id="star-1" name="rating" value="1">
    <label for="star-1">★</label>
  </div>
  <span class="uk-text-meta nd-rating-output">5/5</span>
</div>


        <textarea class="uk-width-1-1 uk-textarea uk-border-rounded uk-margin-small-top" name="comment" cols="30" rows="3" placeholder="<?php echo echoOutput($__tr('tr_125','')); ?>"></textarea>
        <button type="submit" class="uk-button uk-button-primary uk-margin-small-top uk-border-rounded" value="<?php echo echoOutput($__tr('tr_126','')); ?>" id="btn-review"><?php echo echoOutput($__tr('tr_126','')); ?></button>
        
        </div>
        
        <div id="showReviewresults"></div>

        </form>
            
        <?php endif; ?>

        <?php if (!$__isLogged): ?>

        <p><?php echo echoOutput($__tr('tr_124','Enviar')); ?></p>
        <a href="<?php echo $__signin; ?>" class="uk-button uk-button-primary uk-border-rounded"><?php echo echoOutput($__tr('tr_48','Entrar')); ?></a>
            
        <?php endif; ?>

        </div>

    </div>
</div>