<?php declare(strict_types=1);
/**
 * /signup.php — versão limpa e padronizada
 * - strict_types primeiro, sem BOM/sem espaços antes
 * - Sem saída antes do PHP
 * - Apenas UM require de core.php
 * - Sem "?>" final
 */

if (function_exists('ob_get_level') && ob_get_level() === 0) { ob_start(); }
require __DIR__ . '/core.php';

// i18n com fallbacks
if (!isset($translation) || !is_array($translation)) { $translation = []; }
$translation += [
    'tr_signuppage' => $translation['tr_signuppage'] ?? 'Create Account',
    'tr_1'          => $translation['tr_1'] ?? 'Home',
    'tr_3'          => $translation['tr_3'] ?? 'Descrição do site',
    'tr_158'        => $translation['tr_158'] ?? 'Por favor, informe o e-mail.',
    'tr_163'        => $translation['tr_163'] ?? 'E-mail inválido.',
    'tr_160'        => $translation['tr_160'] ?? 'Por favor, informe a senha.',
    'tr_174'        => $translation['tr_174'] ?? 'E-mail ou senha incorretos.',
    'tr_400'        => $translation['tr_400'] ?? 'Senha deve ter ao menos 6 caracteres.',
    'tr_401'        => $translation['tr_401'] ?? 'As senhas não coincidem.',
    'tr_402'        => $translation['tr_402'] ?? 'E-mail já cadastrado.',
    'tr_success'    => $translation['tr_success'] ?? 'Conta criada com sucesso. Verifique seu e-mail.',
    'tr_161'        => $translation['tr_161'] ?? 'Falha no reCAPTCHA.',
];

$titleSeoHeader       = getSeoTitle($translation['tr_1'], $translation['tr_signuppage']);
$descriptionSeoHeader = getSeoDescription($translation['tr_3']);

$errors = [];
$success = '';

if (isLogged()) {
    header('Location: ' . $urlPath->home());
    exit;
}

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
    $email = strtolower((string)($_POST['user_email'] ?? ''));
    $email = filter_var($email, FILTER_SANITIZE_EMAIL);
    $pass  = (string)($_POST['user_password'] ?? '');
    $pass2 = (string)($_POST['user_password_confirm'] ?? '');
    $name  = trim((string)($_POST['user_name'] ?? ''));

    if ($email === '') {
        $errors[] = $translation['tr_158'];
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = $translation['tr_163'];
    }

    if ($pass === '') {
        $errors[] = $translation['tr_160'];
    } elseif (strlen($pass) < 6) {
        $errors[] = $translation['tr_400'];
    }

    if ($pass !== $pass2) {
        $errors[] = $translation['tr_401'];
    }

    // reCAPTCHA (se habilitado)
    if ((int)($settings['st_recaptcha_enable'] ?? 0) === 1) {
        $secretKey = (string)($settings['st_recaptchasecretkey'] ?? '');
        $verifyCaptcha = (string)($_POST['g-recaptcha-response'] ?? '');
        if ($secretKey && $verifyCaptcha) {
            $recaptchaUrl = "https://www.google.com/recaptcha/api/siteverify?secret={$secretKey}&response={$verifyCaptcha}";
            $verify = @json_decode(@file_get_contents($recaptchaUrl), true);
            if (!$verify or empty($verify['success'])) {
                $errors[] = $translation['tr_161'];
            }
        } else {
            $errors[] = $translation['tr_161'];
        }
    }

    if (empty($errors)) {
        try {
            // E-mail já cadastrado?
            $st = $connect->prepare("SELECT 1 FROM users WHERE user_email = :email LIMIT 1");
            $st->execute([':email' => $email]);
            if ($st->fetch()) {
                $errors[] = $translation['tr_402'];
            }
        } catch (Throwable $e) {
            $errors[] = $translation['tr_168'] ?? 'Algo deu errado. Tente novamente.';
        }
    }

    if (empty($errors)) {
        try {
            $hash = hash('sha512', $pass);
            $ins = $connect->prepare("INSERT INTO users (user_email, user_password, user_name, user_status, user_verified) VALUES (:email, :pwd, :name, 1, 0)");
            $ins->execute([':email' => $email, ':pwd' => $hash, ':name' => $name]);
            $success = $translation['tr_success'];
            // TODO: enviar e-mail de verificação, se aplicável
        } catch (Throwable $e) {
            $errors[] = $translation['tr_168'] ?? 'Algo deu errado. Tente novamente.';
        }
    }
}

require __DIR__ . '/header.php';
require __DIR__ . '/views/signup.view.php';
require __DIR__ . '/footer.php';
