<?php

require "core.php";

// Get Item Slug
$itemId = clearGetData(getItemId());

if(empty($itemId)){

	header('Location: '. $urlPath->home());
	exit();
}

// Page Details
$itemDetails = getDealById($connect, $itemId);

if(empty($itemDetails)){

	header('Location: '. $urlPath->error());
	exit();
}


if($itemDetails['deal_exclusive'] == 1 && $settings['st_access_registered_only_exclusive'] == 1){

if (!isLogged()) {

	header('Location: '. $urlPath->private());
	exit();

}}

if($settings['st_access_registered_only'] == 1){

	if (!isLogged()) {
	
		header('Location: '. $urlPath->private());
		exit();
		
}}

insertTrack($connect, $itemId);

// ND: registra visualização da oferta (para relatórios)
if (function_exists('nd_track_event') && isset($connect) && $connect) {
	try {
		$storeId = isset($itemDetails['deal_store']) ? (int)$itemDetails['deal_store'] : 0;
		nd_track_event($connect, 'view_deal', [
			'deal_id'  => (int)$itemId,
			'store_id' => ($storeId > 0 ? $storeId : null),
		]);
	} catch (Throwable $e) {}
}

$itemsGallery = getItemsGallery($connect, $itemId);

// Cupons vinculados a esta oferta (caso a função/tabela exista)
$dealCoupons = [];
if (function_exists('getDealCoupons') && isset($connect)) {
	try {
		$dealCoupons = getDealCoupons($connect, (int)$itemId, 20);
	} catch (Throwable $e) {
		$dealCoupons = [];
	}
}

// Seo Title
$titleSeoHeader = getSeoTitle(empty($itemDetails['deal_seotitle']) || $itemDetails['deal_seotitle'] == " " ? $itemDetails['deal_title'] : $itemDetails['deal_seotitle']);

// Seo Description
$descriptionSeoHeader = getSeoDescription($translation['tr_3'], $itemDetails['deal_description'], $itemDetails['deal_seodescription']);

// Page Title
$pageTitle = $itemDetails['deal_title'];

if (isLogged()) {

$isFav = isInFav($connect, $userInfo['user_id'], $itemId);

}



// Cupons desta oferta (se existirem)
$dealCoupons = [];
if (isset($connect) && $connect instanceof PDO && function_exists('getDealCoupons')) {
    try {
        $dealCoupons = getDealCoupons($connect, (int)$itemId, 50);
    } catch (Throwable $e) {
        $dealCoupons = [];
    }
}

include './header.php';
require './views/single-deal.view.php';
include './footer.php';

?>