<?php


declare(strict_types=1);
require "core.php";

$slugItem = clearGetData(getSlugItem());

if (empty($slugItem) && !isset($slugItem)) {
    header('Location: ' . $urlPath->home());
    exit;
}

// Get ID By Slug
$itemDetails = getLocationBySlug($connect, $slugItem);

if (empty($itemDetails)) {
    header('Location: ' . $urlPath->error());
    exit;
}

// Busca os deals da localização
$getResults = getDealsByLocation($connect, $site_config['page_limit'], (int)$itemDetails['location_id']);

// ---------- Normalização do retorno (evita Undefined array key "items"/"total") ----------
$items = [];
$total = 0;

if (is_array($getResults)) {
    // PHP 8.1+: verifica se é lista indexada (0..n-1)
    if (function_exists('array_is_list') && array_is_list($getResults)) {
        $items = $getResults;
        $total = count($items);
    } else {
        // Formato com chaves nomeadas?
        if (isset($getResults['items']) && is_array($getResults['items'])) {
            $items = $getResults['items'];
            $total = isset($getResults['total']) ? (int)$getResults['total'] : count($items);
        } else {
            // Qualquer outro formato: usa como lista
            $items = array_values($getResults);
            $total = count($items);
        }
    }
}

// Paginação
$numPages = numTotalPages($total, (int)$site_config['page_limit']);

// Seo Title
$titleSeoHeader = getSeoTitle(
    $translation['tr_1'],
    (empty($itemDetails['location_seotitle']) || $itemDetails['location_seotitle'] == " ")
        ? $itemDetails['location_title']
        : $itemDetails['location_seotitle']
);

// Seo Description
$descriptionSeoHeader = getSeoDescription(
    $translation['tr_3'],
    $itemDetails['location_description'],
    $itemDetails['location_seodescription']
);

// Page Title
$pageTitle = $itemDetails['location_title'];

include './header.php';
require './views/single-location.view.php';
include './footer.php';

?>
