<?php


declare(strict_types=1);
require "core.php";

// Get Item Slug
$slugItem = clearGetData(getSlugItem());

if(empty($slugItem) && !isset($slugItem)){

	header('Location: '. $urlPath->home());
}

// Get ID By Slug
$itemDetails = getPageBySlug($connect, $slugItem);
if (!$itemDetails || !is_array($itemDetails)) {
    http_response_code(404);
    if (file_exists(__DIR__ . '/error.php')) { require __DIR__ . '/error.php'; }
    else { echo '<!doctype html><meta charset="utf-8"><title>404</title><h1>Página não encontrada</h1>'; }
    exit;
}


if(empty($itemDetails)){

	header('Location: '. $urlPath->error());
}

if($itemDetails['page_private'] == 1 && !isLogged()){

	header('Location: '. $urlPath->private());
}

// Seo Title
$titleSeoHeader = getSeoTitle(empty($itemDetails['page_seotitle']) || $itemDetails['page_seotitle'] == " " ? $itemDetails['page_title'] : $itemDetails['page_seotitle']);

// Seo Description
$descriptionSeoHeader = getSeoDescription($translation['tr_3'], $itemDetails['page_content'], $itemDetails['page_seodescription']);

// Page Title
$pageTitle = $itemDetails['page_title'];

include './header.php';
include './sections/header.php';

if ($itemDetails['page_template'] == 'blank') {

	require './views/single-page.view.php';

}elseif ($itemDetails['page_template'] == 'search') {
	
	require './pages/search.php';

}elseif ($itemDetails['page_template'] == 'categories') {
	
	require './pages/categories.php';

}elseif ($itemDetails['page_template'] == 'locations') {
	
	require './pages/locations.php';

}elseif ($itemDetails['page_template'] == 'stores') {
	
	require './pages/stores.php';

}elseif ($itemDetails['page_template'] == 'contact') {
	
require './pages/contact.php';

}elseif ($itemDetails['page_template'] == 'pricing') {
	
	require './pages/pricing.php';
	
	}else{

	require './views/single-page.view.php';
}
	
include './sections/views/footer-ad.view.php';

if($itemDetails['page_show_footer'] == 1):
include './sections/footer.php';
endif;

include './footer.php';

?>