<?php
declare(strict_types=1);

require __DIR__ . '/core.php';

// Slug da loja vindo da URL amigável /store/{slug}
$slugItem = clearGetData(getSlugItem());

if (empty($slugItem)) {
    if (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'stores')) {
        header('Location: ' . $urlPath->stores());
    } else {
        header('Location: ' . SITE_URL);
    }
    exit;
}

// Dados da loja
$store = getStoreBySlug($connect, $slugItem);

if (!$store || !isset($store['store_id'])) {
    // Loja não encontrada → volta para listagem
    if (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'stores')) {
        header('Location: ' . $urlPath->stores());
    } else {
        header('Location: ' . SITE_URL);
    }
    exit;
}

$storeId = (int)$store['store_id'];

// Ofertas ativas da loja (catálogo principal)
$activeDeals = getStoreActiveDeals($connect, $storeId, 24);

// Histórico (expiradas / desativadas)
$pastDeals = getStorePastDeals($connect, $storeId, 24);

// Monta título/descrição SEO
$storeTitle = trim($store['store_title'] ?? '');
$storeSeoTitle = trim($store['store_seotitle'] ?? '');
$storeSeoDesc = trim($store['store_seodescription'] ?? '');
$storeDescRaw = trim($store['store_description'] ?? '');

$titleSeoHeader = getSeoTitle(
    $storeSeoTitle !== '' ? $storeSeoTitle : $storeTitle,
    $translation['tr_1'] ?? 'Loja'
);

$descriptionSeoHeader = getSeoDescription(
    $storeSeoDesc !== '' ? $storeSeoDesc : $storeDescRaw,
    $storeDescRaw
);

// Título da página
$pageTitle = $storeTitle !== '' ? $storeTitle : ($translation['tr_1'] ?? 'Loja');

// Helper simples para link de WhatsApp (opcional)
$storeWhatsapp = $store['store_whatsapp'] ?? '';
$storeWhatsapp = is_string($storeWhatsapp) ? trim($storeWhatsapp) : '';

// Se não houver coluna/valor, tenta detectar um link de WhatsApp em store_url
if ($storeWhatsapp === '' && !empty($store['store_url'])) {
    $maybeUrl = (string)$store['store_url'];
    if (strpos($maybeUrl, 'wa.me/') !== false || strpos($maybeUrl, 'api.whatsapp.com') !== false) {
        $storeWhatsapp = $maybeUrl;
    }
}

// Normaliza em link clicável, se for só número
$storeWhatsappLink = '';
if ($storeWhatsapp !== '') {
    if (preg_match('/^https?:\/\//i', $storeWhatsapp)) {
        $storeWhatsappLink = $storeWhatsapp;
    } else {
        // Mantém apenas dígitos
        $digits = preg_replace('/\D+/', '', $storeWhatsapp);
        if (strlen($digits) >= 10) {
            // Brasil por padrão
            if (strpos($digits, '55') !== 0) {
                $digits = '55' . $digits;
            }
            $storeWhatsappLink = 'https://wa.me/' . $digits;
        }
    }
}

// Descobre localizações usadas nas ofertas ativas
$storeLocations = [];
if (is_array($activeDeals)) {
    foreach ($activeDeals as $d) {
        $locTitle = trim($d['location_title'] ?? '');
        $locId    = isset($d['deal_location']) ? (int)$d['deal_location'] : 0;
        if ($locId > 0 && $locTitle !== '') {
            $storeLocations[$locId] = $locTitle;
        }
    }
}

include __DIR__ . '/header.php';
require __DIR__ . '/views/single-store.view.php';
include __DIR__ . '/footer.php';
