<?php

declare(strict_types=1);
// translation.php — BASE (EN). Não inclui outros arquivos.
// Salve como UTF-8 (sem BOM).

if (!isset($translation) || !is_array($translation)) { $translation = []; }
if (defined('I18N_BASE_LOADED')) { return; }
define('I18N_BASE_LOADED', true);

/* ====== NAV ====== */
$base = [
  'NAV_HOME'       => 'Home',
  'NAV_SEARCH'     => 'Search',
  'NAV_CATEGORIES' => 'Categories',
  'NAV_LOCATIONS'  => 'Locations',
  'NAV_STORES'     => 'Stores',
  'NAV_PRICING'    => 'Pricing',
  'NAV_CONTACT'    => 'Contact',
  'NAV_ABOUT'      => 'About',
  'NAV_DASHBOARD'  => 'Dashboard',
  'NAV_LOGIN'      => 'Login',
  'NAV_REGISTER'   => 'Register',
  'NAV_LOGOUT'     => 'Logout',
  'NAV_ACCOUNT'    => 'My Account',

  /* ====== HOME HEADINGS ====== */
  'HOME_EXCLUSIVE_DEALS'      => 'Exclusive Deals',
  'HOME_FEATURED_DEALS'       => 'Featured Deals',
  'HOME_FEATURED_CATEGORIES'  => 'Featured Categories',
  'HOME_LATEST_DEALS'         => 'Latest Deals',
  'HOME_FEATURED_STORES'      => 'Featured Stores',
  'HOME_FEATURED_LOCATIONS'   => 'Featured Locations',
  'HOME_PLANS'                => 'Pricing',
  'HOME_CATEGORIES'           => 'Categories',
  'BTN_VIEW_ALL'              => 'View All',
  'HOME_PLANS_SUBTITLE'       => 'Simple pricing plans for everyone and every budget.',
  'LOCATIONS_ITEMS'           => 'items',

  /* ====== FOOTER ======  (mantém compatibilidade com tr_40..tr_47 usados no tema) */
  'tr_40' => 'Quick Links',
  'tr_41' => 'An About us page helps your company make a good first impression and is essential to build trust.',
  'tr_42' => 'Quick Links',
  'tr_44' => 'Newsletter',
  'tr_45' => 'Subscribe',
  'tr_46' => 'Your email',
  'tr_47' => 'All rights reserved.',
  'tr_151' => 'Sign up',
  'tr_152' => 'Full name',
  'tr_139' => 'Full name',
  'tr_140' => 'Phone / WhatsApp',
  'tr_141' => 'Message',
  'tr_143' => 'Send message',
  'tr_145' => 'Email',
  'tr_150' => 'Send',
  'tr_155' => 'I agree to the Terms & Conditions',
  'tr_153' => 'Already have an account?',
  'tr_154' => 'Sign in',
  'tr_130' => 'Categories',
  'tr_132' => 'Filter by rating',
  'tr_135' => 'All',
  'tr_136' => 'Filter by price',
  'tr_138' => 'Featured stores',
  'tr_198' => 'Other filters',
  'tr_199' => 'Exclusive offers',
  'tr_114' => 'Privacy Policy',
  'tr_115' => 'We use cookies to improve your experience on our site. By continuing to browse, you agree to our privacy policy.',
  'tr_117' => 'Got it!',
];

/* aplica sem sobrescrever chaves já definidas */
foreach ($base as $k => $v) {
  if (!array_key_exists($k, $translation)) {
    $translation[$k] = $v;
  }
}
unset($base);

// ND custom keys
$translation['HOME_REVIEWS'] = 'avaliações';
