<?php
// Helper de saída local (compatível com outras views públicas)
if (!function_exists('echoOutput')) {
    function echoOutput($v){ echo htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

// Garante variáveis básicas
$errors  = isset($errors) && is_array($errors) ? $errors : [];
$success = isset($success) ? (string)$success : '';

$name   = $name   ?? '';
$email  = $email  ?? '';
$phone  = $phone  ?? '';
$city   = $city   ?? '';
$state  = $state  ?? '';
$group  = $group  ?? '';
$code   = $code   ?? '';
?>



<div class="uk-height-1-1">
  <div class="uk-flex uk-flex-center uk-flex-middle uk-height-1-1" uk-grid>
    <div class="uk-width-1-1">
      <div class="uk-section uk-section-muted uk-flex uk-flex-middle uk-animation-fade">
        <div class="uk-width-1-1">
          <div class="uk-container">
<div class="nd-assoc-register">
  <div class="nd-assoc-card uk-card uk-card-default uk-card-body uk-border-rounded uk-box-shadow-medium">
    <div class="uk-grid-small" uk-grid>
      <div class="uk-width-1-1 uk-width-2-5@s">
        <img class="nd-assoc-logo" src="/assets/img/badge.svg" alt="ND Conecta">
        <h3 class="uk-heading-bullet uk-margin-small-top">Quero ser associado</h3>
        <p class="nd-assoc-subtitle">
          Preencha seus dados para se cadastrar como associado ND Conecta
          e receber seu código exclusivo para acompanhar cliques e resultados.
        </p>
        <ul class="uk-list uk-list-bullet uk-margin-small-top">
          <li>Cadastro simples e gratuito</li>
          <li>Acompanhe seus cliques em tempo real</li>
          <li>Use seu código para acessar o painel do associado</li>
        </ul>
      </div>

      <div class="uk-width-1-1 uk-width-3-5@s">
        <?php if (!empty($success)): ?>
          <div class="uk-alert-success" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <p><?php echo echoOutput($success); ?></p>
            <?php if ($code): ?>
              <p class="uk-margin-small-top">
                Seu c&oacute;digo de associado &eacute;:
                <span class="nd-assoc-code-highlight"><?php echo echoOutput($code); ?></span>
              </p>
            <?php endif; ?>
            <p class="uk-margin-small-top">
              Use este c&oacute;digo para fazer login em:
              <a href="/dashboard/associate_login.php" target="_blank">Painel do associado</a>.
            </p>
          </div>
        <?php endif; ?>

        <?php if ($errors): ?>
          <div class="uk-alert-danger" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <ul class="uk-margin-small-left">
              <?php foreach ($errors as $e): ?>
                <li><?php echo echoOutput($e); ?></li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>

        <form class="uk-form-stacked" method="post" novalidate>

          <div class="uk-grid-small" uk-grid>
            <div class="uk-width-1-1">
              <div class="uk-margin-small">
                <label class="uk-form-label">Nome completo</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-rounded" type="text" name="associate_name" required
                         value="<?php echo echoOutput($name); ?>" placeholder="Ex: João da Silva">
                </div>
              </div>
            </div>

            <div class="uk-width-1-1">
              <div class="uk-margin-small">
                <label class="uk-form-label">E-mail</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-rounded" type="email" name="associate_email" required
                         value="<?php echo echoOutput($email); ?>" placeholder="seuemail@exemplo.com">
                </div>
              </div>
            </div>

            <div class="uk-width-1-2@s">
              <div class="uk-margin-small">
                <label class="uk-form-label">Telefone / WhatsApp</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-rounded" type="text" name="associate_phone"
                         value="<?php echo echoOutput($phone); ?>" placeholder="(00) 00000-0000">
                </div>
              </div>
            </div>

            <div class="uk-width-1-2@s">
              <div class="uk-margin-small">
                <label class="uk-form-label">Cidade</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-rounded" type="text" name="associate_city"
                         value="<?php echo echoOutput($city); ?>" placeholder="Ex: Florian&oacute;polis">
                </div>
              </div>
            </div>

            <div class="uk-width-1-2@s">
              <div class="uk-margin-small">
                <label class="uk-form-label">UF</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-rounded" type="text" name="associate_state" maxlength="2"
                         value="<?php echo echoOutput($state); ?>" placeholder="SC">
                </div>
              </div>
            </div>

            <div class="uk-width-1-2@s">
              <div class="uk-margin-small">
                <label class="uk-form-label">Grupo</label>
                <div class="uk-form-controls">
                  <?php $g = $group; ?>
                  <select class="uk-select uk-border-rounded" name="associate_group">
                    <option value="">Selecione...</option>
                    <option value="Uber"        <?php echo ($g === 'Uber')        ? 'selected' : ''; ?>>Uber</option>
                    <option value="99"          <?php echo ($g === '99')          ? 'selected' : ''; ?>>99</option>
                    <option value="Taxi"        <?php echo ($g === 'Taxi')        ? 'selected' : ''; ?>>Taxi</option>
                    <option value="Van Turismo" <?php echo ($g === 'Van Turismo') ? 'selected' : ''; ?>>Van Turismo</option>
                    <option value="Motoboy"     <?php echo ($g === 'Motoboy')     ? 'selected' : ''; ?>>Motoboy</option>
                    <option value="Carteiro"    <?php echo ($g === 'Carteiro')    ? 'selected' : ''; ?>>Carteiro</option>
                    <option value="Entregador"  <?php echo ($g === 'Entregador')  ? 'selected' : ''; ?>>Entregador</option>
                    <option value="Outros"      <?php echo ($g === 'Outros')      ? 'selected' : ''; ?>>Outros</option>
                  </select>
                </div>
              </div>
            </div>

            <div class="uk-width-1-1">
              <div class="uk-margin-small">
                <label class="uk-form-label">C&oacute;digo do associado (opcional)</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-rounded" type="text" name="associate_code"
                         value="<?php echo echoOutput($code); ?>"
                         placeholder="Se deixar em branco, geraremos um c&oacute;digo para voc&ecirc;.">
                </div>
              </div>
            </div>

            <div class="uk-width-1-1">
              <div class="uk-margin-small">
                <label><input class="uk-checkbox" type="checkbox" required> Li e aceito os termos de parceria.</label>
              </div>
            </div>

          </div>

          <div class="uk-margin-top">
            <button class="uk-button uk-button-primary uk-border-rounded uk-width-1-1 uk-width-auto@s" type="submit">
              Finalizar cadastro
            </button>
          </div>

          <div class="uk-margin-small-top uk-text-meta">
            J&aacute; &eacute; associado? <a href="/dashboard/associate_login.php">Acesse o painel do associado</a>.
          </div>

          <div class="uk-margin-small-top">
            <a href="<?php echo isset($urlPath) ? $urlPath->home() : '/'; ?>" class="uk-button uk-button-default uk-border-rounded">
              &larr; Voltar ao site
            </a>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>


          </div>
        </div>
      </div>
    </div>
  </div>
</div>
