<?php
// View: /ideias-de-campanha

// helpers locais
$nd_clean = function ($s) {
  if ($s === null) return '';
  $s = html_entity_decode((string)$s, ENT_QUOTES, 'UTF-8');
  $s = strip_tags($s);
  $s = str_replace("\xC2\xA0", ' ', $s);
  $s = preg_replace('/\s+/u', ' ', $s);
  return trim($s);
};

$nd_money = function ($v) {
  if ($v === null || $v === '') return '';
  if (is_numeric($v)) return 'R$ ' . number_format((float)$v, 2, ',', '.');
  return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
};

$nd_cta_for = function (array $deal) {
  $cat = strtolower((string)($deal['category_title'] ?? ''));
  $title = strtolower((string)($deal['deal_title'] ?? ''));

  if (str_contains($cat, 'comida') || str_contains($cat, 'bebida') || str_contains($title, 'burger') || str_contains($title, 'café') || str_contains($title, 'padaria')) {
    return 'Mostrar este cupom no caixa';
  }
  if (str_contains($title, 'farm') || str_contains($cat, 'saúde') || str_contains($cat, 'fitness')) {
    return 'Chamar no WhatsApp e reservar';
  }
  if (str_contains($cat, 'beleza') || str_contains($cat, 'spas') || str_contains($title, 'corte') || str_contains($title, 'barba') || str_contains($title, 'escova')) {
    return 'Agendar agora';
  }
  if (str_contains($cat, 'varejo') || str_contains($cat, 'automotivo') || str_contains($title, 'desconto') || str_contains($title, 'off')) {
    return 'Ver ofertas do dia';
  }
  return 'Ver oferta';
};

?>

<link rel="stylesheet" href="<?php echo $urlPath->assets_css('lead-pages.css'); ?>">

<div class="nd-lead uk-section uk-section-muted uk-padding-remove-top">
  <div class="uk-container uk-margin-medium-top">

    <div class="nd-hero uk-padding uk-light uk-margin-medium-bottom">
      <div class="uk-grid-medium uk-flex-middle" uk-grid>
        <div class="uk-width-2-3@m">
          <div class="nd-hero-badge uk-margin-small-bottom">
            <span uk-icon="icon: copy; ratio: .9"></span>
            Ideias prontas para divulgar
          </div>
          <h1 class="uk-margin-remove-top uk-margin-small-bottom uk-heading-small">Ideias de campanha para você copiar</h1>
          <p class="uk-text-lead uk-margin-remove-top" style="max-width: 70ch; opacity:.92">
            Aqui estão <strong>ofertas reais</strong> já cadastradas no Conecta, no formato ideal para comércio local.
            Você pode copiar a ideia (oferta + CTA) e adaptar para o seu negócio.
          </p>

          <div class="uk-margin-top uk-flex uk-flex-wrap uk-flex-middle" style="gap:10px">
            <a href="/pricing" class="uk-button uk-button-primary uk-border-pill uk-button-large">Ver planos</a>
            <a href="/anunciantes" class="uk-button uk-button-default uk-border-pill uk-button-large">Quero anunciar</a>
          </div>

          <p class="uk-text-small uk-margin-top" style="opacity:.82">
            Dica: mande este link no WhatsApp para parceiros e clientes: <strong>/ideias-de-campanha</strong>
          </p>
        </div>

        <div class="uk-width-1-3@m uk-visible@m">
          <div class="uk-card uk-card-default nd-card uk-card-body">
            <h3 class="uk-card-title uk-margin-remove-bottom">Como usar</h3>
            <ul class="uk-list uk-list-divider uk-margin-small-top">
              <li><span uk-icon="check"></span> Escolha uma oferta parecida com o seu segmento</li>
              <li><span uk-icon="check"></span> Copie o texto (oferta + CTA) e ajuste para sua campanha</li>
              <li><span uk-icon="check"></span> Publique no Conecta e acompanhe as métricas</li>
            </ul>
            <div class="uk-alert-primary uk-border-rounded uk-padding-small uk-margin-small-top" uk-alert>
              <div class="uk-text-small">
                Quer que a equipe monte a oferta com você? Cadastre interesse em <a href="/anunciantes">/anunciantes</a>.
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="uk-card uk-card-default uk-card-body nd-card uk-border-rounded uk-margin-bottom">
      <div class="uk-flex uk-flex-between uk-flex-middle" style="gap:10px" uk-grid>
        <div class="uk-width-expand">
          <h2 class="uk-margin-remove">Exemplos (do seu banco de dados)</h2>
          <p class="uk-text-muted uk-margin-small-top" style="max-width: 85ch">
            Estes cards são gerados automaticamente a partir das ofertas ativas no sistema.
          </p>
        </div>
      </div>

      <?php if (empty($campaignDeals)): ?>
        <div class="uk-alert uk-alert-warning uk-border-rounded" uk-alert>
          <p class="uk-margin-remove">Nenhuma oferta ativa foi encontrada no momento. Cadastre uma oferta e volte aqui.</p>
        </div>
      <?php else: ?>

        <div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-3@m uk-margin-top" uk-grid>
          <?php foreach ($campaignDeals as $d):
            $id    = (int)($d['deal_id'] ?? 0);
            $slug  = (string)($d['deal_slug'] ?? '');
            $title = $nd_clean($d['deal_title'] ?? 'Oferta');
            $cat   = $nd_clean($d['category_title'] ?? '');
            $store = $nd_clean($d['store_title'] ?? '');
            $img   = (string)($d['deal_image'] ?? '');
            $imgUrl = $img ? $urlPath->image($img) : $urlPath->assets_img('campaign-market.svg');
            $price = $nd_money($d['deal_price'] ?? '');
            $old   = $nd_money($d['deal_oldprice'] ?? '');
            $coupon = $nd_clean($d['coupon_code'] ?? '');
            $disc   = (int)($d['discount_percent'] ?? 0);
            $ctaTxt = $nd_cta_for($d);
            $dealUrl = $urlPath->deal($id, $slug);
            $copy = "Oferta: {$title}";
            if ($disc > 0) $copy .= " ({$disc}% OFF)";
            if ($price) $copy .= " • {$price}";
            $copy .= "\nCTA: {$ctaTxt}";
            if ($coupon) $copy .= "\nCupom: {$coupon}";
            $copy .= "\nLink: {$dealUrl}";
          ?>
          <div>
            <div class="uk-card uk-card-default uk-card-small uk-border-rounded" style="overflow:hidden; box-shadow: 0 8px 22px rgba(15,23,42,.06)">
              <div class="uk-cover-container" style="height:150px">
                <img src="<?php echo htmlspecialchars($imgUrl, ENT_QUOTES, 'UTF-8'); ?>" alt="<?php echo htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?>" uk-cover>
              </div>
              <div class="uk-card-body">
                <div class="uk-flex uk-flex-between uk-flex-middle" style="gap:10px">
                  <div class="uk-text-bold" style="line-height:1.15"><?php echo htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?></div>
                  <a class="uk-icon-link" href="<?php echo htmlspecialchars($dealUrl, ENT_QUOTES, 'UTF-8'); ?>" uk-icon="icon: link" aria-label="Abrir"></a>
                </div>

                <div class="uk-text-small uk-text-muted uk-margin-small-top">
                  <?php if ($cat): ?><span class="uk-label uk-label-muted uk-border-pill"><?php echo htmlspecialchars($cat, ENT_QUOTES, 'UTF-8'); ?></span><?php endif; ?>
                  <?php if ($store): ?><span class="uk-text-muted">&nbsp;•&nbsp;<?php echo htmlspecialchars($store, ENT_QUOTES, 'UTF-8'); ?></span><?php endif; ?>
                </div>

                <div class="uk-margin-small-top">
                  <?php if ($price): ?>
                    <div class="uk-text-bold" style="font-size:1.05rem"><?php echo htmlspecialchars($price, ENT_QUOTES, 'UTF-8'); ?>
                      <?php if ($old && $old !== 'R$ 0,00'): ?>
                        <span class="uk-text-small uk-text-muted" style="text-decoration:line-through; margin-left:8px"><?php echo htmlspecialchars($old, ENT_QUOTES, 'UTF-8'); ?></span>
                      <?php endif; ?>
                    </div>
                  <?php endif; ?>
                  <?php if ($coupon): ?>
                    <div class="uk-text-small uk-margin-small-top"><span class="uk-label uk-label-success uk-border-pill">Cupom: <?php echo htmlspecialchars($coupon, ENT_QUOTES, 'UTF-8'); ?></span></div>
                  <?php endif; ?>
                </div>

                <div class="uk-text-small uk-text-muted uk-margin-small-top">
                  <strong>CTA:</strong> “<?php echo htmlspecialchars($ctaTxt, ENT_QUOTES, 'UTF-8'); ?>”.
                </div>

                <div class="uk-flex uk-flex-wrap uk-margin-top" style="gap:8px">
                  <a href="<?php echo htmlspecialchars($dealUrl, ENT_QUOTES, 'UTF-8'); ?>" class="uk-button uk-button-primary uk-border-pill" target="_blank">Ver no Conecta</a>
                  <button type="button" class="uk-button uk-button-default uk-border-pill" data-copy="<?php echo htmlspecialchars($copy, ENT_QUOTES, 'UTF-8'); ?>" onclick="ndCopy(this)">
                    Copiar texto
                  </button>
                </div>
              </div>
            </div>
          </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>

    <div class="uk-card uk-card-default uk-card-body nd-card uk-border-rounded">
      <div class="uk-grid-medium uk-flex-middle" uk-grid>
        <div class="uk-width-expand">
          <h3 class="uk-margin-remove">Quer que a gente monte sua campanha?</h3>
          <p class="uk-text-muted uk-margin-small-top" style="max-width: 80ch">
            Você escolhe o plano e a equipe te ajuda a cadastrar a oferta, gerar QR Code e medir resultado.
          </p>
        </div>
        <div class="uk-width-auto@m">
          <a href="/anunciantes" class="uk-button uk-button-primary uk-border-pill uk-button-large">Cadastrar interesse</a>
        </div>
      </div>
    </div>

  </div>
</div>

<script>
function ndCopy(btn){
  try {
    const text = btn.getAttribute('data-copy') || '';
    if (!text) return;
    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard.writeText(text).then(() => {
        UIkit.notification({message: 'Texto copiado!', status: 'success'});
      }).catch(() => {
        fallbackCopy(text);
      });
    } else {
      fallbackCopy(text);
    }
  } catch(e){ /* noop */ }
}

function fallbackCopy(text){
  const ta = document.createElement('textarea');
  ta.value = text;
  ta.style.position = 'fixed';
  ta.style.left = '-9999px';
  document.body.appendChild(ta);
  ta.select();
  try { document.execCommand('copy'); } catch(e) {}
  document.body.removeChild(ta);
  if (window.UIkit && UIkit.notification) UIkit.notification({message: 'Texto copiado!', status: 'success'});
}
</script>
