<?php
/**
 * Editar Perfil – PT-BR
 * Esta view é carregada dentro da coluna da página de perfil.
 * Não inclui header/footer.
 */

$ui = (isset($userInfo) && is_array($userInfo)) ? $userInfo : [];

$currName   = $ui['user_name']        ?? '';
$currEmail  = $ui['user_email']       ?? '';
$currAbout  = $ui['user_description'] ?? '';
$currAvatar = $ui['user_avatar']      ?? 'default.jpg';

$backUrl = $urlPath->profile();
?>

<div class="uk-card uk-card-default uk-card-body uk-border-rounded">
  <h4 class="uk-margin-remove">Editar Perfil</h4>

  <form class="uk-form-stacked uk-margin-top" method="post" action="<?php echo $urlPath->profile(); ?>?action=edit" enctype="multipart/form-data">

    <div class="uk-margin">
      <label class="uk-form-label" for="user_name">Nome completo</label>
      <div class="uk-form-controls">
        <input class="uk-input" type="text" id="user_name" name="user_name" value="<?php echo echoOutput($currName); ?>" required>
      </div>
    </div>

    <div class="uk-margin">
      <label class="uk-form-label" for="user_password">Nova senha</label>
      <div class="uk-form-controls">
        <input class="uk-input" type="password" id="user_password" name="user_password" placeholder="Deixe em branco para não alterar">
      </div>
      <div class="uk-text-meta uk-margin-small-top">Dica: use pelo menos 8 caracteres, com letras e números.</div>
    </div>

    <div class="uk-margin">
      <label class="uk-form-label" for="user_email">E-mail</label>
      <div class="uk-form-controls">
        <input class="uk-input" type="email" id="user_email" name="user_email" value="<?php echo echoOutput($currEmail); ?>" required>
      </div>
    </div>

    <div class="uk-margin">
      <label class="uk-form-label" for="user_description">Sobre mim</label>
      <div class="uk-form-controls">
        <textarea class="uk-textarea" id="user_description" name="user_description" rows="5" placeholder="Conte um pouco sobre você..."><?php echo echoOutput($currAbout); ?></textarea>
      </div>
    </div>

    <div class="uk-margin">
      <label class="uk-form-label">Foto / Avatar</label>

      <div class="uk-grid-small uk-child-width-auto uk-flex-middle" uk-grid>
        <div>
          <div class="uk-cover-container uk-border-circle uk-box-shadow-small" style="width:120px; height:120px;">
            <img src="<?php echo $urlPath->image($currAvatar); ?>" alt="Avatar atual" uk-cover>
            <canvas width="120" height="120"></canvas>
          </div>
        </div>
        <div>
          <div class="uk-form-controls">
            <div uk-form-custom="target: true">
              <input type="file" name="user_avatar" accept="image/*">
              <input class="uk-input uk-form-width-medium" type="text" placeholder="Selecione um arquivo" disabled>
            </div>
            <div class="uk-text-meta uk-margin-small-top">Formatos aceitos: JPG, PNG ou WEBP. Tamanho recomendado: 300×300.</div>
          </div>
        </div>
      </div>
    </div>

    <div class="uk-margin">
      <button class="uk-button uk-button-primary" type="submit" name="save_profile" value="1">Salvar alterações</button>
      <a class="uk-button uk-button-default uk-margin-small-left" href="<?php echo $backUrl; ?>">Cancelar</a>
    </div>

  </form>
</div>
