<!-- HEADER -->
<?php
require './sections/header.php'; ?>

<?php
// -------------------------------------------------------------------
// Proteções de i18n (evitam avisos em PHP 8+ se arrays não existirem)
// -------------------------------------------------------------------
if (!isset($translation) || !is_array($translation)) { $translation = []; }
if (!isset($langStrings)  || !is_array($langStrings))  { $langStrings  = []; }

// -------------------------------------------------------------------
// Helper de tradução com fallback
// -------------------------------------------------------------------
if (!function_exists('t')) {
    function t(string $key, string $default = '') {
        global $translation, $langStrings;
        if (isset($translation[$key]) && $translation[$key] !== '') return $translation[$key];
        if (isset($langStrings[$key])  && $langStrings[$key]  !== '') return $langStrings[$key];
        return $default;
    }
}

// -------------------------------------------------------------------
// Textos com fallback seguro
// -------------------------------------------------------------------
$title    = t('tr_eptitle',    'Ocorreu um erro');
$subtitle = t('tr_epsubtitle', 'Ops! Algo não saiu como esperado.');
$tagline  = t('tr_eptagline',  'Tente novamente em alguns instantes ou volte para a página inicial.');
$button   = t('tr_epbutton',   'Voltar para a página inicial');

// URL da home (ajuste se seu projeto usar outra constante/rota)
$homeUrl = (isset($urlPath) && method_exists($urlPath, 'home')) ? $urlPath->home() : (defined('BASE_URL') ? BASE_URL : './');
?>

<!-- PAGE CONTENT -->
<div class="container" style="max-width: 880px; margin: 60px auto; text-align: center;">
    <h1 class="tw-font-bold" style="margin: 10px 0 6px;">
        <?= htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?>
    </h1>

    <h3 class="text-muted" style="margin: 6px 0 14px;">
        <?= htmlspecialchars($subtitle, ENT_QUOTES, 'UTF-8'); ?>
    </h3>

    <p class="lead" style="margin: 0 0 22px;">
        <?= htmlspecialchars($tagline, ENT_QUOTES, 'UTF-8'); ?>
    </p>

    <a href="<?= htmlspecialchars($homeUrl, ENT_QUOTES, 'UTF-8'); ?>"
       class="btn btn-primary"
       role="button"
       aria-label="<?= htmlspecialchars($button, ENT_QUOTES, 'UTF-8'); ?>">
        <?= htmlspecialchars($button, ENT_QUOTES, 'UTF-8'); ?>
    </a>
</div>
<!-- END PAGE CONTENT -->

<!-- FOOTER -->
<?php require './sections/footer.php'; ?>
