<?php
// ===== Modais da página de oferta (carregue quando existir item) =====
if (isset($itemDetails) && is_array($itemDetails)) {
  $base = __DIR__ . '/../sections/views/';
  $load = function($f) use ($base) { $p = $base.$f; if (file_exists($p)) require $p; };

  // UIKit modals — inclua os que seu projeto usa
  if (!empty($settings['st_enable_report_form'])) $load('report-modal.view.php');
  $load('submit-review.view.php');      // formulário de avaliação
  $load('reviews-modal.view.php');      // lista/modal de reviews (se aplicável)
}
?>

<!-- ===== Vendors/Core ===== -->
<script src="<?php echo $urlPath->assets_js('cookieconsent.min.js'); ?>"></script>
<script src="<?php echo $urlPath->assets_js('nice-select.min.js'); ?>"></script>
<script src="<?php echo $urlPath->assets_js('datatables.min.js'); ?>"></script>
<script src="<?php echo $urlPath->assets_js('datatables.uikit.min.js'); ?>"></script>
<script src="<?php echo $urlPath->assets_js('rating.min.js'); ?>"></script>
<script src="<?php echo $urlPath->assets_js('jquery.upload.js'); ?>"></script>

<!-- ===== Pack de modais (não mexe em header/footer) ===== -->
<link rel="stylesheet" href="/assets/css/nd-offer-modals.css?v=1">
<script src="/assets/js/nd-offer-modals.js?v=1" defer></script>
<script src="/assets/js/nd-offer-upgrade.js?v=1" defer></script>


<?php if($settings['st_cookie_consent'] == 1): ?>
  <script>
  window.cookieconsent.initialise({
    palette:{ popup:{background:"#efefef",text:"#404040"}, button:{background:"#8ec760",text:"#ffffff"} },
    theme:"classic",
    content:{
      message:"<?php echo echoOutput($translation['tr_115']); ?>",
      dismiss:"<?php echo echoOutput($translation['tr_117']); ?>",
      link:"<?php echo echoOutput($translation['tr_114']); ?>",
      href:'https://conecta.ndmidia.com.br/politicadeprivacidade'
    }
  });
  </script>
<?php endif; ?>


<script>
(function(){
  function drawStars(avg){ avg=Math.max(0,Math.min(5,avg||0)); var full=Math.round(avg); var s=''; for(var i=0;i<5;i++) s+=(i<full?'★':'☆'); return s; }
  function updateJsonLD(avg,count){ var tag=document.getElementById('nd-jsonld'); if(!tag) return; try{ var d=JSON.parse(tag.textContent); if(!d.aggregateRating) d.aggregateRating={"@type":"AggregateRating"}; d.aggregateRating.ratingValue=(avg||0).toFixed(2); d.aggregateRating.reviewCount=count||0; d.aggregateRating.bestRating="5"; d.aggregateRating.worstRating="1"; tag.textContent=JSON.stringify(d); }catch(e){} }
  function fetchReviews(item){ return fetch('/controllers/get-reviews.php?item='+encodeURIComponent(item),{credentials:'same-origin'}).then(r=>r.json()); }
  function renderReviews(list){ var box=document.getElementById('nd-reviews'); if(!box||!Array.isArray(list)) return; box.innerHTML=list.map(r=>{var stars=drawStars(+r.rating); var when=(r.created||'').slice(0,10); return '<div class="uk-comment uk-margin"><div class="uk-comment-body"><div class="uk-text-small uk-text-muted">'+when+'</div><div class="uk-text-large">'+stars+' <span class="uk-text-bold">'+(+r.rating)+'/5</span></div><p>'+ (r.comment? String(r.comment).replace(/[<>]/g,'') : '') +'</p></div></div>';}).join(''); }
  function init(){ var it=window.ND_RATING&&window.ND_RATING.item; if(!it) return; fetchReviews(it).then(data=>{ var avg=data&&data.stats?+data.stats.avg:0; var cnt=data&&data.stats?+data.stats.count:0; var s=document.getElementById('nd-stars'), sc=document.getElementById('nd-score'), c=document.getElementById('nd-count'); if(s) s.textContent=drawStars(avg); if(sc) sc.textContent=(avg?avg.toFixed(1):'0.0')+'/5'; if(c) c.textContent='('+cnt+' avaliações)'; updateJsonLD(avg,cnt); renderReviews(data&&data.items); }).catch(()=>{}); }
  if (document.readyState==='loading') document.addEventListener('DOMContentLoaded', init); else init();
})();
</script>


<!-- ND | Patch inline para estrelas clicáveis no modal de avaliação (versão 2025-10-31) -->
<style>
  .nd-stars-inline{display:inline-flex;gap:6px;direction:rtl}
  .nd-stars-inline .nd-star{font-size:28px;color:#d1d5db;cursor:pointer;user-select:none;outline:0;line-height:1}
  .nd-stars-inline .nd-star.active,
  .nd-stars-inline .nd-star:hover,
  .nd-stars-inline .nd-star:hover ~ .nd-star{color:#F59E0B}
</style>
<script>
(function(){
  function installStars(modal){
    if (!modal || modal.__ndStarsInstalled) return;
    var form = modal.querySelector('#formRating') || modal.querySelector('form');
    if (!form) return;
    form.setAttribute('data-review-form','');

    var oldRange = form.querySelector('input[type="range"][name="rating"]');
    var oldSelect = form.querySelector('select[name="rating"]');
    var host = (oldRange && oldRange.parentNode) || (oldSelect && oldSelect.parentNode) || form;
    if (form.querySelector('[data-ndstars]')) return;
    if (oldRange) oldRange.remove();
    if (oldSelect) oldSelect.remove();

    var hidden = document.createElement('input');
    hidden.type = 'hidden'; hidden.name = 'rating'; hidden.id = 'nd-rating-hidden'; hidden.value='5';

    var wrap = document.createElement('div');
    wrap.className='nd-stars-inline'; wrap.setAttribute('data-ndstars','');
    wrap.innerHTML = ''
      + '<span class="nd-star" data-v="5" role="radio" aria-checked="true"  tabindex="0">★</span>'
      + '<span class="nd-star" data-v="4" role="radio" aria-checked="false" tabindex="0">★</span>'
      + '<span class="nd-star" data-v="3" role="radio" aria-checked="false" tabindex="0">★</span>'
      + '<span class="nd-star" data-v="2" role="radio" aria-checked="false" tabindex="0">★</span>'
      + '<span class="nd-star" data-v="1" role="radio" aria-checked="false" tabindex="0">★</span>';

    var label = document.createElement('span');
    label.className='uk-text-meta'; label.setAttribute('data-stars-label','');
    label.style.marginLeft='8px'; label.textContent='5/5';

    host.appendChild(wrap); host.appendChild(hidden); host.appendChild(label);

    function setVal(v){
      v=Math.max(1,Math.min(5,parseInt(v||5,10)));
      hidden.value=v; label.textContent=v+'/5';
      Array.prototype.forEach.call(wrap.querySelectorAll('.nd-star'), function(s){
        var val = parseInt(s.getAttribute('data-v'),10);
        var active = (val <= v);
        s.classList.toggle('active', active);
        s.setAttribute('aria-checked', active ? 'true' : 'false');
      });
    }
    wrap.addEventListener('click', function(e){
      var s=e.target.closest('.nd-star'); if(!s) return; setVal(s.getAttribute('data-v'));
    });
    wrap.addEventListener('keydown', function(e){
      var v=parseInt(hidden.value||5,10);
      if(e.key==='ArrowLeft'||e.key==='ArrowDown'){ setVal(Math.max(1,v-1)); e.preventDefault(); }
      if(e.key==='ArrowRight'||e.key==='ArrowUp'){ setVal(Math.min(5,v+1)); e.preventDefault(); }
    });

    if (!form.querySelector('input[name="item"]')){
      var it=(window.ND_RATING&&ND_RATING.item)||'';
      if(it){ var hidItem=document.createElement('input'); hidItem.type='hidden'; hidItem.name='item'; hidItem.value=it; form.appendChild(hidItem); }
    }

    setVal(hidden.value||5);
    modal.__ndStarsInstalled = true;
  }

  function tryInstallNow(){
    var modal=document.getElementById('submit-review');
    if(modal) installStars(modal);
  }

  document.addEventListener('click', function(e){
    if (e.target.closest('[href="#submit-review"], [uk-toggle], [data-uk-toggle]')) {
      setTimeout(tryInstallNow, 80);
      setTimeout(tryInstallNow, 300);
    }
  });

  if (document.readyState==='loading') document.addEventListener('DOMContentLoaded', tryInstallNow); else tryInstallNow();
  window.addEventListener('load', function(){ setTimeout(tryInstallNow, 200); });
})();
</script>


<!-- ND | Patch click 'Publicar' para enviar review mesmo se o form não submeter -->
<script>
(function(){
  function qs(s,ctx){return (ctx||document).querySelector(s);}
  function qsa(s,ctx){return Array.from((ctx||document).querySelectorAll(s));}
  function getParam(name){var m=location.search.match(new RegExp('[?&]'+name+'=([^&]+)'));return m?decodeURIComponent(m[1]):'';}
  function findItemId(modal){
    var it = (qs('input[name="item"]', modal)||{}).value || (window.ND_RATING&&ND_RATING.item) || getParam('deal_id') || '';
    return String(it||'').trim();
  }
  function ensureHandlers(){
    var modal = document.getElementById('submit-review');
    if (!modal) return;
    var form = qs('#formRating', modal) || qs('form', modal);
    if (!form) return;
    form.setAttribute('data-review-form',''); // para compat com nd-reviews.js

    // Marca botão principal e aplica handler
    var btn = qs('.uk-modal-footer .uk-button-primary, .uk-modal-footer [type="submit"], [data-nd-publish]', modal) || qs('button.uk-button-primary', modal);
    if (!btn || btn.__ndBound) return;
    btn.__ndBound = true;
    btn.addEventListener('click', function(e){
      e.preventDefault();
      // coleta valores
      var rating = (qs('input[name="rating"]', form)||{}).value || (qs('[data-ndstars] .nd-star.active', form)||{}).getAttribute?.('data-v') || '5';
      var comment = (qs('textarea[name="comment"]', form)||{}).value || '';
      var item = findItemId(modal);
      if (!item){ alert('Erro: item não identificado.'); return; }

      var body = new URLSearchParams();
      body.set('item', item);
      body.set('rating', rating);
      body.set('comment', comment);

      fetch('/controllers/add-review.php', {
        method:'POST',
        headers:{'Content-Type':'application/x-www-form-urlencoded;charset=UTF-8'},
        credentials:'same-origin',
        body:String(body)
      })
      .then(r=>r.json())
      .then(function(resp){
        if (resp && resp.ok){ alert('Avaliação enviada com sucesso!'); location.reload(); }
        else { alert((resp && (resp.error||resp.msg)) || 'Falha ao enviar avaliação.'); }
      })
      .catch(function(){ alert('Falha de rede ao enviar avaliação.'); });
    });
  }

  // Tenta instalar ao abrir modal e também em eventos comuns
  document.addEventListener('click', function(e){
    if (e.target.closest('[href="#submit-review"], [uk-toggle], [data-uk-toggle]')){
      setTimeout(ensureHandlers, 80);
      setTimeout(ensureHandlers, 300);
    }
  });
  if (document.readyState==='loading') document.addEventListener('DOMContentLoaded', ensureHandlers); else ensureHandlers();
  window.addEventListener('load', function(){ setTimeout(ensureHandlers, 200); });
})();
</script>


<script>
(function(){
  function ndBindCouponRedeem(){
    try {
      if (!document.addEventListener) { return; }
      if (window.__ndCouponRedeemBound) { return; }
      window.__ndCouponRedeemBound = true;

      document.addEventListener('click', function(ev){
        var target = ev.target;
        if (!target || !target.closest) { return; }
        var btn = target.closest('.nd-copy-coupon');
        if (!btn) { return; }

        try {
          var code   = btn.getAttribute('data-code') || '';
          var dealId = btn.getAttribute('data-deal-id') || '';
          var title  = btn.getAttribute('data-title') || '';

          if (!code || !dealId) { return; }

          var body = new URLSearchParams();
          body.set('deal_id', dealId);
          body.set('coupon_code', code);
          if (title) { body.set('coupon_title', title); }

          fetch('/controllers/nd-redeem-coupon.php', {
            method: 'POST',
            headers: {
              'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            credentials: 'same-origin',
            body: body.toString()
          }).catch(function(e){
            if (window.console && console.warn) {
              console.warn('nd-redeem-coupon request falhou', e);
            }
          });
        } catch(e){
          if (window.console && console.error) {
            console.error(e);
          }
        }
      }, true);
    } catch(e){
      if (window.console && console.error) {
        console.error(e);
      }
    }
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', ndBindCouponRedeem);
  } else {
    ndBindCouponRedeem();
  }
})();
</script>

</body>
</html>

<script src="/assets/js/nd-reviews-submit.js?v=11" defer></script>
