<!DOCTYPE html>
<html dir="<?php echo $langDir; ?>" <?php echo (isset($fullHeight)) ? ' class="uk-height-1-1"' : NULL ?>>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0">

  <!-- Favicon (tema) + fallback opcional -->
  <link rel="shortcut icon" href="<?php echo $urlPath->image($theme['th_favicon']); ?>">
  <link rel="icon" href="/favicon.ico">

  <?php if (isset($titleSeoHeader) && !empty($titleSeoHeader)): ?>
    <title><?php echo echoOutput($titleSeoHeader); ?></title>
  <?php endif; ?>

  <?php if (isset($descriptionSeoHeader) && !empty($descriptionSeoHeader)): ?>
    <meta name="description" content="<?php echo echoOutput($descriptionSeoHeader); ?>">
  <?php endif; ?>

  <!-- CSS -->
  <link rel="stylesheet" href="<?php echo $urlPath->assets_css('uikit.css'); ?>">
  <link rel="stylesheet" href="<?php echo $urlPath->assets_css('styles.css'); ?>">
  <link rel="stylesheet" href="<?php echo $urlPath->assets_css('offer-pro.css'); ?>">
  <!-- ND UI Refresh (pequenas melhorias visuais sem quebrar o tema) -->
  <link rel="stylesheet" href="/assets/css/nd-ui-refresh.css?v=1">

  <?php if ($langDir == 'rtl'): ?>
    <link rel="stylesheet" href="<?php echo $urlPath->assets_css('uikit-rtl.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo $urlPath->assets_css('theme-rtl.css'); ?>">
  <?php endif; ?>

  <!-- JS (ordem correta) -->
  <script src="<?php echo $urlPath->assets_js('jquery.js'); ?>"></script>
  <script src="<?php echo $urlPath->assets_js('uikit.js'); ?>"></script>
  <script src="<?php echo $urlPath->assets_js('uikit-icons.js'); ?>"></script>
  <!-- main.js apenas uma vez (não repetir no footer) -->
  <script src="<?php echo $urlPath->assets_js('main.js'); ?>" defer></script>

  <!-- Variáveis globais mínimas -->
  <script>
  (function(){
    var SITEURL = "<?php echo $urlPath->home(); ?>";
    var IMAGES_FOLDER = "<?php
      if (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'image')) {
        echo htmlspecialchars(rtrim($urlPath->image(''), '/').'/',
          ENT_QUOTES, 'UTF-8');
      } else {
        echo '/images/';
      }
    ?>";
    window.SITEURL = SITEURL;
    window.IMAGES_FOLDER = IMAGES_FOLDER;
  })();
  </script>

  <!-- ND tracking helper (leve) -->
  <script>
  (function(){
    function encode(obj){
      try { return new URLSearchParams(obj).toString(); } catch(e){ return ''; }
    }
    window.ndTrack = function(eventName, data){
      data = data || {};
      data.event = eventName || '';
      // envia sem travar navegação
      try {
        var body = encode(data);
        if (navigator.sendBeacon) {
          var blob = new Blob([body], {type: 'application/x-www-form-urlencoded'});
          navigator.sendBeacon('/event.php', blob);
          return;
        }
      } catch(e){}
      try {
        fetch('/event.php', {
          method: 'POST',
          headers: {'Content-Type': 'application/x-www-form-urlencoded'},
          body: encode(data),
          keepalive: true
        }).catch(function(){});
      } catch(e){}
    };
  })();
  </script>


  <?php if (isset($settings['st_recaptcha_enable']) && (int)$settings['st_recaptcha_enable'] === 1): ?>
    <script async src="https://www.google.com/recaptcha/api.js"></script>
  <?php endif; ?>

  <!-- Airbag: esconde o preloader mesmo que algum plugin falhe -->
  <script>
  (function(){
    function hideP(){
      var p = document.getElementById('preloader');
      if (p) {
        p.style.display = 'none';
        p.style.opacity = '0';
        p.style.visibility = 'hidden';
      }
    }
    document.addEventListener('DOMContentLoaded', hideP);
    window.addEventListener('load', hideP);
  })();
  </script>
</head>
<body>
