<?php $canWrite = function_exists('isLogged') ? isLogged() : (!empty($__ND_AUTH['isLogged'])); 
$loginUrl   = $__ND_AUTH['login'] ?? '/signin';
// Dados do usuário logado (para favoritos, etc.)
$userInfo       = function_exists('getUserInfo') ? getUserInfo() : null;
$currentUserId  = isset($userInfo['user_id']) ? (int)$userInfo['user_id'] : 0;
?>

    <link rel="stylesheet" href="/assets/css/card-deal-pro.css?v=home3">
    <style>
      /* Destaque do cupom na página da oferta */
      .nd-coupon-card {
        /* mantém o layout padrão do card */
      }
      .nd-coupon-item:last-child hr {
        display: none;
      }
      .nd-coupon-code-wrapper {
        margin-top: 0.5rem;
        margin-bottom: 0.5rem;
      }
      .nd-coupon-code-pill {
        display: inline-block;
        padding: 0.6rem 1.8rem;
        border-radius: 999px;
        font-size: 1.2rem;
        font-weight: 700;
        letter-spacing: 0.08em;
        background: #f5f5f5;
        border: 1px dashed #999;
        text-transform: uppercase;
      }
      .nd-coupon-meta span {
        display: inline-block;
        margin: 0 2px;
      }
      .nd-coupon-actions .nd-copy-coupon-highlight {
        font-weight: 800;
        text-transform: uppercase;
      }
      @media (min-width: 960px) {
        .nd-coupon-code-pill {
          font-size: 1.4rem;
        }
      }
    </style>
<?php
if (!defined('SITEURL')) {
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'conecta.ndmidia.com.br';
  define('SITEURL', $scheme.'://'.$host);
  if (!isset($ctaHrefButton) || !$ctaHrefButton) $ctaHrefButton = SITEURL;
  if (!isset($ctaRelButton) || !$ctaRelButton) $ctaRelButton = 'noopener';
  if (!isset($ctaTargetButton) || !$ctaTargetButton) $ctaTargetButton = '_blank';
}

/**
 * DETALHE DA OFERTA
 * Quando $deal existir: renderiza header + detalhe + reviews + relacionadas + footer e NÃO carrega a home.
 * Quando NÃO existir: renderiza a home original (todas as sections).
 */

if (isset($deal) && is_array($deal) && !empty($deal)):

  // ---------- Helpers ----------
  // Limpa textos vindos com entidades HTML (&nbsp;, &amp;, etc.), NBSP e múltiplos espaços
  $clean = function ($s) {
      if ($s === null) return '';
      $s = html_entity_decode((string)$s, ENT_QUOTES, 'UTF-8');   // decode entidades (&nbsp; etc.)
      $s = strip_tags($s);                                       // remove HTML
      $s = str_replace("\xC2\xA0", ' ', $s);                     // NBSP -> espaço normal
      $s = preg_replace('/\s+/u', ' ', $s);                      // compacta múltiplos espaços
      return trim($s);
  };

  // ---------- Normalizações de campos ----------
  $rawTitle  = $deal['deal_title'] ?? 'Oferta';
  $title     = $clean($rawTitle);                                // título limpo
  $category  = $clean($deal['category_name'] ?? '');

  // Loja com chaves alternativas
  $storeName = $clean($deal['store_name'] ?? $deal['store_title'] ?? $deal['store'] ?? '');
  $storeSlug = trim($deal['store_slug'] ?? $deal['slug_store'] ?? '');

  $img       = $deal['deal_image'] ?? '';
  $imgUrl    = (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'image'))
                ? $urlPath->image($img)
                : ($img ?: '');

  $price     = $deal['deal_price']     ?? $deal['price']     ?? null;
  $oldPrice  = $deal['deal_oldprice'] ?? $deal['old_price'] ?? null;
  $discount  = $deal['deal_discount']  ?? $deal['discount']  ?? null;
  if ($discount === null && is_numeric($price) && is_numeric($oldPrice) && $oldPrice > 0) {
      $discount = ($price && $oldPrice && $oldPrice>0) ? round((1 - ((float)$price / (float)$oldPrice)) * 100) : null;
  }
  $fmt = function($v) {
      if ($v === null || $v === '') return '';
      if (is_numeric($v)) return 'R$ ' . number_format((float)$v, 2, ',', '.');
      return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
  };

  $descHtml = $deal['deal_description'] ?? '';

  // ---------- Tagline (primeira frase da descrição, com entidades decodificadas) ----------
  $tagline = '';
  if ($descHtml) {
      $descDecoded = html_entity_decode($descHtml, ENT_QUOTES, 'UTF-8'); // <-- decodifica &nbsp; etc
      $plain = trim(strip_tags($descDecoded));
      $plain = str_replace("\xC2\xA0", ' ', $plain); // NBSP -> espaço
      $plain = preg_replace('/\s+/u', ' ', $plain);
      $dot   = mb_strpos($plain, '.', 0, 'UTF-8');
      $tagline = $dot !== false ? mb_substr($plain, 0, $dot, 'UTF-8') : mb_substr($plain, 0, 130, 'UTF-8');
  }

  // ---------- URL absoluta da oferta (para share e fallback do CTA) ----------
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host   = $_SERVER['HTTP_HOST'] ?? 'conecta.ndmidia.com.br';
  $uri    = $_SERVER['REQUEST_URI'] ?? ('/?slug=' . urlencode($deal['deal_slug'] ?? ''));
  $currentUrl = $scheme . '://' . $host . $uri;

  // ---------- CTA (sempre ativo) ----------
  // Lê o link em múltiplas chaves possíveis
  $btnUrlRaw = $deal['deal_url']
            ?? $deal['deal_link']
            ?? $deal['url']
            ?? $deal['link']
            ?? $deal['coupon_url']
            ?? $deal['offer_url']
            ?? '';

  // Normaliza
  $btnUrlRaw = html_entity_decode(trim((string)$btnUrlRaw), ENT_QUOTES, 'UTF-8');

  // Se veio sem esquema (ex.: betocarrero.com.br), adiciona https://
  if ($btnUrlRaw !== '' && !preg_match('~^https?://~i', $btnUrlRaw)) {
      $btnUrlRaw = 'https://' . $btnUrlRaw;
  }

  // Valida
  $hasValidUrl = filter_var($btnUrlRaw, FILTER_VALIDATE_URL) !== false;

  // Define href do botão (só usa o fallback se NÃO for URL de verdade)
  $ctaHref  = $hasValidUrl ? $btnUrlRaw : $currentUrl;
  $ctaLabel = $hasValidUrl ? 'Aproveitar oferta' : 'Aproveitar oferta';

  // ===== Links de compartilhamento (título, subtítulo e imagem) =====
  $shareURL      = rawurlencode($currentUrl);
  $shareTitleRaw = trim($title);
  $shareSubRaw   = trim($tagline);
  $shareImgRaw   = (string)$imgUrl;

  // Texto mostrado nos apps (tweet, whatsapp, share sheet)
  $shareTextRaw  = $shareTitleRaw . ($shareSubRaw ? ' — ' . $shareSubRaw : '');
  $shareText     = rawurlencode($shareTextRaw);

  // Hashtag opcional (categoria ou loja)
  $shareHashtag  = '';
  if (!empty($category)) {
    $shareHashtag = '#' . preg_replace('~[^A-Za-z0-9_]+~', '', str_replace(' ', '_', mb_strtolower($category, 'UTF-8')));
  } elseif (!empty($storeSlug) || !empty($storeName)) {
    $shareHashtag = '#' . preg_replace('~[^A-Za-z0-9_]+~', '', str_replace(' ', '_', mb_strtolower($storeSlug ?: $storeName, 'UTF-8')));
  }
  $shareHashtagEnc = rawurlencode($shareHashtag);

  // Imagem para plataformas que aceitam URL (Pinterest) e para tentar anexar no share sheet
  $shareImg = rawurlencode($shareImgRaw);

  // Reportar — destino
  if (defined('CONTACT_EMAIL') && CONTACT_EMAIL) {
      $reportHref = 'mailto:' . CONTACT_EMAIL
                  . '?subject=' . rawurlencode('Report deal: ' . $shareTitleRaw)
                  . '&body='    . rawurlencode($currentUrl);
  } elseif (defined('CONTACT_URL') && CONTACT_URL) {
      $reportHref = CONTACT_URL;
  } else {
      $reportHref = './contact';
  }

  // Header da página (igual à home)
  require './sections/header.php';

  // --------- Vars auxiliares seguras ---------
  $deal_id = (int)($deal['deal_id'] ?? 0); // evita warning em data-deal-id
  $BASEURL = rtrim(SITEURL, '/');          // normaliza para construir URLs absolutas

  // Estado inicial de favorito (se estiver logado)
  $isFav = false;
  if (!empty($currentUserId) && function_exists('isInFav')) {
      try {
          $isFav = (bool) isInFav($connect, $currentUserId, $deal_id);
      } catch (Throwable $e) {
          // falha silenciosa, não quebra a página
          $isFav = false;
      }
  } // evita warning em data-deal-id
  $BASEURL = rtrim(SITEURL, '/');          // base para montar links internos
?>

<!-- ===================== SINGLE DEAL ===================== -->
<div class="uk-container uk-margin-large-top uk-margin-xlarge-bottom">

 <?php if (!empty($deal['deal_exclusive']) && (int)$deal['deal_exclusive'] === 1): ?>
  <?php
    // Pega o texto (ex: "EXCLUSIVO") e transforma em "Exclusivo"
    $labelText = isset($translation['tr_16']) ? (string)$translation['tr_16'] : 'Exclusivo';
    $labelText = mb_convert_case(mb_strtolower($labelText, 'UTF-8'), MB_CASE_TITLE, 'UTF-8');
  ?>
  <span class="uk-label uk-label-warning uk-border-pill uk-margin-small-bottom nd-label-exclusive">
    <span class="nd-label-icon" aria-hidden="true">
      <span uk-icon="icon: star; ratio: 0.7"></span>
    </span>
    <span class="nd-case-normal"><?= htmlspecialchars($labelText, ENT_QUOTES, 'UTF-8'); ?></span>
  </span>
<?php endif; ?>



  <div class="uk-text-meta uk-margin-small">
    <?php if ($category): ?>
      <span class="uk-text-uppercase">Categoria</span>
      <span class="uk-margin-small-left uk-margin-small-right">›</span>
      <span class="uk-text-uppercase"><?= htmlspecialchars($category, ENT_QUOTES, 'UTF-8'); ?></span>
    <?php endif; ?>
  </div>

  <h1 class="uk-article-title uk-margin-remove-top uk-margin-small-bottom">
    <?= htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?>
  </h1>

  <?php if ($tagline): ?>
    <div class="uk-text-lead uk-text-muted uk-margin-small-bottom">
      <?= htmlspecialchars($tagline, ENT_QUOTES, 'UTF-8'); ?>
    </div>
  <?php endif; ?>

  <div class="uk-grid-large uk-margin" uk-grid>
    <div class="uk-width-1-1 uk-width-2-3@m">
      <?php if (!empty($imgUrl)): ?>
        <img src="<?= htmlspecialchars($imgUrl, ENT_QUOTES, 'UTF-8'); ?>"
             alt="<?= htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?>"
             class="uk-width-1-1 uk-border-rounded">
      <?php else: ?>
        <div class="uk-background-muted uk-height-medium uk-flex uk-flex-middle uk-flex-center uk-border-rounded">
          <span class="uk-text-muted">Sem imagem</span>
        </div>
      <?php endif; ?>
    </div>

    <div class="uk-width-1-1 uk-width-1-3@m">
      <div class="uk-card uk-card-default uk-card-body uk-border-rounded">
        <div class="uk-margin-small-bottom">
          <span class="uk-label uk-border-pill uk-text-capitalize" style="background:#FF3D00;color:#fff;border-color:#FF3D00">★ Oferta excelente</span>
        </div>

        <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
          <?php if ($oldPrice !== null && $oldPrice !== ''): ?>
            <div class="uk-text-meta" style="text-decoration: line-through; margin-right:8px;">
              <?= $fmt($oldPrice); ?>
            </div>
          <?php endif; ?>
          <?php if ($price !== null && $price !== ''): ?>
            <div class="uk-h3 uk-margin-remove"><?= $fmt($price); ?></div>
          <?php endif; ?>
          <?php if ($discount !== null && $discount !== '' && is_numeric($discount)): ?>
            <span class="uk-label uk-label-success uk-border-pill uk-margin-small-left">
              <?= (int)$discount; ?>% Off
            </span>
          <?php endif; ?>
        
        </div>
        <!-- Avaliações compactas ao lado do preço -->
        <div class="nd-rating-snippet uk-flex uk-flex-middle uk-margin-small-bottom" aria-label="Avaliações">
          <span class="uk-margin-small-right"><?php echo showStars($deal['deal_rating'] ?? 0); ?></span>
          <span class="uk-text-meta">(<?php echo (int)($deal['total_reviews'] ?? 0); ?> avaliações)</span>
        </div>

        <!-- CTA sempre ativo (abre em nova aba quando for URL externa válida) -->
        <a class="uk-button uk-border-pill uk-width-1-1" style="background:#FF3D00;border-color:#FF3D00;color:#fff"
           href="<?= htmlspecialchars($ctaHref, ENT_QUOTES, 'UTF-8'); ?>"
           target="<?= $hasValidUrl ? '_blank' : '_self'; ?>" rel="noopener">
          <?= htmlspecialchars($ctaLabel, ENT_QUOTES, 'UTF-8'); ?>
        </a>

        <div class="uk-text-center uk-margin-small-top nd-offer-wishlist">
          <?php if ($canWrite && $currentUserId): ?>
            <?php
              // Botões de favorito usam o JS legado (classes addfav/removefav)
              $favAddLabel    = isset($translation['tr_183']) ? $translation['tr_183'] : 'Adicionar aos favoritos';
              $favRemoveLabel = isset($translation['tr_184']) ? $translation['tr_184'] : 'Remover dos favoritos';
            ?>
            <?php if ($isFav): ?>
              <span class="like uk-hidden">
                <button type="button"
                        class="uk-icon-button addfav"
                        uk-icon="icon: heart"
                        data-item="<?= (int)$deal_id ?>"
                        data-user="<?= (int)$currentUserId ?>"
                        title="<?= htmlspecialchars($favAddLabel, ENT_QUOTES, 'UTF-8'); ?>"
                        aria-label="<?= htmlspecialchars($favAddLabel, ENT_QUOTES, 'UTF-8'); ?>"></button>
              </span>
              <span class="unlike">
                <button type="button"
                        class="uk-icon-button uk-text-danger removefav"
                        uk-icon="icon: heart"
                        data-item="<?= (int)$deal_id ?>"
                        data-user="<?= (int)$currentUserId ?>"
                        title="<?= htmlspecialchars($favRemoveLabel, ENT_QUOTES, 'UTF-8'); ?>"
                        aria-label="<?= htmlspecialchars($favRemoveLabel, ENT_QUOTES, 'UTF-8'); ?>"></button>
              </span>
            <?php else: ?>
              <span class="like">
                <button type="button"
                        class="uk-icon-button addfav"
                        uk-icon="icon: heart"
                        data-item="<?= (int)$deal_id ?>"
                        data-user="<?= (int)$currentUserId ?>"
                        title="<?= htmlspecialchars($favAddLabel, ENT_QUOTES, 'UTF-8'); ?>"
                        aria-label="<?= htmlspecialchars($favAddLabel, ENT_QUOTES, 'UTF-8'); ?>"></button>
              </span>
              <span class="unlike uk-hidden">
                <button type="button"
                        class="uk-icon-button uk-text-danger removefav"
                        uk-icon="icon: heart"
                        data-item="<?= (int)$deal_id ?>"
                        data-user="<?= (int)$currentUserId ?>"
                        title="<?= htmlspecialchars($favRemoveLabel, ENT_QUOTES, 'UTF-8'); ?>"
                        aria-label="<?= htmlspecialchars($favRemoveLabel, ENT_QUOTES, 'UTF-8'); ?>"></button>
              </span>
            <?php endif; ?>
          <?php else: ?>
            <a class="uk-icon-button"
               uk-icon="icon: heart"
               href="<?= htmlspecialchars($loginUrl, ENT_QUOTES, 'UTF-8'); ?>"
               title="<?= htmlspecialchars(isset($translation['tr_185']) ? $translation['tr_185'] : 'Entre para salvar esta oferta', ENT_QUOTES, 'UTF-8'); ?>"
               aria-label="<?= htmlspecialchars(isset($translation['tr_185']) ? $translation['tr_185'] : 'Entre para salvar esta oferta', ENT_QUOTES, 'UTF-8'); ?>"></a>
          <?php endif; ?>
        </div>
      </div>

        <?php if (!empty($dealCoupons)): ?>
        <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-margin-top nd-coupon-card">
          <h4 class="uk-text-bold uk-margin-small-bottom">Cupons desta oferta</h4>

          <?php foreach ($dealCoupons as $cp): ?>
            <div class="uk-margin-small-bottom nd-coupon-item">
              <div class="uk-text-bold uk-margin-small-bottom">
                <?php echo htmlspecialchars($cp['coupon_title'] ?? ($cp['coupon_code'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>
              </div>

              <div class="uk-text-center nd-coupon-code-wrapper">
                <span class="uk-text-meta uk-display-block uk-margin-xsmall-bottom">Código:</span>
                <code class="nd-coupon-code nd-coupon-code-pill">
                  <?php echo htmlspecialchars($cp['coupon_code'] ?? '', ENT_QUOTES, 'UTF-8'); ?>
                </code>
              </div>

              <div class="uk-text-meta uk-text-center nd-coupon-meta uk-margin-xsmall-top">
                <?php if (!empty($cp['discount_percent'])): ?>
                  <span>Desconto: <?php echo (int)$cp['discount_percent']; ?>%</span>
                <?php endif; ?>
                <?php if (isset($cp['quantity']) && $cp['quantity'] !== '' && $cp['quantity'] !== null): ?>
                  <?php if (!empty($cp['discount_percent'])): ?> • <?php endif; ?>
                  <span>Quantidade: <?php echo (int)$cp['quantity']; ?></span>
                <?php endif; ?>
              </div>

              <div class="uk-margin-small-top nd-coupon-actions">
                <button type="button"
                        class="uk-button uk-button-primary uk-border-pill uk-width-1-1 nd-copy-coupon nd-copy-coupon-highlight"
                        data-code="<?php echo htmlspecialchars($cp['coupon_code'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                        data-deal-id="<?php echo (int)($deal['deal_id'] ?? 0); ?>"
                        data-title="<?php echo htmlspecialchars($cp['coupon_title'] ?? ($cp['coupon_code'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>"
                        onclick="var code=this.getAttribute('data-code')||'';if(!code)return false;if(navigator.clipboard&&navigator.clipboard.writeText){navigator.clipboard.writeText(code).then(function(){try{if(window.UIkit&&UIkit.notification){UIkit.notification({message:'Código copiado!',status:'success',timeout:2000});}else{alert('Código copiado: '+code);}}catch(e){alert('Código copiado: '+code);}}).catch(function(){prompt('Copie o código abaixo:',code);});}else{prompt('Copie o código abaixo:',code);}return false;">
                  Copiar código
                </button>
              </div>

              <hr class="uk-margin-small-top uk-margin-small-bottom">
            </div>
          <?php endforeach; ?>
        </div>
        <?php endif; ?>

    </div>
  </div>

  <!-- Descrição + Report + Store + Share -->
  <div class="uk-grid-large" uk-grid>
    <div class="uk-width-1-1 uk-width-2-3@m">
      <hr class="uk-margin-remove-top">
      <article class="uk-article uk-margin">
        <?php echo $descHtml; ?>
      </article>

      <!-- REPORT THIS (CLICÁVEL) -->
      <a href="#report-modal" uk-toggle class="uk-link-reset">
        <div class="uk-border-rounded uk-padding-small uk-margin" style="border:1px solid #eee;">
          <div class="uk-text-center uk-text-meta">
            <span uk-icon="info"></span>
            <span class="uk-margin-small-left">Reportar</span>
          </div>
        </div>
      </a>

      <!-- STORE ROW -->
      <?php if ($storeName !== ''): ?>
      <div class="uk-margin-small">
        <div class="uk-card uk-card-default uk-border-rounded">
          <div class="uk-card-body uk-padding-small">
            <div class="uk-flex uk-flex-middle uk-flex-between">
              <div class="uk-flex uk-flex-middle">
                <?php
                  $storeLogo = $deal['store_image'] ?? ($store['store_image'] ?? ($deal['logo'] ?? null));
                  if (!empty($storeLogo)):
                ?>
                  <img src="<?= htmlspecialchars($urlPath->image($storeLogo), ENT_QUOTES, 'UTF-8'); ?>"
                       alt="<?= htmlspecialchars($deal['store_name'] ?? ($store['store_name'] ?? 'Loja'), ENT_QUOTES, 'UTF-8'); ?>"
                       class="uk-border-circle" style="width:40px;height:40px;object-fit:cover;">
                <?php else: ?>
                  <div class="uk-border-circle uk-background-muted uk-flex uk-flex-center uk-flex-middle" style="width:40px;height:40px;font-weight:700;color:#555;"><?php $__ini = mb_strtoupper(mb_substr($storeName ?? 'L', 0, 1, 'UTF-8'), 'UTF-8'); echo htmlspecialchars($__ini, ENT_QUOTES, 'UTF-8'); ?></div>
                <?php endif; ?>
                <div class="uk-margin-small-left">
                  <div class="uk-text-bold"><?= htmlspecialchars($storeName, ENT_QUOTES, 'UTF-8'); ?></div>
                  <span class="uk-label uk-label-warning uk-border-pill uk-text-uppercase" style="font-size:11px;">PRO</span>
                </div>
              </div>
<?php
  // ====== LINK "VER LOJA" SEMPRE PARA /search?store=nomedaloja ======
  // Preferimos slug; se vazio, usamos o nome
  $storeQueryRaw = $storeSlug !== '' ? $storeSlug : $storeName;
  $storeQueryRaw = trim($storeQueryRaw);
  if ($storeQueryRaw !== '') {
      $storeUrl = $BASEURL . '/search?store=' . urlencode($storeQueryRaw);
  } else {
      // fallback seguro para não quebrar o href
      $storeUrl = $BASEURL . '/search';
  }
  $storeTarget = '_self'; // abre na mesma aba
?>
              <div>
                <a class="uk-button uk-button-default uk-border-pill"
                   href="<?= htmlspecialchars($storeUrl, ENT_QUOTES, 'UTF-8'); ?>"
                   target="<?= htmlspecialchars($storeTarget, ENT_QUOTES, 'UTF-8'); ?>" rel="noopener">
                  Ver loja
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
<script>
function copyLinkOffer(e){
  e && e.preventDefault();
  var u = window.location.href;
  if (navigator.clipboard && window.isSecureContext) {
    navigator.clipboard.writeText(u).then(function(){ alert('Link copiado!'); });
  } else { prompt('Copie o link:', u); }
  return false;
}

/**
 * Instagram / Share Sheet:
 * - Tenta baixar a imagem da oferta e usar navigator.share com arquivos (quando suportado).
 * - Fallback: usa apenas título + subtítulo + URL (share sheet) ou copia link.
 */
async function shareOfferWithImage(e){
  e && e.preventDefault();
  try{
    var container = document.querySelector('.nd-share-circles');
    var imgUrl = container ? container.getAttribute('data-share-img') : '';
    var title = document.querySelector('h1.uk-article-title')?.textContent?.trim() || document.title;
    var tagline = document.querySelector('.uk-text-lead')?.textContent?.trim() || '';
    var text = (tagline ? (title + ' — ' + tagline) : title);

    if (imgUrl && navigator.canShare && navigator.share) {
      try {
        const res = await fetch(imgUrl, {mode: 'cors'});
        const blob = await res.blob();
        const fileName = 'oferta.jpg';
        const file = new File([blob], fileName, {type: blob.type || 'image/jpeg'});
        if (navigator.canShare({ files: [file] })) {
          await navigator.share({ title: title, text: text, files: [file] });
          return false;
        }
      } catch (err) {
        console && console.warn('Não foi possível anexar a imagem no share:', err);
      }
    }
    var shareData = { title: title, text: text, url: window.location.href };
    if (navigator.share) {
      await navigator.share(shareData);
    } else {
      copyLinkOffer();
    }
  }catch(err){
    console && console.error(err);
    copyLinkOffer();
  }
  return false;
}
</script>


      <?php endif; ?>

      <!-- SHARE (círculos) -->

      <div class="uk-margin">
        <div class="uk-text-bold uk-margin-small-bottom">Compartilhar esta oferta</div>
        
<style id="nd-share-fallback-v4">
ul.nd-share-circles{display:flex!important;flex-wrap:wrap!important;gap:6px;padding:0 16px 8px;max-width:100%;overflow:visible!important}
ul.nd-share-circles a{width:36px;height:36px;border-radius:9999px;display:inline-flex;align-items:center;justify-content:center;box-sizing:border-box}
ul.nd-share-circles svg{width:18px;height:18px}
@media(min-width:421px){ul.nd-share-circles{gap:10px;padding:0 14px 8px}ul.nd-share-circles a{width:44px;height:44px}ul.nd-share-circles svg{width:20px;height:20px}}
</style>

<ul class="nd-share-circles" data-share-img="<?= htmlspecialchars($shareImgRaw, ENT_QUOTES, 'UTF-8'); ?>">
          <!-- Facebook: usa Share Dialog + quote + hashtag -->
          <li><a class="nd-share--facebook"
                 href="https://www.facebook.com/sharer/sharer.php?u=<?= $shareURL ?>&quote=<?= $shareText ?><?= $shareHashtag ? '&hashtag='.$shareHashtagEnc : '' ?>"
                 target="_blank" rel="noopener" aria-label="Facebook">
            <svg viewBox="0 0 24 24"><path d="M22 12.07C22 6.48 17.52 2 11.93 2S2 6.48 2 12.07c0 5.02 3.66 9.19 8.44 9.93v-7.02H7.9V12.1h2.54V9.8c0-2.5 1.49-3.89 3.77-3.89 1.09 0 2.23.2 2.23.2v2.45h-1.26c-1.24 0-1.63.77-1.63 1.56v1.87h2.78l-.44 2.88h-2.34V22c4.78-.74 8.44-4.91 8.44-9.93z"/></svg>
          </a></li>

          <!-- Instagram: tenta Web Share com arquivo; fallback para copiar link -->
          <li><a class="nd-share--instagram" href="#" onclick="return shareOfferWithImage(event);" aria-label="Instagram">
            <svg viewBox="0 0 24 24"><path d="M7 2h10a5 5 0 0 1 5 5v10a5 5 0 0 1-5 5H7a5 5 0 0 1-5-5V7a5 5 0 0 1 5-5zm0 2a3 3 0 0 0-3 3v10a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3H7zm5 3.5A5.5 5.5 0 1 1 6.5 13 5.5 5.5 0 0 1 12 7.5zm6.25-.75a1.25 1.25 0 1 1-1.25 1.25 1.25 1.25 0 0 1 1.25-1.25z"/></svg>
          </a></li>

          <!-- Twitter/X -->
          <li><a class="nd-share--twitter"
                 href="https://twitter.com/intent/tweet?url=<?= $shareURL ?>&text=<?= $shareText ?>"
                 target="_blank" rel="noopener" aria-label="Twitter">
            <svg viewBox="0 0 24 24"><path d="M22.46 6c-.77.35-1.6.58-2.46.69a4.3 4.3 0 0 0 1.88-2.37 8.59 8.59 0 0 1-2.72 1.04 4.28 4.28 0 0 0-7.3 3.9A12.14 12.14 0 0 1 3.15 5.15a4.27 4.27 0 0 0 1.33 5.71 4.25 4.25 0 0 1-1.94-.54v.05a4.29 4.29 0 0 0 3.44 4.2 4.26 4.26 0 0 1-1.93.07 4.29 4.29 0 0 0 4 2.97A8.6 8.6 0 0 1 2 19.54 12.14 12.14 0 0 0 8.56 21c7.34 0 11.36-6.08 11.36-11.36l-.01-.52A8.12 8.12 0 0 0 22.46 6z"/></svg>
          </a></li>

          <!-- LinkedIn -->
          <li><a class="nd-share--linkedin" href="https://www.linkedin.com/sharing/share-offsite/?url=<?= $shareURL ?>" target="_blank" rel="noopener" aria-label="LinkedIn">
            <svg viewBox="0 0 24 24"><path d="M6.94 6.5A2.44 2.44 0 1 1 4.5 4.06 2.44 2.44 0 0 1 6.94 6.5zM5 8.89h3.89V20H5zM13.22 8.89h3.73v1.52h.05a4.09 4.09 0 0 1 3.68-2.03c3.94 0 4.66 2.6 4.66 5.98V20h-3.89v-5.06c0-1.21-.02-2.77-1.69-2.77-1.69 0-1.95 1.32-1.95 2.68V20H13.2z"/></svg>
          </a></li>

          <!-- Pinterest (aceita media=imagem) -->
          <li><a class="nd-share--pinterest" href="https://pinterest.com/pin/create/button/?url=<?= $shareURL ?>&media=<?= $shareImg ?>&description=<?= $shareText ?>" target="_blank" rel="noopener" aria-label="Pinterest">
            <svg viewBox="0 0 24 24"><path d="M12.04 2C6.58 2 4 5.66 4 8.9c0 1.8.99 4.06 2.58 4.76.24.11.36.06.41-.16.04-.17.26-1 .36-1.39.03-.11.02-.21-.08-.32-.52-.61-.86-1.41-.86-2.54 0-3.28 2.46-6.23 6.4-6.23 3.49 0 5.41 2.13 5.41 4.98 0 3.75-1.86 6.35-4.28 6.35-1.34 0-2.35-1.1-2.02-2.44.38-1.58 1.1-3.28 1.1-4.41 0-1.02-.55-1.88-1.68-1.88-1.33 0-2.39 1.37-2.39 3.2 0 1.17.4 1.96.4 1.96l-1.62 6.84c-.48 2.02-.07 4.49-.04 4.74.02.13.18.16.25.06.11-.15 1.56-2.08 2.06-4.08.13-.52.8-3.24.8-3.24.39.74 1.54 1.39 2.77 1.39 3.65 0 6.13-3.32 6.13-7.77C18.21 4.87 15.6 2 12.04 2z"/></svg>
          </a></li>

          <!-- WhatsApp -->
          <li><a class="nd-share--whatsapp" href="https://api.whatsapp.com/send?text=<?= $shareText ?>%20-%20<?= $shareURL ?>" target="_blank" rel="noopener" aria-label="WhatsApp">
            <svg viewBox="0 0 24 24"><path d="M20.52 3.48A11.91 11.91 0 0 0 12 .1C5.37.1.1 5.37.1 12c0 2.1.55 4.15 1.59 5.95L.12 24l6.2-1.6A12 12 0 1 0 20.52 3.48zM12 21.5a9.5 9.5 0 0 1-4.83-1.3l-.35-.2-3.68 .95 .98-3.59-.23-.37A9.5 9.5 0 1 1 12 21.5zm5.5-6.92c-.3-.15-1.78-.88-2.06-.98-.28-.1-.49-.15-.7 .15-.21 .3-.8 .98-.98 1.18-.18 .2-.36 .22-.66 .07-.3-.15-1.26-.46-2.4-1.48-.89-.79-1.5-1.77-1.68-2.07-.18-.3-.02-.46 .13-.6 .13-.13 .3-.36 .44-.54 .15-.18 .2-.3 .3-.5 .1-.2 .05-.38-.02-.53-.07-.15-.7-1.68-.96-2.3-.25-.6-.5-.5-.7-.5h-.6c-.2 0-.53 .07-.8 .38-.27 .3-1.04 1.02-1.04 2.48s1.07 2.88 1.22 3.08c.15 .2 2.1 3.2 5.06 4.48.71 .31 1.26 .49 1.69 .63.71 .23 1.35 .2 1.86 .12.57 -.08 1.78 -.73 2.03 -1.44.25 -.71 .25 -1.33 .17 -1.46-.07 -.13-.27 -.2-.56 -.35z"/></svg>
          </a></li>

          <!-- Telegram -->
          <li><a class="nd-share--telegram" href="https://t.me/share/url?url=<?= $shareURL ?>&text=<?= $shareText ?>" target="_blank" rel="noopener" aria-label="Telegram">
            <svg viewBox="0 0 24 24"><path d="M21.944 3.164c.33-.144.688.177.57.62l-3.14 12.03c-.12.459-.47.66-.95.46l-5.01-2.16-2.42 2.35c-.27.266-.49.49-1 .49l.36-5.14 9.37-8.49c.41-.37-.09-.57-.64-.21L6.53 11.61l-5.06-1.58c-.53-.16-.54-.52.12-.78L21.944 3.164z"/></svg>
          </a></li>

          <!-- Copiar link -->
          </ul>
      </div>

      <!-- Avaliações de clientes -->
      <div class="uk-margin-large-top">
        <?php 
          $itemId = (int)($deal['deal_id'] ?? 0);
          $avgRating = (float)($deal['deal_rating'] ?? 0);
          $totalValid = (int)($deal['total_reviews'] ?? 0);
          // Usa view unificada com gating por login: mostra "Escrever avaliação" só quando logado
          require './sections/reviews.php';
        ?>
      </div>
    <!-- Related / Ofertas relacionadas --><!-- Related / Ofertas relacionadas -->
      <div class="uk-margin-large-top">
        <h3 class="uk-heading-bullet">Ofertas relacionadas</h3>
        <?php
          $itemId = (int)($deal['deal_id'] ?? 0);
          if ($itemId > 0) {
              require './sections/related-deals.php';
          }
        ?>
      </div>
    </div>

    <div class="uk-width-1-1 uk-width-1-3@m"><!-- coluna direita já usada acima --></div>
  </div>

</div>

<?php
  require __DIR__ . '/../sections/footer.php';
  return;
endif;
?>

<!-- ===================== HOME ORIGINAL (sem mudanças) ===================== -->

<!-- HEADER -->
<?php require './sections/header.php'; ?>

<!-- HOME -->
<?php require './sections/home.php'; ?>


<!-- CONTENT -->
<?php require './sections/exclusive-deals.php'; ?>
<?php require './sections/featured-deals.php'; ?>
<?php require './sections/featured-categories.php'; ?>
<?php require './sections/latest-deals.php'; ?>
<?php require './sections/featured-stores.php'; ?>
<?php require './sections/featured-locations.php'; ?>
<?php require './sections/plans.php'; ?>
<?php require './sections/categories.php'; ?>

<?php
  // Modals necessários para Report e Review quando há deal
  if (isset($deal) && is_array($deal) && !empty($deal)) {
      if ($settings['st_enable_report_form'] == 1) {
          require __DIR__ . '/../sections/views/report-modal.view.php';
      }
      require __DIR__ . '/../sections/views/submit-review.view.php';
      require __DIR__ . '/../sections/views/reviews-modal.view.php';
  }
?>

<!-- FOOTER -->
<?php require __DIR__ . '/../sections/footer.php'; ?><link rel="stylesheet" href="/assets/css/nd-share.css?v=4">
<script src="/assets/js/nd-rating-modal.js?v=1" defer></script>

<div id="submit-review" class="uk-modal" uk-modal data-item="<?php echo isset($deal['id'])?(int)$deal['id']:(isset($_GET['deal_id'])?(int)$_GET['deal_id']:0); ?>">
  <div class="uk-modal-dialog uk-modal-body uk-border-rounded">
    <button class="uk-modal-close-default" type="button" uk-close aria-label="Fechar"></button>
    <h3 class="uk-modal-title">Escrever avaliação</h3>
    <form id="nd-review-form">
      <div class="uk-margin-small">
        <div class="nd-star-picker" role="radiogroup" aria-label="Nota">
          <?php for($i=1;$i<=5;$i++): ?>
          <button type="button" class="nd-star" role="radio" aria-checked="false" aria-label="<?php echo $i; ?>">
            ★
          </button>
          <?php endfor; ?>
          <span class="nd-star-score"><span id="nd-rating-value">0</span>/5</span>
        </div>
        <input type="hidden" id="nd-rating-input" name="rating" value="0">
      </div>
      <div class="uk-margin">
        <textarea id="nd-review-text" class="uk-textarea" rows="4" placeholder="Conte sua experiência (opcional)"></textarea>
      </div>
      <div class="uk-text-right">
        <button class="uk-button uk-button-default uk-border-pill uk-modal-close" type="button">Cancelar</button>
        <button class="uk-button uk-button-primary uk-border-pill" type="submit">Enviar avaliação</button>
      </div>
    </form>
  </div>
</div>
<style>
.nd-star-picker{display:flex;align-items:center;gap:6px}
.nd-star{font-size:28px;line-height:1;border:none;background:none;cursor:pointer;padding:2px}
.nd-star.is-on{color:#FFC107}
.nd-star-score{margin-left:8px;font-weight:700}
</style>



<script>
/* Wishlist toggle (add/remove via controllers/like.php) */
function ndWishlistToggle(ev){
  ev && ev.preventDefault();
  try{
    var btn = ev.currentTarget || ev.target;
    var dealId = btn && btn.getAttribute('data-deal-id');
    if(!dealId){ console.warn('Sem data-deal-id no botão de wishlist'); return false; }
    var active = btn.classList.contains('is-active');
    var action = active ? 'remove' : 'add';
    fetch('/controllers/like.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      credentials: 'same-origin',
      body: 'action=' + encodeURIComponent(action) + '&item=' + encodeURIComponent(dealId)
    }).then(function(r){ return r.text(); })
    .then(function(){
      btn.classList.toggle('is-active');
    }).catch(function(e){
      alert('Não foi possível atualizar sua lista agora.');
      console.error(e);
    });
  }catch(e){ console.error(e); }
  return false;
}
</script>

<script src="/assets/js/nd-offer-modals.js?v=31" defer></script>
