<?php
// View: Landing de Anunciantes
?>

<link rel="stylesheet" href="<?php echo $urlPath->assets_css('lead-pages.css'); ?>">

<div class="nd-lead uk-section uk-section-muted uk-padding-remove-top">
  <div class="uk-container uk-margin-medium-top">

    <div class="nd-hero uk-padding uk-light uk-margin-medium-bottom">
      <div class="uk-grid-medium uk-flex-middle" uk-grid>
        <div class="uk-width-2-3@m">
          <div class="nd-hero-badge uk-margin-small-bottom">
            <span uk-icon="icon: world; ratio: .9"></span>
            Anunciantes do comércio local
          </div>
          <h1 class="uk-margin-remove-top uk-margin-small-bottom uk-heading-small">Anuncie no Conecta</h1>
          <p class="uk-text-lead uk-margin-remove-top" style="max-width: 62ch; opacity:.92">
            Sua empresa aparece onde as pessoas estão: na palma da mão. Publique ofertas, cupons e campanhas e ganhe alcance
            com a rede de associados (motoristas) + tráfego orgânico da plataforma.
          </p>

          <div class="uk-grid-small uk-child-width-1-3@m uk-margin-top" uk-grid>
            <div>
              <div class="nd-kpi">
                <div class="v">Ofertas</div>
                <div class="l">Cupons, combos e promoções</div>
              </div>
            </div>
            <div>
              <div class="nd-kpi">
                <div class="v">Métricas</div>
                <div class="l">Cliques e interesse por campanha</div>
              </div>
            </div>
            <div>
              <div class="nd-kpi">
                <div class="v">Rede</div>
                <div class="l">Associados divulgando o portal</div>
              </div>
            </div>
          </div>

          <div class="uk-margin-top uk-flex uk-flex-wrap uk-flex-middle" style="gap:10px">
            <a href="#form" class="uk-button uk-button-primary uk-border-pill uk-button-large">Quero anunciar</a>
            <a href="/signup" class="uk-button uk-button-default uk-border-pill uk-button-large">Já tenho conta</a>
          </div>

          <p class="uk-text-small uk-margin-top" style="opacity:.82">
            Este formulário é para <strong>captação de interesse</strong>. Depois do contato, a equipe cria (ou ativa) seu acesso e orienta sobre a melhor configuração.
          </p>
        </div>

        <div class="uk-width-1-3@m uk-visible@m">
          <div class="uk-card uk-card-default nd-card uk-card-body">
            <h3 class="uk-card-title uk-margin-remove-bottom">O que você ganha</h3>
            <ul class="uk-list uk-list-divider uk-margin-small-top">
              <li><span uk-icon="check"></span> Presença digital com página da sua empresa</li>
              <li><span uk-icon="check"></span> Divulgação de ofertas para público local</li>
              <li><span uk-icon="check"></span> Relatórios e métricas de interesse</li>
            </ul>
            <div class="uk-alert-primary uk-margin-top" uk-alert>
              <p class="uk-margin-remove">Bônus: campanhas sazonais (datas especiais) com destaque.</p>
            </div>
          </div>
        </div>
      </div>
    </div>

    
    <!-- Por que anunciar + ilustrações -->
    <div class="uk-section uk-section-default uk-padding-small nd-white uk-margin-medium-bottom">
      <div class="uk-container">
        <div class="uk-grid-large uk-flex-middle" uk-grid>
          <div class="uk-width-1-2@m">
            <h2 class="uk-margin-remove-top nd-nowrap-desktop">Anúncio local que dá resultado (e dá pra medir)</h2>
            <p class="uk-text-lead uk-margin-small-top" style="max-width: 62ch">
              Você aparece para pessoas em deslocamento — com atenção real — e transforma leitura de QR em visitas,
              contatos e pedidos. Tudo com métricas por campanha.
            </p>

            <ul class="uk-list uk-list-bullet uk-margin-small-top">
              <li><strong>Momento certo:</strong> no carro, com tempo e curiosidade para explorar ofertas.</li>
              <li><strong>Tráfego mensurável:</strong> leituras e cliques por campanha.</li>
              <li><strong>Oferta irresistível:</strong> cupom, brinde, 2 por 1, desconto no primeiro pedido…</li>
              <li><strong>Rede viva:</strong> associados divulgando diariamente em diferentes rotas e bairros.</li>
            </ul>

            <div class="uk-flex uk-flex-wrap uk-flex-middle uk-margin-top" style="gap:10px">
              <a href="/pricing" class="uk-button uk-button-default uk-border-pill">Ver planos e valores</a>
              <a href="#form" class="uk-button uk-button-primary uk-border-pill">Quero anunciar</a>
            </div>
          </div>

          <div class="uk-width-1-2@m">
            <div class="uk-grid-small uk-child-width-1-2@s" uk-grid>
              <div>
                <div class="nd-illus-card">
                  <img src="<?php echo $urlPath->assets_img('qr-sticker-car.svg'); ?>" alt="QR Code no vidro do carro">
                  <div class="p">
                    <div class="t">Visibilidade sem incômodo</div>
                    <div class="d">QR discreto e sempre disponível para o passageiro.</div>
                  </div>
                </div>
              </div>
              <div>
                <div class="nd-illus-card">
                  <img src="<?php echo $urlPath->assets_img('qr-headrest-holder.svg'); ?>" alt="Suporte com QR Code no banco">
                  <div class="p">
                    <div class="t">No alcance do cliente</div>
                    <div class="d">Suporte no banco do passageiro gera curiosidade e leitura.</div>
                  </div>
                </div>
              </div>
              <div class="uk-width-1-1">
                <div class="nd-illus-wide">
                  <img src="<?php echo $urlPath->assets_img('qr-scan-reward.svg'); ?>" alt="Métricas e resultados">
                  <div class="p">
                    <div class="t">Métricas claras</div>
                    <div class="d">Você acompanha o desempenho da sua campanha e ajusta a oferta para vender mais.</div>
                  </div>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>

    <!-- Embed de planos (usa sua página /pricing) -->
    <div class="uk-section uk-section-muted uk-padding-small uk-margin-medium-bottom">
      <div class="uk-container">
        <div class="uk-flex uk-flex-between uk-flex-middle" style="gap:10px" uk-grid>
          <div class="uk-width-expand">
            <h3 class="uk-margin-remove">Planos para anunciantes</h3>
            <p class="uk-text-small uk-text-muted uk-margin-small-top">Escolha um plano e comece com uma oferta que faça sentido pro seu bairro.</p>
          </div>
          <div class="uk-width-auto@s">
            <a href="/pricing" class="uk-button uk-button-default uk-border-pill">Abrir planos</a>
          </div>
        </div>

        <div class="uk-margin-top">
          <?php require __DIR__ . '/../sections/plans.php'; ?>
        </div>
      </div>
    </div>

	    <!-- Projeção de alcance (estimativa) -->
	    <div class="uk-section uk-section-default uk-padding-small nd-white uk-margin-medium-bottom">
	      <div class="uk-container">
	        <div class="uk-grid-large uk-flex-middle" uk-grid>
	          <div class="uk-width-1-2@m">
	            <h2 class="uk-margin-remove-top">Quanto dá pra alcançar com a rede de associados?</h2>
	            <p class="uk-text-lead uk-margin-small-top" style="max-width: 62ch">
              Simule o alcance na sua cidade com uma projeção simples. Ajuste os números e veja a estimativa atualizando na hora.
            </p>

	            <div class="uk-grid-small uk-child-width-1-2@s uk-margin-top" uk-grid>
	              <div>
	                <label class="uk-form-label uk-text-small">Associados ativos na sua cidade</label>
	                <input class="uk-input uk-border-pill" id="ndCalcDrivers" type="number" min="1" value="30">
	              </div>
	              <div>
	                <label class="uk-form-label uk-text-small">Horas/semana por associado</label>
	                <input class="uk-input uk-border-pill" id="ndCalcHours" type="number" min="1" step="0.1" value="45.9">
	              </div>
	              <div>
	                <label class="uk-form-label uk-text-small">Corridas por hora (média)</label>
	                <input class="uk-input uk-border-pill" id="ndCalcTrips" type="number" min="0.5" step="0.1" value="2.5">
	                <div class="nd-form-help">Dica: em horário bom, dá pra ficar entre 2 e 3.</div>
	              </div>
	              <div>
	                <label class="uk-form-label uk-text-small">Taxa de leitura do QR (%)</label>
	                <input class="uk-input uk-border-pill" id="ndCalcScan" type="number" min="0.5" step="0.1" value="3">
	                <div class="nd-form-help">Leitura é quando a pessoa realmente abre o QR.</div>
	              </div>
	            </div>

	            <div class="uk-alert-primary uk-margin-top" uk-alert>
	              <p class="uk-margin-remove">
	                <strong>O que a gente mostra aqui:</strong> “impactos” = passageiros que viram o QR no carro;
	                “leituras” = pessoas que realmente escanearam.
	              </p>
	            </div>
	          </div>

	          <div class="uk-width-1-2@m">
	            <div class="uk-grid-small uk-child-width-1-2@s" uk-grid>
	              <div>
	                <div class="nd-reach-card">
	                  <div class="k"><span uk-icon="icon: users; ratio: .85"></span> Impactos / dia</div>
	                  <div class="v" id="ndOutImpDay">—</div>
	                  <div class="h">Pessoas vendo o QR durante as corridas.</div>
	                </div>
	              </div>
	              <div>
	                <div class="nd-reach-card">
	                  <div class="k"><span uk-icon="icon: calendar; ratio: .85"></span> Impactos / mês</div>
	                  <div class="v" id="ndOutImpMonth">—</div>
	                  <div class="h">Volume total para campanha local.</div>
	                </div>
	              </div>
	              <div>
	                <div class="nd-reach-card nd-reach-accent">
	                  <div class="k"><span uk-icon="icon: bolt; ratio: .85"></span> Leituras / mês</div>
	                  <div class="v" id="ndOutScansMonth">—</div>
	                  <div class="h">Estimativa (ajuste a taxa de leitura).</div>
	                </div>
	              </div>
	              <div>
	                <div class="nd-reach-card">
	                  <div class="k"><span uk-icon="icon: star; ratio: .85"></span> Recompensa (associados)</div>
	                  <div class="v">1.000 leituras</div>
	                  <div class="h">Associado não paga nada e é recompensado por performance.</div>
	                </div>
	              </div>
	            </div>

	            <p class="uk-text-small uk-text-muted uk-margin-top" style="max-width: 70ch">
	              Observação: isto é uma <strong>estimativa</strong> (varia por cidade, horários e oferta). O dado de 45,9h/semana está como padrão por ser uma referência comum para motoristas de app (trabalho principal).
	            </p>
	          </div>
	        </div>
	      </div>
	    </div>

<div class="uk-grid-large" uk-grid>
      <div class="uk-width-2-3@m">

        <?php if (!empty($success)): ?>
          <div class="uk-alert-success nd-success" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <p class="uk-margin-remove">
              <?php echo htmlspecialchars((string)$success, ENT_QUOTES, 'UTF-8'); ?>
            </p>
          </div>
        <?php endif; ?>

        <?php if (!empty($errors)): ?>
          <div class="uk-alert-danger nd-error" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <ul class="uk-margin-remove">
              <?php foreach ($errors as $e): ?>
                <li><?php echo htmlspecialchars((string)$e, ENT_QUOTES, 'UTF-8'); ?></li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>

        <div class="uk-card uk-card-default nd-card uk-card-body" id="form">
          <h2 class="uk-card-title uk-margin-remove-bottom">Cadastro de interesse (Anunciante)</h2>
          <p class="uk-margin-small-top uk-text-muted">Preencha e a equipe te envia uma proposta.</p>

          <form method="post" action="" class="uk-form-stacked uk-margin-top">
            <div class="uk-grid-small" uk-grid>
              <div class="uk-width-1-2@m">
                <label class="uk-form-label">Empresa</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" name="company_name" required value="<?php echo htmlspecialchars((string)$company, ENT_QUOTES, 'UTF-8'); ?>" placeholder="Nome da empresa">
                </div>
              </div>
              <div class="uk-width-1-2@m">
                <label class="uk-form-label">Responsável</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" name="contact_name" required value="<?php echo htmlspecialchars((string)$name, ENT_QUOTES, 'UTF-8'); ?>" placeholder="Seu nome">
                </div>
              </div>

              <div class="uk-width-1-2@m">
                <label class="uk-form-label">E-mail</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" type="email" name="contact_email" required value="<?php echo htmlspecialchars((string)$email, ENT_QUOTES, 'UTF-8'); ?>" placeholder="contato@empresa.com">
                </div>
              </div>
              <div class="uk-width-1-2@m">
                <label class="uk-form-label">WhatsApp</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" name="contact_phone" value="<?php echo htmlspecialchars((string)$phone, ENT_QUOTES, 'UTF-8'); ?>" placeholder="(48) 9XXXX-XXXX">
                </div>
              </div>

              <div class="uk-width-1-2@m">
                <label class="uk-form-label">Cidade</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" name="city" value="<?php echo htmlspecialchars((string)$city, ENT_QUOTES, 'UTF-8'); ?>" placeholder="Ex: Florianópolis">
                </div>
              </div>
              <div class="uk-width-1-2@m">
                <label class="uk-form-label">UF</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" name="state" maxlength="2" value="<?php echo htmlspecialchars((string)$state, ENT_QUOTES, 'UTF-8'); ?>" placeholder="SC">
                </div>
              </div>

              <div class="uk-width-1-2@m">
                <label class="uk-form-label">Segmento</label>
                <div class="uk-form-controls">
                  <select class="uk-select uk-border-pill" name="segment">
                    <option value="">Selecione…</option>
                    <?php
                      $opts = ['Restaurante / Alimentação','Mercado / Hortifruti','Moda / Acessórios','Beleza / Estética','Saúde / Clínica','Serviços','Hotelaria / Turismo','Outros'];
                      foreach ($opts as $opt) {
                        $sel = ($segment === $opt) ? 'selected' : '';
                        echo '<option '.$sel.' value="'.htmlspecialchars($opt, ENT_QUOTES, 'UTF-8').'">'.htmlspecialchars($opt, ENT_QUOTES, 'UTF-8').'</option>';
                      }
                    ?>
                  </select>
                </div>
              </div>

              <div class="uk-width-1-2@m">
                <label class="uk-form-label">Objetivo principal</label>
                <div class="uk-form-controls">
                  <select class="uk-select uk-border-pill" name="objective">
                    <option value="">Selecione…</option>
                    <?php
                      $objs = ['Gerar visitas na loja','Vender mais (cupons/ofertas)','Divulgar marca','Lançamento / inauguração','Queima de estoque','Outros'];
                      foreach ($objs as $o) {
                        $sel = ($objective === $o) ? 'selected' : '';
                        echo '<option '.$sel.' value="'.htmlspecialchars($o, ENT_QUOTES, 'UTF-8').'">'.htmlspecialchars($o, ENT_QUOTES, 'UTF-8').'</option>';
                      }
                    ?>
                  </select>
                </div>
              </div>

              <div class="uk-width-1-1">
                <label class="uk-form-label">Mensagem (opcional)</label>
                <div class="uk-form-controls">
                  <textarea class="uk-textarea" name="message" rows="4" placeholder="Conte rapidamente o que você quer divulgar (ex: cupom, combo, desconto, datas)"><?php echo htmlspecialchars((string)$message, ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
              </div>
            </div>

            <div class="uk-margin">
              <label>
                <input class="uk-checkbox" type="checkbox" name="consent" value="1" required>
                <span class="uk-margin-small-left">Concordo em receber contato com proposta e informações de anúncios.</span>
              </label>
            </div>

            <div class="uk-margin">
              <button class="uk-button uk-button-primary uk-button-large uk-border-pill" type="submit">
                Enviar interesse
              </button>
            </div>
            <p class="uk-text-small uk-text-muted uk-margin-remove">Ao enviar, você autoriza o uso dos dados para contato comercial.</p>
          </form>
        </div>

        <div class="uk-card uk-card-default nd-card uk-card-body uk-margin-top">
          <h3 class="uk-card-title">Como a divulgação acontece</h3>
          <div class="uk-grid-small uk-child-width-1-3@m" uk-grid>
            <div>
              <div class="uk-padding-small uk-background-muted uk-border-rounded">
                <div class="uk-text-bold">1) Você cria uma oferta</div>
                <div class="uk-text-small uk-text-muted">Cupom, combo, desconto ou campanha.</div>
              </div>
            </div>
            <div>
              <div class="uk-padding-small uk-background-muted uk-border-rounded">
                <div class="uk-text-bold">2) Publicação na plataforma</div>
                <div class="uk-text-small uk-text-muted">Página da empresa + listagens e categorias.</div>
              </div>
            </div>
            <div>
              <div class="uk-padding-small uk-background-muted uk-border-rounded">
                <div class="uk-text-bold">3) Alcance via rede</div>
                <div class="uk-text-small uk-text-muted">Associados divulgam o portal por QR e links.</div>
              </div>
            </div>
          </div>
        </div>

      </div>

      <div class="uk-width-1-3@m">
        <div class="nd-sticky">
          <div class="uk-card uk-card-default nd-card uk-card-body">
            <h3 class="uk-card-title uk-margin-remove-bottom">Dúvidas?</h3>
            <p class="uk-margin-small-top uk-text-muted">Se preferir, fale direto com a equipe.</p>
            <a href="/<?php echo htmlspecialchars(CONTACT_PAGE ?? 'contact', ENT_QUOTES, 'UTF-8'); ?>" class="uk-button uk-button-default uk-border-pill uk-width-1-1">Página de contato</a>
            <hr>
            <p class="uk-text-small uk-text-muted uk-margin-remove">Já tem cadastro na plataforma?</p>
            <a href="/signin" class="uk-button uk-button-primary uk-border-pill uk-width-1-1 uk-margin-small-top">Entrar</a>
          </div>

          <div class="uk-card uk-card-default nd-card uk-card-body uk-margin-top">
            <h4 class="uk-margin-remove-top">Sugestões de ofertas</h4>
            <ul class="uk-list uk-list-bullet uk-text-small uk-text-muted uk-margin-small-top">
              <li>Primeira compra com desconto</li>
              <li>Combo (ex: lanche + bebida)</li>
              <li>Happy hour / horário de baixo movimento</li>
              <li>Cupons para datas especiais</li>
            </ul>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>

<script>
(function(){
  function fmt(n){
    try{ return Math.round(n).toLocaleString('pt-BR'); }catch(e){ return Math.round(n); }
  }

  function calc(){
    var drivers = parseFloat(document.getElementById('ndCalcDrivers')?.value || 0);
    var hoursW  = parseFloat(document.getElementById('ndCalcHours')?.value || 0);
    var tripsH  = parseFloat(document.getElementById('ndCalcTrips')?.value || 0);
    var scanP   = parseFloat(document.getElementById('ndCalcScan')?.value || 0);

    if(!drivers || !hoursW || !tripsH){
      document.getElementById('ndOutImpDay').textContent = '—';
      document.getElementById('ndOutImpMonth').textContent = '—';
      document.getElementById('ndOutScansMonth').textContent = '—';
      return;
    }

    // premissas simples
    var daysPerWeek = 6; // padrão
    var weeksPerMonth = 4; // arredondado para estimativa
    var impactsWeek = drivers * (hoursW * tripsH); // 1 corrida ~ 1 passageiro vendo o QR
    var impactsDay  = impactsWeek / daysPerWeek;
    var impactsMonth= impactsWeek * weeksPerMonth;
    var scansMonth  = impactsMonth * (scanP/100);

    document.getElementById('ndOutImpDay').textContent = fmt(impactsDay);
    document.getElementById('ndOutImpMonth').textContent = fmt(impactsMonth);
    document.getElementById('ndOutScansMonth').textContent = fmt(scansMonth);
  }

  ['ndCalcDrivers','ndCalcHours','ndCalcTrips','ndCalcScan'].forEach(function(id){
    var el = document.getElementById(id);
    if(el){ el.addEventListener('input', calc); }
  });

  // inicial
  if(document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', calc);
  }else{
    calc();
  }
})();
</script>
