<?php
// View: Landing de Associados
?>

<link rel="stylesheet" href="<?php echo $urlPath->assets_css('lead-pages.css'); ?>">

<div class="nd-lead uk-section uk-section-muted uk-padding-remove-top">
  <div class="uk-container uk-margin-medium-top">

    <div class="nd-hero uk-padding uk-light uk-margin-medium-bottom">
      <div class="uk-grid-medium uk-flex-middle" uk-grid>
        <div class="uk-width-2-3@m">
          <div class="nd-hero-badge uk-margin-small-bottom">
            <span uk-icon="icon: bolt; ratio: .9"></span>
            Programa de associados
          </div>
          <h1 class="uk-margin-remove-top uk-margin-small-bottom uk-heading-small">Seja um Associado</h1>
          <p class="uk-text-lead uk-margin-remove-top" style="max-width: 58ch; opacity:.92">
            Motoristas de Uber, 99, Táxi e apps similares: divulgue ofertas do comércio local para seus passageiros
            com um QR Code exclusivo e acompanhe o desempenho.
          </p>

          <div class="uk-grid-small uk-child-width-1-3@m uk-margin-top" uk-grid>
            <div>
              <div class="nd-kpi">
                <div class="v">QR Code</div>
                <div class="l">Link rastreável do associado</div>
              </div>
            </div>
            <div>
              <div class="nd-kpi">
                <div class="v">Painel</div>
                <div class="l">Ranking e cliques do mês</div>
              </div>
            </div>
            <div>
              <div class="nd-kpi">
                <div class="v">Campanhas</div>
                <div class="l">Ofertas e cupons locais</div>
              </div>
            </div>
          </div>

          <div class="uk-margin-top uk-flex uk-flex-wrap uk-flex-middle" style="gap:10px">
            <a href="#form" class="uk-button uk-button-primary uk-border-pill uk-button-large">Quero me cadastrar</a>
            <a href="/dashboard/associate_login.php" class="uk-button uk-button-default uk-border-pill uk-button-large">Já tenho código</a>
          </div>

          <p class="uk-text-small uk-margin-top" style="opacity:.82">
            Depois do cadastro, sua solicitação fica <strong>pendente</strong> até aprovação. Assim que ativar, você já consegue entrar no painel com seu código.
          </p>
        </div>

        <div class="uk-width-1-3@m uk-visible@m">
          <div class="uk-card uk-card-default nd-card uk-card-body">
            <h3 class="uk-card-title uk-margin-remove-bottom">Como funciona</h3>
            <ul class="uk-list uk-list-divider uk-margin-small-top">
              <li><span uk-icon="check"></span> Você recebe um <strong>código</strong> e um link/QR.</li>
              <li><span uk-icon="check"></span> Passageiro aponta a câmera e acessa as ofertas.</li>
              <li><span uk-icon="check"></span> O sistema registra cliques no seu QR (métricas).</li>
            </ul>
            <div class="uk-alert-primary uk-margin-top" uk-alert>
              <p class="uk-margin-remove">Dica: cole o QR em um suporte no banco do passageiro.</p>
            </div>
          </div>
        </div>
      </div>
    </div>

    
    <!-- Como funciona + ilustrações -->
    <div class="uk-section uk-section-default uk-padding-small nd-white uk-margin-medium-bottom">
      <div class="uk-container">
        <div class="uk-grid-large uk-flex-middle" uk-grid>
          <div class="uk-width-1-2@m">
            <h2 class="uk-margin-remove-top">Você não paga nada — e ainda é recompensado</h2>
            <p class="uk-text-lead uk-margin-small-top" style="max-width: 60ch">
              A gente envia o kit (adesivo + suporte). Você instala no carro e pronto:
              cada leitura do seu QR Code conta e você acompanha tudo no painel.
            </p>

            <ul class="uk-list uk-list-bullet uk-margin-small-top">
              <li><strong>Custo zero:</strong> cadastro e participação gratuitos.</li>
              <li><strong>Kit físico:</strong> adesivo para o vidro + suporte para o banco do passageiro.</li>
              <li><strong>Recompensa:</strong> a cada <strong>1.000 leituras</strong> do seu QR Code.</li>
            </ul>

            <div class="uk-flex uk-flex-wrap uk-flex-middle uk-margin-top" style="gap:10px">
              <a href="#form" class="uk-button uk-button-primary uk-border-pill">Quero meu código</a>
              <a href="/dashboard/associate_login.php" class="uk-button uk-button-default uk-border-pill">Já tenho código</a>
            </div>

            <p class="uk-text-small uk-text-muted uk-margin-small-top" style="max-width: 70ch">
              Nós mesmos produzimos e enviamos os materiais (adesivo e suporte). É só cadastrar e aguardar a aprovação.
            </p>
          </div>

          <div class="uk-width-1-2@m">
            <div class="uk-grid-small uk-child-width-1-2@s" uk-grid>
              <div>
                <div class="nd-illus-card">
                  <img src="<?php echo $urlPath->assets_img('qr-sticker-car.svg'); ?>" alt="Adesivo de QR Code no vidro do carro">
                  <div class="p">
                    <div class="t">Adesivo no vidro</div>
                    <div class="d">Discreto, resistente e fácil de aplicar.</div>
                  </div>
                </div>
              </div>
              <div>
                <div class="nd-illus-card">
                  <img src="<?php echo $urlPath->assets_img('qr-headrest-holder.svg'); ?>" alt="Suporte com QR Code no banco do passageiro">
                  <div class="p">
                    <div class="t">Suporte no banco</div>
                    <div class="d">No alcance do passageiro, com aparência profissional.</div>
                  </div>
                </div>
              </div>
              <div class="uk-width-1-1">
                <div class="nd-illus-wide">
                  <img src="<?php echo $urlPath->assets_img('qr-scan-reward.svg'); ?>" alt="Leituras do QR Code viram recompensa">
                  <div class="p">
                    <div class="t">Leituras = recompensa</div>
                    <div class="d">Acompanhe as leituras no painel e receba quando bater 1.000 leituras do seu QR.</div>
                  </div>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
<div class="uk-grid-large" uk-grid>
      <div class="uk-width-2-3@m">

        <?php if (!empty($success)): ?>
          <div class="uk-alert-success nd-success" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <p class="uk-margin-remove">
              <?php echo htmlspecialchars((string)$success, ENT_QUOTES, 'UTF-8'); ?>
              <br><span class="uk-text-small">Guarde esse código. Você vai usar para entrar no painel do associado.</span>
            </p>
            <div class="uk-margin-top">
              <a class="uk-button uk-button-primary uk-border-pill" href="/dashboard/associate_login.php">Acessar painel do associado</a>
            </div>
          </div>
        <?php endif; ?>

        <?php if (!empty($errors)): ?>
          <div class="uk-alert-danger nd-error" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <ul class="uk-margin-remove">
              <?php foreach ($errors as $e): ?>
                <li><?php echo htmlspecialchars((string)$e, ENT_QUOTES, 'UTF-8'); ?></li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>

        <div class="uk-card uk-card-default nd-card uk-card-body" id="form">
          <h2 class="uk-card-title uk-margin-remove-bottom">Cadastro de associado</h2>
          <p class="uk-margin-small-top uk-text-muted">Preencha para receber seu código e entrar na rede.</p>

          <form method="post" action="" class="uk-form-stacked uk-margin-top">
            <div class="uk-grid-small" uk-grid>
              <div class="uk-width-1-2@m">
                <label class="uk-form-label">Nome completo</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" name="associate_name" required value="<?php echo htmlspecialchars((string)$name, ENT_QUOTES, 'UTF-8'); ?>" placeholder="Seu nome">
                </div>
              </div>
              <div class="uk-width-1-2@m">
                <label class="uk-form-label">E-mail</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" type="email" name="associate_email" required value="<?php echo htmlspecialchars((string)$email, ENT_QUOTES, 'UTF-8'); ?>" placeholder="voce@exemplo.com">
                </div>
              </div>

              <div class="uk-width-1-2@m">
                <label class="uk-form-label">WhatsApp</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" name="associate_phone" value="<?php echo htmlspecialchars((string)$phone, ENT_QUOTES, 'UTF-8'); ?>" placeholder="(48) 9XXXX-XXXX">
                  <div class="nd-form-help uk-margin-small-top">Use um número que você realmente usa no dia a dia.</div>
                </div>
              </div>

              <div class="uk-width-1-4@m">
                <label class="uk-form-label">UF</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" name="associate_state" maxlength="2" value="<?php echo htmlspecialchars((string)$state, ENT_QUOTES, 'UTF-8'); ?>" placeholder="SC">
                </div>
              </div>

              <div class="uk-width-1-4@m">
                <label class="uk-form-label">Cidade</label>
                <div class="uk-form-controls">
                  <input class="uk-input uk-border-pill" name="associate_city" value="<?php echo htmlspecialchars((string)$city, ENT_QUOTES, 'UTF-8'); ?>" placeholder="Florianópolis">
                </div>
              </div>

              <div class="uk-width-1-2@m">
                <label class="uk-form-label">Você roda por qual app?</label>
                <div class="uk-form-controls">
                  <select class="uk-select uk-border-pill" name="associate_group">
                    <?php
                      $opts = ['Uber','99','Táxi','InDrive','Outro'];
                      foreach ($opts as $opt) {
                        $sel = ($group === $opt) ? 'selected' : '';
                        echo '<option '.$sel.' value="'.htmlspecialchars($opt, ENT_QUOTES, 'UTF-8').'">'.htmlspecialchars($opt, ENT_QUOTES, 'UTF-8').'</option>';
                      }
                    ?>
                  </select>
                </div>
              </div>
            </div>

            <div class="uk-margin">
              <label>
                <input class="uk-checkbox" type="checkbox" name="consent" value="1" required>
                <span class="uk-margin-small-left">Concordo em receber contato sobre o programa de associados.</span>
              </label>
            </div>

            <div class="uk-margin">
              <button class="uk-button uk-button-primary uk-button-large uk-border-pill" type="submit">
                Enviar cadastro
              </button>
            </div>

            <p class="uk-text-small uk-text-muted uk-margin-remove">
              Ao enviar, você autoriza o uso dos dados para contato e ativação do cadastro.
            </p>
          </form>
        </div>

        <div class="uk-card uk-card-default nd-card uk-card-body uk-margin-top">
          <h3 class="uk-card-title">Perguntas rápidas</h3>
          <ul uk-accordion>
            <li>
              <a class="uk-accordion-title" href="#">Quanto tempo para ativar?</a>
              <div class="uk-accordion-content">
                <p>O cadastro entra como <strong>pendente</strong>. A equipe faz a validação e ativa no painel admin.</p>
              </div>
            </li>
            <li>
              <a class="uk-accordion-title" href="#">Como eu acompanho os cliques?</a>
              <div class="uk-accordion-content">
                <p>Depois de ativado, você entra no painel do associado com seu código e acompanha as métricas.</p>
              </div>
            </li>
            <li>
              <a class="uk-accordion-title" href="#">Preciso pagar?</a>
              <div class="uk-accordion-content">
                <p>O programa pode ter regras por cidade/campanha. Depois do cadastro, a equipe te explica como funciona na sua região.</p>
              </div>
            </li>
          </ul>
        </div>

      </div>

      <div class="uk-width-1-3@m">
        <div class="nd-sticky">
          <div class="uk-card uk-card-default nd-card uk-card-body">
            <h3 class="uk-card-title uk-margin-remove-bottom">Pronto para começar?</h3>
            <p class="uk-margin-small-top uk-text-muted">Cadastre-se e receba seu código.</p>
            <a href="#form" class="uk-button uk-button-primary uk-border-pill uk-width-1-1">Quero meu código</a>
            <hr>
            <p class="uk-text-small uk-text-muted uk-margin-remove">
              Já é associado? Entre com seu código.
            </p>
            <a href="/dashboard/associate_login.php" class="uk-button uk-button-default uk-border-pill uk-width-1-1 uk-margin-small-top">Entrar no painel</a>
          </div>

          <div class="uk-card uk-card-default nd-card uk-card-body uk-margin-top">
            <h4 class="uk-margin-remove-top">Para divulgar</h4>
            <p class="uk-text-small uk-text-muted">Depois de aprovado, seu QR vai apontar para o portal e registrar cliques.</p>
            <div class="uk-alert uk-alert-primary" uk-alert>
              <p class="uk-margin-remove">Você pode imprimir o QR e colocar no carro, balcão ou cartão.</p>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>
