<!-- HEADER -->
<?php
require './sections/header.php'; ?>

<script>
    'use strict';
    var codeDesconto = null;
    var plantaxes = <?php echo json_encode($data['payment_taxes'] ? $data['payment_taxes'] : null) ?>;
</script>


<style>
  /* Logos dos meios de pagamento */
  .payment-method-logo {
    height: 28px;
    max-height: 28px;
    max-width: 120px;
    width: auto;
    object-fit: contain;
    display: block;
  }

  .plan_box .method.payment-method-logo {
    margin: 0 !important;
  }

  /* Área dos cards de planos e formas de pagamento */
  .plans .plan_box {
    padding: 18px 24px;
  }

  /* Linha interna de cada card (radio + conteúdo) */
  .plans .plan_box .uk-grid-small.uk-flex.uk-flex-middle {
    align-items: center;
  }

  /* Coluna onde fica o radio */
  .plans .plan_box .uk-width-auto {
    display: flex;
    align-items: flex-start;     /* alinha pelo topo da linha de texto */
    justify-content: center;
    margin-right: 12px;
  }

  /* Ajusta a posição vertical do círculo pra "subir" ainda mais */
  .plans .plan_box .pretty.p-default {
    margin: -14px 0 0 0;
  }

  @media (max-width: 639.98px) {
    .plans .plan_box {
      padding: 16px;
    }

    .plans .plan_box .uk-width-auto {
      margin-right: 10px;
    }
  }
</style>

<!-- PAGE CONTENT -->

<div class="uk-container uk-margin-medium-top uk-margin-medium-bottom">
<h4><?php echo echoOutput($translation['tr_206']); ?> <b><?php echo echoOutput($planDetails['plan_title']); ?></b></h4>
</div>

<div class="uk-container uk-margin-top">

<form enctype="multipart/form-data" action="<?php echo htmlspecialchars($urlPath->pay($planDetails['plan_id'])); ?>" method="post">

<div uk-grid>
    <div class="uk-width-1-1 uk-width-expand@s">
        <div class="uk-card uk-padding-remove uk-card-body uk-border-rounded plans">

    <?php if(!empty($errors)): ?>
<div class="uk-width-1-1 uk-text-left">
<div class="uk-margin">
<div class="tas-notify tas-notify-danger uk-text-small uk-border-rounded uk-margin-remove">
<ul class="uk-margin-remove">
<?php foreach($errors as $key => $value):?>
<li><?php echo echoOutput($value); ?></li>
<?php endforeach; ?>
</ul>
</div>
</div>
</div>
<?php endif; ?>
        
<?php if (!empty($successManual)): ?>
<div class="uk-width-1-1 uk-text-left">
  <div class="uk-margin">
    <div class="tas-notify tas-notify-success uk-text-small uk-border-rounded uk-margin-remove">
      <ul class="uk-margin-remove">
        <li>Seu pedido de pagamento por transferência/Pix foi enviado. Vamos conferir o comprovante e liberar seu plano em breve.</li>
      </ul>
    </div>
  </div>
</div>
<?php endif; ?>

<fieldset class="uk-border-rounded">

    <legend><?php echo echoOutput(isset($translation['tr_207']) ? $translation['tr_207'] : 'Escolha a periodicidade do plano'); ?></legend>

    <input type="hidden" name="plan" value="<?php echo echoOutput($planDetails['plan_id']); ?>">

    <?php $i=0; foreach($pricesArray as $item): ?>

      <?php if($item['price'] != 0): ?>

      <label class="plan" for="<?php echo echoOutput($item['frequency']); ?>">
      <div class="plan_box">
      <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>

      <div class="uk-width-auto uk-flex uk-flex-center">

      <div class="pretty p-default p-round p-thick">
      <?php if($i == 0): ?>
      <input type="radio" name="frequency" data-frequency="<?php echo echoOutput($item['frequency']); ?>" data-freq="<?php echo echoOutput($item['label']); ?>" data-price="<?php echo echoOutput($item['price']); ?>" value="<?php echo echoOutput($item['frequency']); ?>" id="<?php echo echoOutput($item['frequency']); ?>" data-id="<?php echo echoOutput($item['frequency']); ?>" <?php echo (getFreqParam() == echoOutput($item['frequency']) || getFreqParam() == NULL ) ? 'checked' : NULL ?> required=""/>
      <?php endif; ?>
      <?php $i++; if($i > 1): ?>
      <input type="radio" name="frequency" data-frequency="<?php echo echoOutput($item['frequency']); ?>" data-freq="<?php echo echoOutput($item['label']); ?>" data-price="<?php echo echoOutput($item['price']); ?>" value="<?php echo echoOutput($item['frequency']); ?>" id="<?php echo echoOutput($item['frequency']); ?>" data-id="<?php echo echoOutput($item['frequency']); ?>" <?php echo (getFreqParam() == echoOutput($item['frequency']) ) ? 'checked' : NULL ?> required="" />
      <?php endif; ?>
        <div class="state p-primary-o">
          <label></label>
        </div>
      </div>

      </div>

      <div class="uk-width-expand">

      <h5 class="uk-margin-remove uk-text-bold"><?php echo echoOutput($item['label']); ?></h5>
      <?php
        $description = trim((string) $item['description']);
        if ($description === '') {
          if ($item['frequency'] === 'monthly') {
            $description = 'Cobrança recorrente mensal.';
          } elseif ($item['frequency'] === 'halfyear') {
            $description = 'Cobrança a cada 6 meses.';
          } elseif ($item['frequency'] === 'annual') {
            $description = 'Cobrança recorrente anual.';
          }
        }
      ?>
      <p class="uk-margin-remove uk-text-muted uk-text-small uk-text-truncate"><?php echo echoOutput($description); ?></p>

      </div>

      <div class="uk-width-1-3 uk-flex uk-flex-right">
<h5 class="uk-margin-remove-top uk-text-bold">
  <span class="uk-text-nowrap">
    <?php echo echoOutput($settings['st_currency']); ?>
    <?php echo echoOutput($item['price']); ?>
  </span>
</h5>

      </div>

      </div>
      </div>
      </label>

    <?php endif; ?>
    <?php endforeach; ?>

</fieldset>

  <fieldset class="uk-border-rounded">
  <legend><?php echo echoOutput(isset($translation['tr_208']) ? $translation['tr_208'] : 'Escolha a forma de pagamento'); ?></legend>

  <?php if($settings['st_stripe_status'] == 1): ?>
  <label for="stripe">
  <div class="plan_box">
  <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
  <div class="uk-width-auto uk-flex uk-flex-center">
  <div class="pretty p-default p-round p-thick">
  <input type="radio" name="payment" value="stripe" id="stripe" checked />
  <div class="state p-primary-o">
  <label></label>
  </div>
  </div>
  </div>

  <div class="uk-width-expand">
  <h5 class="uk-margin-remove uk-text-bold">
    <?php
      $labelStripe = isset($translation['tr_209']) ? trim((string)$translation['tr_209']) : '';
      if ($labelStripe === '') {
        $labelStripe = 'Cartão de crédito (Stripe)';
      }
      echo echoOutput($labelStripe);
    ?>
  </h5>
  </div>

  <div class="uk-width-1-3 uk-flex uk-flex-right">
  <img class="method payment-method-logo uk-visible@s" src="<?php echo $urlPath->assets_img('stripe.png'); ?>"/>
  </div>

  </div>
  </div>
  </label>
  <?php endif; ?>

  <?php if($settings['st_paypal_status'] == 1): ?>
  <label for="paypal">
  <div class="plan_box">
  <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
  <div class="uk-width-auto uk-flex uk-flex-center">
  <div class="pretty p-default p-round p-thick">
  <input type="radio" name="payment" value="paypal" id="paypal" />
  <div class="state p-primary-o">
  <label></label>
  </div>
  </div>
  </div>

  <div class="uk-width-expand">
  <h5 class="uk-margin-remove uk-text-bold">
    <?php
      $labelPaypal = isset($translation['tr_210']) ? trim((string)$translation['tr_210']) : '';
      if ($labelPaypal === '') {
        $labelPaypal = 'PayPal';
      }
      echo echoOutput($labelPaypal);
    ?>
  </h5>
  </div>

  <div class="uk-width-1-3 uk-flex uk-flex-right">
  <img class="method payment-method-logo uk-visible@s" src="<?php echo $urlPath->assets_img('paypal.png'); ?>"/>
  </div>

  </div>
  </div>
  </label>
  <?php endif; ?>

  <?php if($settings['st_razorpay_status'] == 1): ?>
  <label for="razorpay">
  <div class="plan_box">
  <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
  <div class="uk-width-auto uk-flex uk-flex-center">
  <div class="pretty p-default p-round p-thick">
  <input type="radio" name="payment" value="razorpay" id="razorpay" />
  <div class="state p-primary-o">
  <label></label>
  </div>
  </div>
  </div>

  <div class="uk-width-expand">
  <h5 class="uk-margin-remove uk-text-bold"><?php echo echoOutput($translation['tr_211']); ?></h5>
  </div>

  <div class="uk-width-1-3 uk-flex uk-flex-right">
  <img class="method payment-method-logo uk-visible@s" src="<?php echo $urlPath->assets_img('razorpay.png'); ?>"/>
  </div>

  </div>
  </div>
  </label>
  <?php endif; ?>

  <?php if($settings['st_paystack_status'] == 1): ?>
  <label for="paystack">
  <div class="plan_box">
  <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
  <div class="uk-width-auto uk-flex uk-flex-center">
  <div class="pretty p-default p-round p-thick">
  <input type="radio" name="payment" value="paystack" id="paystack" />
  <div class="state p-primary-o">
  <label></label>
  </div>
  </div>
  </div>

  <div class="uk-width-expand">
  <h5 class="uk-margin-remove uk-text-bold"><?php echo echoOutput($translation['tr_212']); ?></h5>
  </div>

  <div class="uk-width-1-3 uk-flex uk-flex-right">
  <img class="method payment-method-logo uk-visible@s" src="<?php echo $urlPath->assets_img('paystack.png'); ?>"/>
  </div>

  </div>
  </div>
  </label>
  <?php endif; ?>
<?php if($settings['st_mercadopago_status'] == 1): ?>
  <label for="mercadopago">
    <div class="plan_box">
      <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>

        <div class="uk-width-auto uk-flex uk-flex-center">
          <div class="pretty p-default p-round p-thick">
            <input type="radio" name="payment" value="mercadopago" id="mercadopago" />
            <div class="state p-primary-o">
              <label></label>
            </div>
          </div>
        </div>

        <div class="uk-width-expand">
          <h5 class="uk-margin-remove uk-text-bold">
            Mercado Pago (Pix, boleto, cartão)
          </h5>
        </div>

        <div class="uk-width-1-3 uk-flex uk-flex-right">
          <img class="method payment-method-logo uk-visible@s"
               src="<?php echo $urlPath->assets_img('mercadopago.png'); ?>"/>
        </div>

      </div>
    </div>
  </label>
<?php
  // Pagamento manual - transferência / Pix
  $manualBank = isset($data['manual_bank']) ? $data['manual_bank'] : null;
  if (!empty($manualBank)):
?>
  <label for="banktransfer">
    <div class="plan_box">
      <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>

        <div class="uk-width-auto uk-flex uk-flex-center">
          <div class="pretty p-default p-round p-thick">
            <input type="radio" name="payment" value="banktransfer" id="banktransfer" />
            <div class="state p-primary-o">
              <label></label>
            </div>
          </div>
        </div>

        <div class="uk-width-expand">
          <h5 class="uk-margin-remove uk-text-bold">
            Transferência Bancária / Pix
          </h5>

          <div class="uk-margin-small-top uk-text-small">
            <div><strong>Banco:</strong> <?php echo echoOutput($manualBank['bank_name']); ?></div>
            <div><strong>Agência:</strong> <?php echo echoOutput($manualBank['agency']); ?></div>
            <div><strong>Conta:</strong> <?php echo echoOutput($manualBank['account']); ?></div>
            <div><strong>Pix:</strong> <?php echo echoOutput($manualBank['pix']); ?></div>
          </div>

          <div class="uk-margin-small-top">
            <label class="uk-form-label uk-text-small">Anexar comprovante (imagem ou PDF)</label>
            <input class="uk-input" type="file" name="payment_proof" accept="image/*,application/pdf" required />
          </div>

          <p class="uk-text-meta uk-margin-small-top">
            Após enviar o pagamento, nossa equipe irá conferir o comprovante e ativar o plano manualmente.
          </p>
        </div>

      </div>
    </div>
  </label>
<?php endif; ?>

<?php endif; ?>

  <?php if($settings['st_mollie_status'] == 1): ?>
  <label for="mollie">
  <div class="plan_box">
  <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
  <div class="uk-width-auto uk-flex uk-flex-center">
  <div class="pretty p-default p-round p-thick">
  <input type="radio" name="payment" value="mollie" id="mollie" />
  <div class="state p-primary-o">
  <label></label>
  </div>
  </div>
  </div>

  <div class="uk-width-expand">
  <h5 class="uk-margin-remove uk-text-bold">
    <?php
      $labelMollie = isset($translation['tr_213']) ? trim((string)$translation['tr_213']) : '';
      if ($labelMollie === '') {
        $labelMollie = 'Outro método de pagamento';
      }
      echo echoOutput($labelMollie);
    ?>
  </h5>
  </div>

  <div class="uk-width-1-3 uk-flex uk-flex-right">
  <img class="method payment-method-logo uk-visible@s" src="<?php echo $urlPath->assets_img('mollie.png'); ?>"/>
  </div>

  </div>
  </div>
  </label>
  <?php endif; ?>

  </fieldset>

      <fieldset class="uk-border-rounded uk-margin-medium-top" id="addonsFieldset">
    <legend>Add-ons (opcionais)</legend>

    <div class="uk-grid-small uk-child-width-1-2@s" uk-grid>

      <label class="uk-width-1-2@s">
        <div class="plan_box">
          <div class="uk-flex uk-flex-middle uk-grid-small" uk-grid>
            <div class="uk-width-auto">
              <input class="uk-checkbox addon-input" type="checkbox" name="addon_home7" id="addon_home7" data-addon="home7" data-price="99"
                <?php echo (!empty($addonsSelected['home7'])) ? 'checked' : ''; ?>>
            </div>
            <div class="uk-width-expand">
              <div class="uk-text-bold">Destaque na Home (7 dias)</div>
              <div class="uk-text-small uk-text-muted">R$ 99 (cobrança única)</div>
            </div>
          </div>
        </div>
      </label>

      <label class="uk-width-1-2@s">
        <div class="plan_box">
          <div class="uk-flex uk-flex-middle uk-grid-small" uk-grid>
            <div class="uk-width-auto">
              <input class="uk-checkbox addon-input" type="checkbox" name="addon_cat7" id="addon_cat7" data-addon="cat7" data-price="79"
                <?php echo (!empty($addonsSelected['cat7'])) ? 'checked' : ''; ?>>
            </div>
            <div class="uk-width-expand">
              <div class="uk-text-bold">Topo da Categoria (7 dias)</div>
              <div class="uk-text-small uk-text-muted">R$ 79 (cobrança única)</div>
            </div>
          </div>
        </div>
      </label>

      <div class="uk-width-1-2@s">
        <div class="plan_box">
          <div class="uk-text-bold uk-margin-small-bottom">Pacote Criativo + Oferta Matadora</div>
          <div class="uk-text-small uk-text-muted uk-margin-small-bottom">Setup (cobrança única)</div>
          <select class="uk-select uk-border-rounded addon-input" name="addon_creative" id="addon_creative" data-addon="creative">
            <?php
              $creativeOptions = $addonsCatalog['creative']['options'] ?? [0,150,200,300];
              $creativeSelected = (int)($addonsSelected['creative'] ?? 0);
              foreach($creativeOptions as $opt){
                $opt = (int)$opt;
                $label = $opt === 0 ? 'Não quero agora' : ('R$ ' . $opt);
                $sel = ($opt === $creativeSelected) ? 'selected' : '';
                echo '<option value="' . $opt . '" ' . $sel . '>' . $label . '</option>';
              }
            ?>
          </select>
        </div>
      </div>

      <div class="uk-width-1-2@s">
        <div class="plan_box">
          <div class="uk-text-bold uk-margin-small-bottom">Exclusividade por segmento/bairro</div>
          <div class="uk-text-small uk-text-muted uk-margin-small-bottom">Mensal (multiplica pela periodicidade escolhida)</div>
          <select class="uk-select uk-border-rounded addon-input" name="addon_exclusive" id="addon_exclusive" data-addon="exclusive">
            <?php
              $exclusiveOptions = $addonsCatalog['exclusive']['options'] ?? [0,300,500,900];
              $exclusiveSelected = (int)($addonsSelected['exclusive'] ?? 0);
              foreach($exclusiveOptions as $opt){
                $opt = (int)$opt;
                $label = $opt === 0 ? 'Não quero agora' : ('R$ ' . $opt . '/mês');
                $sel = ($opt === $exclusiveSelected) ? 'selected' : '';
                echo '<option value="' . $opt . '" ' . $sel . '>' . $label . '</option>';
              }
            ?>
          </select>
          <div id="exclusive_meta_box" class="uk-margin-small-top uk-hidden">
            <div class="uk-grid-small" uk-grid>
              <div class="uk-width-1-2@s">
                <label class="uk-form-label uk-text-small">Segmento</label>
                <input class="uk-input uk-border-rounded" type="text" name="exclusive_segment" id="exclusive_segment" placeholder="Ex.: Farmácia, Restaurante, Mercado" value="<?php echo htmlspecialchars((string)($addonsSelected['exclusive_segment'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
              </div>
              <div class="uk-width-1-2@s">
                <label class="uk-form-label uk-text-small">Bairro</label>
                <input class="uk-input uk-border-rounded" type="text" name="exclusive_neighborhood" id="exclusive_neighborhood" placeholder="Ex.: Centro, Trindade, Ingleses" value="<?php echo htmlspecialchars((string)($addonsSelected['exclusive_neighborhood'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
              </div>
            </div>
            <div id="exclusive_availability" class="uk-text-small uk-margin-small-top"></div>
          </div>

        </div>
      </div>

      <label class="uk-width-1-1">
        <div class="plan_box">
          <div class="uk-flex uk-flex-middle uk-grid-small" uk-grid>
            <div class="uk-width-auto">
              <input class="uk-checkbox addon-input" type="checkbox" name="addon_setup" id="addon_setup" data-addon="setup" data-price="149"
                <?php echo (!empty($addonsSelected['setup'])) ? 'checked' : ''; ?>>
            </div>
            <div class="uk-width-expand">
              <div class="uk-text-bold">Setup de implantação</div>
              <div class="uk-text-small uk-text-muted">R$ 149 (grátis nos planos de 6 ou 12 meses)</div>
            </div>
          </div>
        </div>
      </label>

    </div>

    <div id="addons_payment_note" class="uk-alert-warning uk-border-rounded uk-padding-small uk-margin-small-top uk-hidden" uk-alert>
      <p class="uk-margin-remove">
        Para incluir os add-ons no mesmo pagamento, selecione <b>Mercado Pago</b> ou <b>Pix/Transferência</b>.
        Nos demais meios, os add-ons ficam registrados e a cobrança/ativação é feita separadamente.
      </p>
    </div>

  </fieldset>


<?php if(empty($userDetails['user_billing']) || $userDetails['user_billing'] == "[]"): ?>

  <fieldset class="uk-border-rounded">
  <legend><?php echo echoOutput($translation['tr_325']); ?></legend>

    <div class="uk-grid-small billing" uk-grid>
    <div class="uk-width-1-1">
        <label class="uk-form-label"><?php echo echoOutput($translation['tr_356']); ?> <small class="uk-text-danger">*</small></label>
        <input class="uk-input uk-form-large uk-border-rounded" type="text" name="billing_name">
    </div>
    <div class="uk-width-1-1">
        <label class="uk-form-label"><?php echo echoOutput($translation['tr_357']); ?> <small class="uk-text-danger">*</small></label>
        <input class="uk-input uk-form-large uk-border-rounded" type="text" name="billing_address" required="">
    </div>
    <div class="uk-width-1-2@s">
        <label class="uk-form-label"><?php echo echoOutput($translation['tr_358']); ?> <small class="uk-text-danger">*</small></label>
        <select class="nice-select wide uk-select uk-form-large" name="billing_country" required="">
        <?php foreach($countriesArray as $item => $value): ?>
        <option value="<?php echo $item; ?>"><?php echo $value; ?></option>
        <?php endforeach; ?>
        </select>
        </select>
    </div>
    <div class="uk-width-1-4@s">
        <label class="uk-form-label"><?php echo echoOutput($translation['tr_359']); ?> <small class="uk-text-danger">*</small></label>
        <input class="uk-input uk-form-large uk-border-rounded" type="text" name="billing_city" required="">
    </div>
    <div class="uk-width-1-4@s">
        <label class="uk-form-label"><?php echo echoOutput($translation['tr_360']); ?> <small class="uk-text-danger">*</small></label>
        <input class="uk-input uk-form-large uk-border-rounded" type="text" name="billing_zip" required="">
    </div>
    <div class="uk-width-1-1">
        <label class="uk-form-label"><?php echo echoOutput($translation['tr_361']); ?></label>
        <input class="uk-input uk-form-large uk-border-rounded" type="tel" name="billing_phone">
    </div>
    <div class="uk-width-1-1">
        <label class="uk-form-label"><?php echo echoOutput($translation['tr_362']); ?></label>
        <input class="uk-input uk-form-large uk-border-rounded" type="text" name="billing_company">
        <p class="uk-text-muted uk-text-small"><?php echo echoOutput($translation['tr_363']); ?></p>
    </div>
    <div class="uk-width-1-1">
        <label class="uk-form-label"><?php echo echoOutput($translation['tr_364']); ?></label>
        <input class="uk-input uk-form-large uk-border-rounded" type="text" name="billing_tax_id">
    </div>
    </div>

    <br>

  </fieldset>

    <?php endif; ?>


        </div>

    </div>


    <div class="uk-width-1-1 uk-width-1-3@s">
        <div class="uk-card uk-border-rounded">

        <div class="uk-card uk-card-default uk-card-body uk-border-rounded">

        <h5 class="uk-text-bold">
  <?php
    $summaryTitle = isset($translation['tr_216']) ? trim((string)$translation['tr_216']) : '';
    if ($summaryTitle === '') {
      $summaryTitle = 'Resumo do pedido';
    }
    echo echoOutput($summaryTitle);
  ?>
</h5>

<hr>

        <div class="uk-grid-small" uk-grid>
          <div class="uk-width-expand"><?php echo echoOutput($translation['tr_217']); ?></div>
          <div class="uk-width-auto"><?php echo echoOutput($planDetails['plan_title']); ?></div>
        </div>

        <div class="uk-grid-small" uk-grid>
          <div class="uk-width-expand"><?php echo echoOutput(isset($translation['tr_218']) ? $translation['tr_218'] : 'Periodicidade'); ?></div>
          <div class="uk-width-auto"><span id="summary_plan_frequency"></span></div>
        </div>

        <div class="uk-grid-small" uk-grid>
          <div class="uk-width-expand"><?php echo echoOutput(isset($translation['tr_219']) ? $translation['tr_219'] : 'Valor do plano'); ?></div>
          <div class="uk-width-auto"><span class="uk-text-nowrap"><?php echo echoOutput($settings['st_currency']); ?> <span id="summary_plan_price"></span></span></div>
        </div>

        <div id="summary_addons_row" class="uk-grid-small uk-hidden" uk-grid>
          <div class="uk-width-expand">Add-ons</div>
          <div class="uk-width-auto"><span class="uk-text-nowrap"><?php echo echoOutput($settings['st_currency']); ?> <span id="summary_addons_total"></span></span></div>
        </div>

        <div id="summary_addons_list" class="uk-margin-small-top uk-text-small uk-text-muted uk-hidden"></div>


        <div id="summary_discount" class="uk-grid-small uk-hidden" uk-grid>
          <div class="uk-width-expand"><?php echo echoOutput(isset($translation['tr_322']) ? $translation['tr_322'] : 'Desconto aplicado'); ?></div>
          <div class="uk-width-auto uk-text-success"> <span id="discount_price"></span> <?php echo echoOutput($settings['st_currency']); ?> (<span id="discount_percentage"></span>%)</div>
        </div>

        <?php if(!empty($data['payment_taxes'])): ?>
          <hr>
        <?php foreach($data['payment_taxes'] as $item): ?>
        <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
          <div class="uk-width-expand">
            <?php echo echoOutput($item['tax_title']); ?>
            <br><span class="uk-text-small uk-text-capitalize"><?php echo echoOutput($item['tax_type'] == 'exclusive' ? $translation['tr_323'] : $translation['tr_324']); ?></span>
          </div>
          <div class="uk-width-auto">
            <span id="summary_tax_id_<?php echo $item['tax_id']; ?>">
            <span class="tax-value"></span>
            </span>
            <?php echo echoOutput($settings['st_currency']); ?> (<?php echo echoOutput($item['tax_percentage']); ?>%)</div>
        </div>
        <?php endforeach; ?>
        <?php endif; ?>

      <hr>

        <div class="uk-grid-small coupon" uk-grid>
          <div class="uk-width-expand">
            <input id="planid" value="<?php echo echoOutput($planDetails['plan_id']); ?>" type="hidden">
            <input
              class="uk-input uk-border-rounded"
              id="couponcode"
              name="coupon"
              type="text"
              placeholder="<?php echo echoOutput(isset($translation['tr_321']) ? $translation['tr_321'] : 'Digite seu cupom de desconto'); ?>">
          </div>
          <div class="uk-width-auto">
            <button
              class="applyCode uk-button uk-button-default uk-border-rounded"
              type="button">
              <?php echo echoOutput(isset($translation['tr_320']) ? $translation['tr_320'] : 'Aplicar cupom'); ?>
            </button>
          </div>
        </div>

        <div id="coderesults"></div>

      <hr>

        <div class="uk-grid-small uk-text-bold" uk-grid>
          <div class="uk-width-expand"><?php echo echoOutput($translation['tr_222']); ?></div>
          <div class="uk-width-auto"><span class="uk-text-nowrap"><?php echo echoOutput($settings['st_currency']); ?> <span id="summary_total"></span></span></div>
        </div>

      <hr>

        <button id="btnPayNow" class="uk-button uk-button-primary uk-button-large uk-width-1-1 uk-border-rounded" type="submit" name="submit"><?php echo echoOutput($translation['tr_223']); ?> <span class="uk-text-nowrap"><?php echo echoOutput($settings['st_currency']); ?> <span id="pay_total"></span></span></a>

</div>

        <div class="uk-padding-small uk-margin-top">
          <h4><?php echo echoOutput($translation['tr_228']); ?></h4>

        <ul class="features uk-list uk-list-divider uk-margin-remove-bottom">
      <?php $planfeatures = json_decode($planDetails['plan_features'], true); ?>
      <?php if(!empty($planfeatures)): ?>
      <?php foreach ($planfeatures as $key => $value): ?>
        <?php if($value['status'] == 1): ?>
          <li><i class="ti ti-check uk-text-success success"></i> <?php echo echoOutput($value['title']); ?></li>
        <?php if(!empty($value['summary'])): ?>
          <div uk-drop="delay-hide: 100; duration: 100">
              <div class="tas_drop"><?php echo echoOutput($value['summary']); ?></div>
          </div>
        <?php endif; ?>
        <?php endif; ?>
        <?php if($value['status'] == 0): ?>
        <li><i class="ti ti-x uk-text-danger danger"></i> <?php echo echoOutput($value['title']); ?></li>
        <?php if(!empty($value['summary'])): ?>
        <div uk-drop="delay-hide: 100; duration: 100">
              <div class="tas_drop"><?php echo echoOutput($value['summary']); ?></div>
          </div>
        <?php endif; ?>
        <?php endif; ?>
        <?php endforeach ?>
        <?php endif; ?>
      </ul>

      </div>

        </div>

    </div>
</div>

</form>

</div>

<!-- END PAGE CONTENT -->

<!-- FOOTER -->


<script>
(function(){
  function $(id){ return document.getElementById(id); }
  var sel = $('addon_exclusive');
  var box = $('exclusive_meta_box');
  var seg = $('exclusive_segment');
  var nei = $('exclusive_neighborhood');
  var msg = $('exclusive_availability');
  var btn = $('btnPayNow');
  if(!sel || !box || !seg || !nei || !msg || !btn) return;

  var lastReq = 0;
  function setState(ok, text){
    msg.className = 'uk-text-small uk-margin-small-top ' + (ok ? 'uk-text-success' : 'uk-text-danger');
    msg.textContent = text || '';
    btn.disabled = !ok;
    btn.classList.toggle('uk-button-disabled', !ok);
  }

  function updateVisibility(){
    var v = parseInt(sel.value || '0', 10);
    if(v > 0){
      box.classList.remove('uk-hidden');
      // exige preencher
      if(seg.value.trim()==='' || nei.value.trim()===''){
        setState(false, 'Para contratar exclusividade, informe Segmento e Bairro.');
      } else {
        checkAvailability();
      }
    } else {
      box.classList.add('uk-hidden');
      msg.textContent = '';
      btn.disabled = false;
      btn.classList.remove('uk-button-disabled');
    }
  }

  function checkAvailability(){
    var v = parseInt(sel.value || '0', 10);
    if(v <= 0) return;
    var s = seg.value.trim();
    var n = nei.value.trim();
    if(s==='' || n===''){
      setState(false, 'Para contratar exclusividade, informe Segmento e Bairro.');
      return;
    }
    var reqId = ++lastReq;
    setState(false, 'Verificando disponibilidade...');
    var url = '<?php echo $urlPath->root(); ?>/api/check-exclusive.php?segment=' + encodeURIComponent(s) + '&neighborhood=' + encodeURIComponent(n);
    fetch(url, {credentials:'same-origin'})
      .then(r => r.json())
      .then(data => {
        if(reqId !== lastReq) return;
        if(data && data.available){
          setState(true, 'Disponível ✅ Você pode contratar exclusividade para este Segmento + Bairro.');
        } else {
          setState(false, (data && data.message) ? data.message : 'Indisponível para este Segmento + Bairro.');
        }
      })
      .catch(function(){
        if(reqId !== lastReq) return;
        // fail-open: não trava compra se API falhar
        btn.disabled = false;
        btn.classList.remove('uk-button-disabled');
        msg.className = 'uk-text-small uk-margin-small-top uk-text-muted';
        msg.textContent = 'Não foi possível validar agora. Você pode continuar, mas a ativação será confirmada pelo suporte.';
      });
  }

  var t=null;
  function debounceCheck(){
    clearTimeout(t);
    t=setTimeout(checkAvailability, 400);
  }

  sel.addEventListener('change', updateVisibility);
  seg.addEventListener('input', debounceCheck);
  nei.addEventListener('input', debounceCheck);
  updateVisibility();
})();
</script>

<?php require './sections/footer.php'; ?>
