<?php
/**
 * Página de Perfil (pt-BR)
 * - Card à esquerda + detalhes à direita
 * - Fallbacks seguros p/ variáveis ausentes
 * - Remove o userbox do topo (#ndUserMount / .nd-userbox) apenas nesta página
 * - Inclui as seções do tema: sections/header.php e sections/footer.php
 */

$ud = (isset($userDetails) && is_array($userDetails)) ? $userDetails : [];
$ui = (isset($userInfo)    && is_array($userInfo))    ? $userInfo    : [];

// Dados do card
$avatar      = $ud['user_avatar']    ?? ($ui['user_avatar'] ?? 'default.jpg');
$displayName = $ud['user_name']      ?? ($ui['user_name']   ?? '');
$handle      = $ud['user_username']  ?? ($ui['user_username'] ?? 'user');

// Dados do bloco Perfil
$name        = $ui['user_name']        ?? $displayName;
$emailMasked = isset($ui['user_email']) ? maskEmail($ui['user_email']) : '';
$about       = $ui['user_description'] ?? '';
$createdAt   = $ui['user_created']     ?? '';

// Converter mês para pt-BR sem depender de locale
function nd_mes_ptbr(string $mesIngles): string {
  static $map = [
    'January'=>'Janeiro','February'=>'Fevereiro','March'=>'Março','April'=>'Abril',
    'May'=>'Maio','June'=>'Junho','July'=>'Julho','August'=>'Agosto',
    'September'=>'Setembro','October'=>'Outubro','November'=>'Novembro','December'=>'Dezembro',
  ];
  return $map[$mesIngles] ?? $mesIngles;
}
$memberSince = '';
if (!empty($createdAt) && ($ts = strtotime($createdAt))) {
  $mesIng = date('F', $ts);
  $ano    = date('Y', $ts);
  $memberSince = nd_mes_ptbr($mesIng) . ' ' . $ano; // Ex.: Abril 2021
}

// URLs (router espera string)
$profileBase  = $urlPath->profile();
$editUrl      = $profileBase . '?action=edit';
$favoritesUrl = $profileBase . '?action=favorites';

// URL absoluta para a Zona do Anunciante (/dashboard/)
$__DASH_URL = (defined('SITE_URL') ? rtrim(SITE_URL, '/') : '') . '/dashboard/';

// URL de sair (signout) robusta
$__SIGNOUT = (isset($urlPath) && method_exists($urlPath, 'signout'))
  ? $urlPath->signout()
  : ((defined('SITE_URL') ? rtrim(SITE_URL, '/') : '') . '/signout');
?>

<!-- Remover o userbox do topo SOMENTE nesta página -->
<style>
  #ndUserMount,
  .nd-userbox,
  .nd-userbox-inline {
    display: none !important;
    visibility: hidden !important;
    opacity: 0 !important;
    pointer-events: none !important;
  }
  .nd-card-links a { color: #333 !important; }
  .nd-card-links a:hover { color: #111 !important; text-decoration: none; }
  .nd-logout-btn { color: #fff !important; }
</style>
<script>
(function () {
  function nukeUserBox() {
    try {
      var el = document.getElementById('ndUserMount');
      if (el && el.parentNode) el.parentNode.removeChild(el);
      document.querySelectorAll('.nd-userbox, .nd-userbox-inline').forEach(function(n){
        if (n && n.parentNode) n.parentNode.removeChild(n);
      });
    } catch(e) {}
  }
  nukeUserBox();
  window.addEventListener('load', nukeUserBox);
  document.addEventListener('DOMContentLoaded', nukeUserBox);
  var mo = new MutationObserver(function(){ nukeUserBox(); });
  mo.observe(document.documentElement, { childList: true, subtree: true });
})();
</script>

<?php require './sections/header.php'; ?>

<div class="page-title uk-section uk-section-small uk-section-default uk-margin-remove">
  <div class="uk-container">
    <h3 class="uk-heading-line uk-text-left"><span>Perfil</span></h3>
  </div>
</div>

<div class="uk-section uk-section-default uk-padding-remove-top">
  <div class="uk-container">
    <div class="uk-grid-large" uk-grid>

      <div class="uk-width-1-1 uk-width-1-4@m">
        <div class="uk-card uk-card-default uk-card-body uk-border-rounded">

          <div class="uk-text-center">
            <div class="uk-inline uk-margin-small-bottom">
              <div class="uk-cover-container uk-border-pill uk-box-shadow-small">
                <img src="<?php echo $urlPath->image($avatar); ?>" alt="<?php echo echoOutput($displayName); ?>" uk-cover>
                <canvas width="130" height="130"></canvas>
              </div>
            </div>

            <p class="uk-text-bold uk-margin-remove"><?php echo echoOutput($displayName); ?></p>
            <p class="uk-text-muted uk-text-small uk-margin-remove">@<?php echo echoOutput($handle); ?></p>
          </div>

          <hr class="uk-margin-small">

          <ul class="uk-list uk-list-divider uk-margin-small nd-card-links">
            <?php if (function_exists('isAdmin') && isAdmin()): ?>
              <li>
                <a class="uk-flex uk-flex-middle" href="<?php echo $urlPath->admin(); ?>">
                  <span uk-icon="icon: settings; ratio: 0.9"></span>
                  <span class="uk-margin-small-left">Área Administrativa</span>
                </a>
              </li>
            <?php endif; ?>

            <!-- Zona do Anunciante: agora SEMPRE visível -->
            <li>
              <a class="uk-flex uk-flex-middle" href="<?php echo htmlspecialchars($__DASH_URL, ENT_QUOTES, 'UTF-8'); ?>">
                <span uk-icon="icon: cart; ratio: 0.9"></span>
                <span class="uk-margin-small-left">Zona do Anunciante</span>
              </a>
            </li>

            <li>
              <a class="uk-flex uk-flex-middle" href="<?php echo $editUrl; ?>">
                <span uk-icon="icon: pencil; ratio: 0.9"></span>
                <span class="uk-margin-small-left">Editar Perfil</span>
              </a>
            </li>

            <li>
              <a class="uk-flex uk-flex-middle" href="<?php echo $favoritesUrl; ?>">
                <span uk-icon="icon: heart; ratio: 0.9"></span>
                <span class="uk-margin-small-left">Meus Favoritos</span>
              </a>
            </li>
          </ul>

          <a class="uk-button uk-button-secondary uk-border-rounded uk-width-1-1 nd-logout-btn"
             href="<?php echo htmlspecialchars($__SIGNOUT, ENT_QUOTES, 'UTF-8'); ?>">
            Sair
          </a>
        </div>
      </div>

      <div class="uk-width-1-1 uk-width-expand@m">

        <?php if (!isset($_GET['action'])): ?>
          <div class="uk-card uk-card-default uk-card-body uk-border-rounded">

            <h4 class="uk-margin-remove">Perfil</h4>

            <div class="uk-grid-medium uk-child-width-1-1 uk-child-width-1-2@m uk-margin-top" uk-grid>
              <div>
                <h5 class="uk-text-meta uk-margin-small">NOME</h5>
                <p class="uk-margin-remove"><?php echo echoOutput($name); ?></p>
              </div>

              <div>
                <h5 class="uk-text-meta uk-margin-small">EMAIL</h5>
                <p class="uk-margin-remove"><?php echo echoOutput($emailMasked); ?></p>
              </div>

              <div class="uk-width-1-1">
                <h5 class="uk-text-meta uk-margin-small">SOBRE MIM</h5>
                <p class="uk-margin-remove"><?php echo nl2br(echoOutput($about)); ?></p>
              </div>

              <div>
                <h5 class="uk-text-meta uk-margin-small">MEMBRO DESDE</h5>
                <p class="uk-margin-remove"><?php echo echoOutput($memberSince); ?></p>
              </div>
            </div>

          </div>

        <?php elseif (isset($_GET['action']) && $_GET['action'] === 'favorites'): ?>
          <?php require './views/favorites-profile.view.php'; ?>

        <?php else: ?>
          <?php require './views/edit-profile.view.php'; ?>
        <?php endif; ?>

      </div>

    </div>
  </div>
</div>

<?php require './sections/footer.php'; ?>
