<?php
$translation = isset($translation) && is_array($translation) ? $translation : [];
$translation += [
    'tr_144'        => $translation['tr_144']        ?? 'Entrar',
    'tr_145'        => $translation['tr_145']        ?? 'E-mail',
    'tr_146'        => $translation['tr_146']        ?? 'Senha',
    'tr_147'        => $translation['tr_147']        ?? 'Esqueci minha senha',
    'tr_148'        => $translation['tr_148']        ?? 'Lembrar-me',
    'tr_149'        => $translation['tr_149']        ?? 'Criar conta',
    'tr_signin_btn' => $translation['tr_signin_btn'] ?? 'Entrar',
    'tr_47'         => $translation['tr_47']         ?? 'Voltar ao site',
];
$errors = isset($errors) && is_array($errors) ? $errors : [];
?>
<div class="uk-section-large">
  <div class="uk-container uk-container-large">
    <div uk-grid class="uk-child-width-1-1@s uk-child-width-2-3@l">
      <div class="uk-width-1-1@s uk-width-1-5@l uk-width-1-3@xl"></div>
      <div class="uk-width-1-1@s uk-width-3-5@l uk-width-1-3@xl">
        <div class="uk-card uk-card-default uk-border-rounded uk-card-bordered">
          <div class="uk-card-header">
            <?php echo echoOutput($translation['tr_144']); ?>
          </div>
          <div class="uk-card-body">
            <div class="uk-text-center uk-margin-small-bottom">
              <a href="<?php echo $urlPath->home(); ?>">
                <img class="uk-logo-small" src="<?php echo $urlPath->image($theme['th_logo']); ?>" alt="ND Conecta">
              </a>
            </div>

            <form action="<?php echo htmlspecialchars($urlPath->signin()); ?>" method="post" class="uk-form-stacked" autocomplete="on">
              <fieldset class="uk-fieldset">

                <div class="uk-margin">
                  <div class="uk-position-relative">
                    <span class="uk-form-icon" uk-icon="user"></span>
                    <input class="uk-input uk-border-rounded" type="email" name="user_email"
                           placeholder="<?php echo echoOutput($translation['tr_145']); ?>" required>
                  </div>
                </div>

                <div class="uk-margin">
                  <div class="uk-position-relative">
                    <span class="uk-form-icon" uk-icon="lock"></span>
                    <input class="uk-input uk-border-rounded" type="password" name="user_password"
                           placeholder="<?php echo echoOutput($translation['tr_146']); ?>" required>
                  </div>
                </div>

                <?php if (isset($defaultTermsPage['page_slug'], $defaultPrivacyPage['page_slug'])): ?>
                <div class="uk-margin uk-flex uk-flex-left uk-flex-middle">
                  <label class="uk-flex uk-flex-middle" style="gap:6px;">
                    <input class="uk-checkbox" type="checkbox" name="accept_terms" value="1" required>
                    <span class="uk-text-small">
                      Ao entrar você concorda com os
                      <a href="<?php echo $urlPath->page($defaultTermsPage['page_slug']); ?>" target="_blank">
                        Termos de uso
                      </a>
                      e com a
                      <a href="<?php echo $urlPath->page($defaultPrivacyPage['page_slug']); ?>" target="_blank">
                        Política de Privacidade
                      </a>.
                    </span>
                  </label>
                </div>
<?php endif; ?>

                <?php if (!empty($errors)): ?>
                  <div class="uk-margin">
                    <div class="uk-alert-danger uk-border-rounded uk-padding-small" uk-alert>
                      <ul class="uk-margin-remove">
                        <?php foreach ($errors as $value): ?>
                          <li><?php echo echoOutput($value); ?></li>
                        <?php endforeach; ?>
                      </ul>
                    </div>
                  </div>
                <?php endif; ?>

                <div class="uk-margin">
                  <button class="uk-button uk-button-primary uk-border-rounded uk-width-1-1" type="submit">
                    <span uk-icon="sign-in"></span>&nbsp; <?php echo echoOutput($translation['tr_signin_btn']); ?>
                  </button>
                </div>

                <hr class="uk-margin-small">

                <div class="uk-margin-small uk-text-center">
                  <a href="<?php echo $urlPath->forgot(); ?>" class="uk-button uk-button-default uk-border-rounded uk-margin-small-bottom">
                    <?php echo echoOutput($translation['tr_147']); ?>
                  </a>
                  <br />
                  <a href="<?php echo $urlPath->signup(); ?>" class="uk-button uk-button-default uk-border-rounded nd-create-account-btn">
                    <?php echo echoOutput($translation['tr_149']); ?>
                  </a>
                </div>

              </fieldset>
            </form>



          </div>
        </div>
      </div>
      <div class="uk-width-1-1@s uk-width-1-5@l uk-width-1-3@xl"></div>
    </div>
  </div>

  <div class="uk-container uk-margin-medium-top">
    <div uk-grid>
      <div class="uk-width-1-1 uk-text-center">
        <a href="<?php echo $urlPath->home(); ?>" class="uk-button uk-button-default uk-border-rounded">
          <?php echo echoOutput($translation['tr_47']); ?>
        </a>
      </div>
    </div>
  </div>
</div>