<?php
$translation = isset($translation) && is_array($translation) ? $translation : [];
$translation += [
    'tr_signuppage' => $translation['tr_signuppage'] ?? 'Criar conta',
    'tr_fullname'   => $translation['tr_fullname']   ?? 'Nome completo',
    'tr_145'        => $translation['tr_145']        ?? 'E-mail',
    'tr_146'        => $translation['tr_146']        ?? 'Senha',
    'tr_pass2'      => $translation['tr_pass2']      ?? 'Confirmar senha',
    'tr_149'        => $translation['tr_149']        ?? 'Criar conta de anunciante',
    'tr_signup_btn'  => $translation['tr_signup_btn']  ?? 'Cadastrar',
    'tr_signinlink' => $translation['tr_signinlink'] ?? 'Já tem uma conta?',
    'tr_47'         => $translation['tr_47']         ?? 'Voltar ao site',
];
$errors  = isset($errors) && is_array($errors) ? $errors : [];
$success = isset($success) ? (string)$success : '';
?>
<div class="uk-section-large">
  <div class="uk-container uk-container-large">
    <div uk-grid class="uk-child-width-1-1@s uk-child-width-2-3@l">
      <div class="uk-width-1-1@s uk-width-1-5@l uk-width-1-3@xl"></div>
      <div class="uk-width-1-1@s uk-width-3-5@l uk-width-1-3@xl">
        <div class="uk-card uk-card-default uk-border-rounded uk-card-bordered">
          <div class="uk-card-header">
            <?php echo echoOutput($translation['tr_signuppage']); ?>
          </div>
          <div class="uk-card-body">
            <div class="uk-text-center uk-margin-small-bottom">
              <a href="<?php echo $urlPath->home(); ?>">
                <img class="uk-logo-small" src="<?php echo $urlPath->image($theme['th_logo']); ?>" alt="ND Conecta">
              </a>
            </div>

            <?php if ($success !== ''): ?>
              <div class="uk-margin">
                <div class="uk-alert-success uk-border-rounded uk-padding-small" uk-alert>
                  <p class="uk-margin-remove"><?php echo echoOutput($success); ?></p>
                </div>
              </div>
            <?php endif; ?>

            <?php if (!empty($errors)): ?>
              <div class="uk-margin">
                <div class="uk-alert-danger uk-border-rounded uk-padding-small" uk-alert>
                  <ul class="uk-margin-remove">
                    <?php foreach ($errors as $value): ?>
                      <li><?php echo echoOutput($value); ?></li>
                    <?php endforeach; ?>
                  </ul>
                </div>
              </div>
            <?php endif; ?>

            <?php if (empty($success)): ?>
              <?php if (($settings['st_disable_registration'] ?? 0) == 0): ?>
                <form action="<?php echo htmlspecialchars($urlPath->signup()); ?>" method="post" class="uk-form-stacked" autocomplete="on">
                  <fieldset class="uk-fieldset">

                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_fullname']); ?></label>
                      <div class="uk-form-controls">
                        <input class="uk-input uk-border-rounded" type="text" name="user_name"
                               value="<?php echo isset($_POST['user_name']) ? echoOutput($_POST['user_name']) : ''; ?>"
                               placeholder="<?php echo echoOutput($translation['tr_fullname']); ?>" required>
                      </div>
                    </div>

                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_145']); ?></label>
                      <div class="uk-form-controls">
                        <input class="uk-input uk-border-rounded" type="email" name="user_email"
                               value="<?php echo isset($_POST['user_email']) ? echoOutput($_POST['user_email']) : ''; ?>"
                               placeholder="<?php echo echoOutput($translation['tr_145']); ?>" required>
                      </div>
                    </div>

                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_146']); ?></label>
                      <div class="uk-form-controls">
                        <input class="uk-input uk-border-rounded" type="password" name="user_password"
                               placeholder="<?php echo echoOutput($translation['tr_146']); ?>" minlength="8" maxlength="32" required>
                      </div>
                    </div>

                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_pass2']); ?></label>
                      <div class="uk-form-controls">
                        <input class="uk-input uk-border-rounded" type="password" name="user_password_confirm"
                               placeholder="<?php echo echoOutput($translation['tr_pass2']); ?>" minlength="8" maxlength="32" required>
                      </div>
                    </div>

                    <div class="uk-margin">
                      <?php if (($settings['st_recaptcha_enable'] ?? 0) == 1): ?>
                        <button
                          class="g-recaptcha uk-button uk-button-primary uk-border-rounded uk-width-1-1"
                          data-sitekey="<?php echo echoOutput($settings['st_recaptchakey'] ?? ''); ?>"
                          data-callback="onRecaptchaSuccess">
                          <?php echo echoOutput($translation['tr_signup_btn']); ?>
                        </button>
                      <?php else: ?>
                        <button class="uk-button uk-button-primary uk-border-rounded uk-width-1-1" type="submit">
                          <?php echo echoOutput($translation['tr_signup_btn']); ?>
                        </button>
                      <?php endif; ?>
                    </div>

                    <div class="uk-margin-small uk-text-center">
                      <span><?php echo echoOutput($translation['tr_signinlink']); ?></span>
                      <br />
                      <a href="<?php echo $urlPath->signin(); ?>" class="uk-button uk-button-default uk-border-rounded uk-margin-small-top">
                        <?php echo echoOutput($translation['tr_144'] ?? 'Login'); ?>
                      </a>
                    </div>

                  </fieldset>
                </form>
              <?php else: ?>
                <div class="uk-alert-warning uk-border-rounded uk-padding-small" uk-alert>
                  <p class="uk-margin-remove">
                    <?php echo echoOutput($translation['tr_registration_disabled'] ?? 'O registro de novos usuários está temporariamente desativado.'); ?>
                  </p>
                </div>
              <?php endif; ?>
            <?php endif; ?>

          </div>
        </div>
      </div>
      <div class="uk-width-1-1@s uk-width-1-5@l uk-width-1-3@xl"></div>
    </div>
  </div>

  <div class="uk-container uk-margin-medium-top">
    <div uk-grid>
      <div class="uk-width-1-1 uk-text-center">
        <a href="<?php echo $urlPath->home(); ?>" class="uk-button uk-button-default uk-border-rounded">
          <?php echo echoOutput($translation['tr_47']); ?>
        </a>
      </div>
    </div>
  </div>
</div>
