<div class="uk-hidden">
  <div itemtype="https://schema.org/Product" itemscope>
    <meta itemprop="name" content="<?php echo echoOutput($itemDetails['deal_title']); ?>" />
    <link itemprop="image" href="<?php echo $urlPath->image($itemDetails['deal_image']); ?>" />
    <meta itemprop="description" content="<?php echo echoOutput($itemDetails['deal_tagline']); ?>" />

    <div itemprop="offers" itemtype="https://schema.org/Offer" itemscope>
      <link itemprop="url" href="<?php echo $urlPath->deal($itemDetails['deal_id'], $itemDetails['deal_slug']); ?>" />
      <meta itemprop="availability" content="https://schema.org/InStock" />
      <meta itemprop="priceCurrency" content="BRL" />
      <meta itemprop="itemCondition" content="https://schema.org/NewCondition" />
      <meta itemprop="price" content="<?php echo getPriceNoCurrency($itemDetails['deal_price']); ?>" />
      <?php if($itemDetails['deal_expire']): ?>
        <meta itemprop="priceValidUntil" content="<?php echo echoOutput($itemDetails['deal_expire']); ?>" />
      <?php endif; ?>
    </div>

    <div itemprop="aggregateRating" itemtype="https://schema.org/AggregateRating" itemscope>
      <meta itemprop="reviewCount" content="<?php echo echoOutput($itemDetails['total_reviews'] ?? 0); ?>" />
      <meta itemprop="ratingValue" content="<?php echo formatRating($itemDetails['deal_rating'] ?? 0); ?>" />
    </div>

    <?php if(!empty($itemDetails['store_title'] ?? '')): ?>
    <div itemprop="brand" itemtype="https://schema.org/Brand" itemscope>
      <meta itemprop="name" content="<?php echo echoOutput($itemDetails['store_title'] ?? ''); ?>" />
    </div>
    <?php endif; ?>
  </div>
</div>


<?php
// ND Safe defaults to avoid undefined array key warnings
$itemDetails = $itemDetails ?? [];
$itemDetails['total_reviews'] = $itemDetails['total_reviews'] ?? 0;
$itemDetails['deal_rating']   = $itemDetails['deal_rating'] ?? 0;
$itemDetails['store_title']   = $itemDetails['store_title'] ?? '';
$itemDetails['store_slug']    = $itemDetails['store_slug'] ?? '';
$itemDetails['seller_logo']   = $itemDetails['seller_logo'] ?? ($itemDetails['user_avatar'] ?? '');
$itemDetails['user_avatar']   = $itemDetails['user_avatar'] ?? '';
$itemDetails['seller_title']  = $itemDetails['seller_title'] ?? '';
$itemDetails['user_name']     = $itemDetails['user_name'] ?? '';
$itemDetails['seller_user']   = $itemDetails['seller_user'] ?? ($itemDetails['user_id'] ?? 0);

// Tradução opcional usada nessa view
if (!isset($translation) || !is_array($translation)) { $translation = []; }
$translation['tr_351'] = $translation['tr_351'] ?? ($translation['tr_201'] ?? '');

// Fallback seguro para função ausente em algumas versões
if (!function_exists('isActiveSeller')) {
  function isActiveSeller($sellerId): bool {
    return false;
  }
}
?>

<?php require './sections/header.php'; ?>

<?php if(!empty($headerAd)): ?>
  <div class="tas_ads uk-container uk-margin-medium-top uk-margin-small-bottom">
    <div class="uk-width-1-1 uk-text-center">
      <?php foreach($headerAd as $item): ?>
        <?php echo $item['ad_html']; ?>
      <?php endforeach; ?>
    </div>
  </div>
<?php endif; ?>

<div class="uk-container uk-margin-medium-top">
  <div class="tas_single">

    <div class="uk-width-1-1 uk-margin-bottom">

      <?php if(isExclusive(echoOutput($itemDetails['deal_exclusive']))): ?>
        <div class="top_exclusive"><?php echo echoOutput($translation['tr_16']); ?></div>
<!-- DEBUG v5.1: tr_16='<?php echo isset($translation['tr_16']) ? htmlspecialchars($translation['tr_16'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') : 'NULL'; ?>' 
     locale='<?php echo isset($translation['__LOCALE__']) ? htmlspecialchars($translation['__LOCALE__'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') : (isset($_GET['lang']) ? htmlspecialchars($_GET['lang'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') : ('cookie:' . (isset($_COOKIE['googtrans']) ? htmlspecialchars($_COOKIE['googtrans'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') : 'none'))); ?>' 
     file='single-deal.view.php' -->
      <?php endif; ?>

      <ul class="breadcrumb uk-breadcrumb">
        <?php if(!empty($itemDetails['category_title'])): ?>
          <li><a href="<?php echo $urlPath->search(['category' => $itemDetails['category_slug']]); ?>" class="single_link"><?php echo echoOutput($itemDetails['category_title']); ?></a></li>
        <?php endif; ?>
        <?php if(!empty($itemDetails['subcategory_title'])): ?>
          <li><a href="<?php echo $urlPath->search(['subcategory' => $itemDetails['subcategory_slug']]); ?>" class="single_link"><?php echo echoOutput($itemDetails['subcategory_title']); ?></a></li>
        <?php endif; ?>
      </ul>

      <h1 class="single_title"><?php echo echoOutput($itemDetails['deal_title']); ?></h1>
      <h2 class="single_subtitle"><?php echo echoOutput($itemDetails['deal_tagline']); ?></h2>
    </div>

    <div class="uk-grid-medium uk-grid-match" uk-grid>

      <div class="uk-width-1-1 uk-width-expand@m">

        <?php if(isExpired(echoOutput($itemDetails['deal_expire']))): ?>
          <div class="tas_alert_danger uk-alert-danger" uk-alert>
            <p><?php echo echoOutput($translation['tr_37']); ?></p>
          </div>
        <?php endif; ?>

        <div uk-slideshow="animation: slide">
          <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1">
            <div uk-lightbox>
              <ul class="uk-slideshow-items">
                <li>
                  <a href="<?php echo $urlPath->image($itemDetails['deal_image']); ?>">
                    <img src="<?php echo $urlPath->image($itemDetails['deal_image']); ?>" uk-cover>

                    <?php if(!empty($itemDetails['deal_video'])): ?>
                      <div class="uk-position-center">
                        <span class="uk-transition-fade">
                          <a class="play-btn" href="//www.youtube.com/watch?v=<?php echo echoOutput($itemDetails['deal_video']); ?>" data-lity>
                            <i class="ion-play"></i>
                          </a>
                        </span>
                      </div>
                    <?php endif; ?>

                  </a>
                </li>

                <?php foreach($itemsGallery as $item): ?>
                <li>
                  <a href="<?php echo $urlPath->image($item['picture']); ?>">
                    <img src="<?php echo $urlPath->image($item['picture']); ?>" uk-cover>
                  </a>
                </li>
                <?php endforeach; ?>
              </ul>
            </div>

            <a class="uk-position-center-left uk-position-small uk-hidden-hover nextprevbtn" href="#" uk-slidenav-previous uk-slideshow-item="previous"><i class="ti ti-chevron-left"></i></a>
            <a class="uk-position-center-right uk-position-small uk-hidden-hover nextprevbtn" href="#" uk-slidenav-next uk-slideshow-item="next"><i class="ti ti-chevron-right"></i></a>
          </div>

          <div class="uk-margin-small uk-visible@m">
            <ul class="thumbnav uk-thumbnav">
              <li class="uk-active" uk-slideshow-item="0">
                <a href="#">
                  <img src="<?php echo $urlPath->image($itemDetails['deal_image']); ?>" width="100">
                  <?php if(!empty($itemDetails['deal_video'])): ?>
                    <div class="uk-position-center">
                      <span class="play-btn-thumnav">
                        <i class="ion-play"></i>
                      </span>
                    </div>
                  <?php endif; ?>
                </a>
              </li>

              <?php $i = 1; ?>
              <?php foreach($itemsGallery as $item): ?>
                <li uk-slideshow-item="<?php echo $i++; ?>">
                  <a href="#">
                    <img src="<?php echo $urlPath->image($item['picture']); ?>" width="100">
                  </a>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>

        </div>

      </div>

      <div class="uk-width-1-1 uk-width-1-3@m top_side">

        <div>

          <?php if(formatRating($itemDetails['deal_rating']) >= 4.5): ?>
            <div class="toprated">
              <i class="ion-android-star"></i>
              <?php echo echoOutput($translation['tr_88']); ?>
            </div>
          <?php endif; ?>

          <?php if(isNew($itemDetails['deal_start'])): ?>
            <div class="newitem">
              <i class="ion-flash"></i>
              <?php echo echoOutput($translation['tr_20']); ?>
            </div>
          <?php endif; ?>

          <div class="uk-flex uk-flex-middle">
            <?php if(!empty(echoOutput($itemDetails['deal_oldprice']))): ?>
              <h3 class="oldprice"><?php echo getPrice($itemDetails['deal_oldprice']); ?></h3>
            <?php endif; ?>

            <h3 class="price"><?php echo getPrice($itemDetails['deal_price']); ?></h3>

            <?php if(!empty(echoOutput($itemDetails['deal_oldprice']))): ?>
              <h3 class="discount"><?php echo getPercent($itemDetails['deal_price'], $itemDetails['deal_oldprice'], $translation); ?></h3>
            <?php endif; ?>
          </div>

          <?php if(!isExpired(echoOutput($itemDetails['deal_expire']))): ?>
            <?php if(timeLeft(echoOutput($itemDetails['deal_expire']), $translation)): ?>
              <div class="left_time">
                <p><?php echo echoOutput($translation['tr_38']); ?></p>
                <div>
                  <span>
                    <div class="countdown uk-grid-collapse uk-child-width-auto uk-flex uk-flex-center uk-text-center" uk-grid uk-countdown="date: <?php echo getCountDown($itemDetails['deal_expire']); ?>">
                      <div>
                        <div class="uk-countdown-number uk-countdown-days"></div>
                        <div class="uk-countdown-label"><?php echo echoOutput($translation['tr_120']); ?></div>
                      </div>
                      <div class="uk-countdown-separator">:</div>
                      <div>
                        <div class="uk-countdown-number uk-countdown-hours"></div>
                        <div class="uk-countdown-label"><?php echo echoOutput($translation['tr_121']); ?></div>
                      </div>
                      <div class="uk-countdown-separator">:</div>
                      <div>
                        <div class="uk-countdown-number uk-countdown-minutes"></div>
                        <div class="uk-countdown-label"><?php echo echoOutput($translation['tr_122']); ?></div>
                      </div>
                      <div class="uk-countdown-separator">:</div>
                      <div>
                        <div class="uk-countdown-number uk-countdown-seconds"></div>
                        <div class="uk-countdown-label"><?php echo echoOutput($translation['tr_123']); ?></div>
                      </div>
                    </div>
                  </span>
                </div>
              </div>
            <?php endif; ?>
          <?php endif; ?>

          <?php if(!isExpired(echoOutput($itemDetails['deal_expire']))): ?>
            <div class="uk-grid-small uk-margin-small-top" uk-grid>
              <div class="uk-width-expand">
                <a href="<?php echo $urlPath->redirect($itemDetails['deal_id']); ?>" class="uk-button buybtn">
                  <?php echo echoOutput($translation['tr_39']); ?>
                </a>
              </div>
            </div>

            <?php if (!empty($dealCoupons)): ?>
              <div class="uk-margin-small-top">
                <h4 class="uk-text-bold uk-margin-small-bottom">Cupons desta oferta</h4>

                <div class="uk-grid-small uk-child-width-1-1 uk-child-width-1-2@m" uk-grid>
                  <?php foreach ($dealCoupons as $cp): ?>
                    <div>
                      <div class="uk-card uk-card-default uk-card-small uk-card-body uk-border-rounded nd-coupon-card">
                        <div class="uk-text-bold uk-margin-small-bottom">
                          <?php echo htmlspecialchars($cp['coupon_title'] ?? ($cp['coupon_code'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>
                        </div>
                        <div class="uk-text-meta uk-margin-small-bottom">
                          Código:
                          <code class="nd-coupon-code"><?php echo htmlspecialchars($cp['coupon_code'] ?? '', ENT_QUOTES, 'UTF-8'); ?></code>
                          <?php if (!empty($cp['discount_percent'])): ?>
                            • Desconto: <?php echo (int)$cp['discount_percent']; ?>%
                          <?php endif; ?>
                          <?php if (isset($cp['quantity']) && $cp['quantity'] !== '' && $cp['quantity'] !== null): ?>
                            • Quantidade: <?php echo (int)$cp['quantity']; ?>
                          <?php endif; ?>
                        </div>
                        <button type="button"
                                class="uk-button uk-button-primary uk-button-small uk-border-pill nd-copy-coupon"
                                data-code="<?php echo htmlspecialchars($cp['coupon_code'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                                data-deal-id="<?php echo (int)($itemDetails['deal_id'] ?? 0); ?>"
                                data-title="<?php echo htmlspecialchars($cp['coupon_title'] ?? ($cp['coupon_code'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
                          Copiar código
                        </button>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>

                <script>
                  (function(){
                    function bindNdCopyBtns(){
                      var btns = document.querySelectorAll('.nd-copy-coupon');
                      if (!btns || !btns.length) return;
                      btns.forEach(function(btn){
                        if (btn._ndBound) return;
                        btn._ndBound = true;
                        btn.addEventListener('click', function(){
                          var code = btn.getAttribute('data-code') || '';
                          if (!code) return;
                          try {
                            if (window.ndTrack) {
                              var did = btn.getAttribute('data-deal-id') || '';
                              var ttl = btn.getAttribute('data-title') || '';
                              window.ndTrack('copy_coupon', {
                                deal_id: did,
                                coupon_code: code,
                                meta: JSON.stringify({title: ttl})
                              });
                            }
                          } catch(e) {}

                          if (navigator.clipboard && navigator.clipboard.writeText) {
                            navigator.clipboard.writeText(code).then(function(){
                              UIkit.notification({message: 'Código copiado!', status: 'success', timeout: 2000});
                            }).catch(function(){
                              try {
                                var tmp = document.createElement('textarea');
                                tmp.value = code;
                                document.body.appendChild(tmp);
                                tmp.select();
                                document.execCommand('copy');
                                document.body.removeChild(tmp);
                                UIkit.notification({message: 'Código copiado!', status: 'success', timeout: 2000});
                              } catch(e){}
                            });
                          } else {
                            try {
                              var tmp = document.createElement('textarea');
                              tmp.value = code;
                              document.body.appendChild(tmp);
                              tmp.select();
                              document.execCommand('copy');
                              document.body.removeChild(tmp);
                              UIkit.notification({message: 'Código copiado!', status: 'success', timeout: 2000});
                            } catch(e){}
                          }
                        });
                      });
                    }
                    if (document.readyState === 'loading') {
                      document.addEventListener('DOMContentLoaded', bindNdCopyBtns);
                    } else {
                      bindNdCopyBtns();
                    }
                  })();
                </script>

              </div>
            <?php endif; ?>

<?php endif; ?>

          <div class="uk-hidden@m">
            <?php if(echoOutput($itemDetails['deal_expire'])): ?>
              <p class="uk-text-muted uk-margin-small-top uk-margin-remove-bottom">
                <span class="uk-text-bold"><?php echo echoOutput($translation['tr_36']); ?></span>
                <?php echo formatDate($itemDetails['deal_expire']); ?>
              </p>
            <?php endif; ?>
          </div>

          <dl class="uk-description-list uk-description-list-divider uk-visible@m">
            <?php if(echoOutput($itemDetails['deal_expire'])): ?>
              <dt><?php echo echoOutput($translation['tr_36']); ?></dt>
              <dd><?php echo formatDate($itemDetails['deal_expire']); ?></dd>
            <?php endif; ?>

            <?php if(!empty($itemDetails['store_title'])): ?>
              <dt><?php echo echoOutput($translation['tr_85']); ?></dt>
              <dd><?php echo echoOutput($itemDetails['store_title']); ?></dd>
            <?php endif; ?>

            <?php if(!empty($itemDetails['location_title'])): ?>
              <dt><?php echo echoOutput($translation['tr_87']); ?></dt>
              <dd><?php echo echoOutput($itemDetails['location_title']); ?></dd>
            <?php endif; ?>
          </dl>

        </div>
      </div>

    </div>

    <div class="uk-grid-medium uk-margin-small-top" uk-grid>

      <div class="uk-width-1-1 uk-width-expand@m">

        <hr>

        <div class="uk-grid-collapse" uk-grid>
          <div class="uk-width-1-2 uk-flex uk-flex-left uk-flex-middle">
            <div class="rating uk-grid-small uk-flex uk-flex-middle" uk-grid>

              <?php if(formatRating($itemDetails['deal_rating'])): ?>
                <div class="uk-width-auto uk-visible@s">
                  <p class="rate"><?php echo formatRating($itemDetails['deal_rating']); ?></p>
                </div>
              <?php endif; ?>

              <div class="uk-width-expand">
                <a href="#reviews-item" uk-scroll>
                  <p class="stars">
                    <?php echo showStars($itemDetails['deal_rating']); ?>
                  </p>
                  <span class="total"><?php echo echoOutput($itemDetails['total_reviews']); ?> <?php echo echoOutput($translation['tr_49']); ?></span>
                </a>
              </div>

            </div>
          </div>

          <div class="uk-width-1-2 uk-flex uk-flex-right uk-flex-middle">
            <a href="#share-item" class="share uk-text-truncate" uk-scroll>
              <?php echo echoOutput($translation['tr_50']); ?> <i class="ti ti-share"></i>
            </a>
          </div>
        </div>

        <hr>

        <div class="uk-grid-small uk-grid-divider uk-flex uk-flex-middle" uk-grid>
          <?php if(!empty($itemDetails['location_title'])): ?>
            <div>
              <a href="<?php echo $urlPath->search(['location' => $itemDetails['location_slug']]); ?>" class="single_location">
                <i class="ion-android-pin"></i>
                <?php echo echoOutput($itemDetails['location_title']); ?>
              </a>
            </div>
          <?php endif; ?>

          <?php if(!empty($itemDetails['deal_store'])): ?>
            <div>
              <a href="<?php echo $urlPath->search(['store' => $itemDetails['store_slug']]); ?>" class="single_link"><?php echo echoOutput($itemDetails['store_title']); ?></a>
            </div>
          <?php endif; ?>
        </div>

        <?php if(!empty($itemDetails['location_title']) || !empty($itemDetails['store_title'])): ?>
          <hr>
        <?php endif; ?>

        <div class="description">
          <?php echo $itemDetails['deal_description']; ?>

          <?php if($settings['st_enable_report_form'] == 1): ?>
            <a class="uk-button uk-button-default uk-border-rounded uk-flex uk-flex-middle uk-flex-center" href="#report-modal" uk-toggle>
              <i class="ti ti-flag uk-margin-small-right"></i>
              <?php echo echoOutput($translation['tr_351']); ?>
            </a>
          <?php endif; ?>
        </div>

        <hr>

        <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
          <div class="uk-width-expand">
            <div class="uk-grid-small uk-flex-middle" uk-grid>
              <div class="uk-width-auto">
                <img class="uk-border-pill" src="<?php echo $urlPath->image($itemDetails['seller_logo'] ? $itemDetails['seller_logo'] : $itemDetails['user_avatar']); ?>" width="50" height="50" alt="<?php echo echoOutput($itemDetails['seller_title'] ? $itemDetails['seller_title'] : $itemDetails['user_name']); ?>">
              </div>
              <div class="uk-width-expand">
                <p class="uk-margin-remove">
                  <?php if(hasStore($itemDetails['seller_user'])): ?>
                    <a class="uk-link-reset" href="<?php echo $urlPath->user($itemDetails['seller_slug']); ?>"><?php echo echoOutput($itemDetails['seller_title'] ? $itemDetails['seller_title'] : $itemDetails['user_name']); ?></a>
                  <?php else: ?>
                    <?php echo echoOutput($itemDetails['seller_title'] ? $itemDetails['seller_title'] : $itemDetails['user_name']); ?>
                  <?php endif; ?>
                  <?php if(isActiveSeller($itemDetails['seller_user'])): ?>
                    <span class="pro_badge"><?php echo echoOutput($translation['tr_201']); ?></span>
                  <?php endif; ?>
                </p>
              </div>
            </div>
          </div>

          <?php if(hasStore($itemDetails['seller_user'])): ?>
            <div class="uk-width-auto uk-visible@s">
              <a class="uk-button uk-button-default uk-border-pill" href="<?php echo $urlPath->user($itemDetails['seller_slug']); ?>"><?php echo echoOutput($translation['tr_435']); ?></a>
            </div>
          <?php endif; ?>
        </div>

        <hr>

        <?php require './sections/views/share.view.php'; ?>

        <hr>

        <?php require './sections/reviews.php'; ?>

      </div>

      <!-- SIDEBAR -->
      <div class="uk-width-1-1 uk-width-1-3@m">
      <div class="uk-card uk-card-default uk-card-body uk-border-rounded nd-pricebox">
        <div class="uk-margin-small-bottom">
          <span class="uk-label uk-border-pill uk-text-capitalize nd-pricebox__badge">★ Mais bem avaliado</span>
        </div>

        <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
          <div class="uk-h3 uk-margin-remove nd-pricebox__value"><?= isset($itemDetails['deal_price_old']) && $itemDetails['deal_price_old'] ?
              '<span class="nd-price-old">R$ '.echoOutput($itemDetails['deal_price_old']).'</span>' : '' ?>
            R$ <?= echoOutput($itemDetails['deal_price']); ?>
          </div>
        </div>

        <div class="nd-rating-snippet uk-flex uk-flex-middle uk-margin-small-bottom" aria-label="Avaliações">
  <span id="nd-stars" class="uk-margin-small-right">☆☆☆☆☆</span>
  <span id="nd-score" class="uk-text-bold uk-margin-small-right" aria-live="polite">0/5</span>
  <span id="nd-count" class="uk-text-meta">(0 avaliações)</span>
</div>

        <a class="uk-button uk-border-pill uk-width-1-1 nd-pricebox__cta"
           href="<?= $urlPath->home(); ?>"
           target="_blank" rel="noopener">
          <i class="ti ti-shopping-cart"></i> <span class="uk-margin-small-left">Aproveitar oferta</span>
        </a>

        <div class="uk-text-center uk-margin-small-top">

        <?php if (!empty($dealCoupons)): ?>
          <div class="nd-coupons-box uk-margin-top">
            <h4 class="uk-heading-line uk-text-bold"><span>Cupons disponíveis</span></h4>
            <div class="uk-grid-small" uk-grid>
              <?php foreach ($dealCoupons as $cp): ?>
                <div class="uk-width-1-1">
                  <div class="uk-card uk-card-default uk-card-small uk-border-rounded nd-coupon-card">
                    <div class="uk-card-body uk-grid-small uk-flex-middle" uk-grid>
                      <div class="uk-width-expand">
                        <div class="uk-text-bold uk-text-small">
                          <?php echo echoOutput($cp['coupon_title'] ?? $cp['coupon_code']); ?>
                        </div>
                        <div class="uk-text-meta">
                          Código: <span class="nd-coupon-code"><?php echo echoOutput($cp['coupon_code']); ?></span>
                          <?php if (!empty($cp['discount_percent'])): ?>
                            &nbsp;•&nbsp; Desconto: <?php echo (int)$cp['discount_percent']; ?>%
                          <?php endif; ?>
                          <?php if (isset($cp['quantity']) && $cp['quantity'] !== null): ?>
                            &nbsp;•&nbsp; Qtd.: <?php echo (int)$cp['quantity']; ?>
                          <?php else: ?>
                            &nbsp;•&nbsp; Qtd.: Ilimitado
                          <?php endif; ?>
                        </div>
                      </div>
                      <div class="uk-width-auto">
                        <button class="uk-button uk-button-primary uk-border-pill uk-button-small"
                                type="button"
                                onclick="navigator.clipboard && navigator.clipboard.writeText('<?php echo addslashes($cp['coupon_code']); ?>');"
                        >
                          Copiar código
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        <?php endif; ?>

        <div class="uk-text-center uk-margin-small-top">
          <?php if(isLogged() && isset($userInfo['user_id'])): ?>
            <?php if(isset($isFav) && !empty($isFav)): ?>
              <span class="like uk-hidden">
                <a class="addfav uk-icon-button favbtn"
                   data-item="<?php echo echoOutput($itemDetails['deal_id']); ?>"
                   data-user="<?php echo echoOutput($userInfo['user_id']); ?>"
                   uk-icon="heart"
                   title="<?php echo echoOutput($translation['tr_183'] ?? 'Adicionar aos favoritos'); ?>"
                   aria-label="Adicionar aos favoritos"></a>
              </span>
              <span class="unlike">
                <a class="removefav uk-icon-button favbtn infav"
                   data-item="<?php echo echoOutput($itemDetails['deal_id']); ?>"
                   data-user="<?php echo echoOutput($userInfo['user_id']); ?>"
                   uk-icon="heart"
                   title="<?php echo echoOutput($translation['tr_184'] ?? 'Remover dos favoritos'); ?>"
                   aria-label="Remover dos favoritos"></a>
              </span>
            <?php else: ?>
              <span class="like">
                <a class="addfav uk-icon-button favbtn"
                   data-item="<?php echo echoOutput($itemDetails['deal_id']); ?>"
                   data-user="<?php echo echoOutput($userInfo['user_id']); ?>"
                   uk-icon="heart"
                   title="<?php echo echoOutput($translation['tr_183'] ?? 'Adicionar aos favoritos'); ?>"
                   aria-label="Adicionar aos favoritos"></a>
              </span>
              <span class="unlike uk-hidden">
                <a class="removefav uk-icon-button favbtn infav"
                   data-item="<?php echo echoOutput($itemDetails['deal_id']); ?>"
                   data-user="<?php echo echoOutput($userInfo['user_id']); ?>"
                   uk-icon="heart"
                   title="<?php echo echoOutput($translation['tr_184'] ?? 'Remover dos favoritos'); ?>"
                   aria-label="Remover dos favoritos"></a>
              </span>
            <?php endif; ?>
          <?php else: ?>
            <a href="<?php echo $urlPath->signin(); ?>"
               class="uk-icon-button favbtn unfav"
               uk-icon="heart"
               title="<?php echo echoOutput($translation['tr_185'] ?? 'Entre para salvar nos favoritos'); ?>"
               aria-label="Entre para salvar nos favoritos"></a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require './sections/related-deals.php'; ?>

<?php if(!empty($footerAd)): ?>
  <div class="tas_ads uk-container uk-margin-large-top">
    <div class="uk-width-1-1 uk-text-center">
      <?php foreach($footerAd as $item): ?>
        <?php echo $item['ad_html']; ?>
      <?php endforeach; ?>
    </div>
  </div>
<?php endif; ?>

<?php
// IMPORTANTE: não duplique os modais aqui.
// O footer.view.php (corrigido) já carrega:
// - submit-review.view.php
// - reviews-modal.view.php
// - report-modal.view.php (se habilitado)
// Mantemos apenas o exclusive-modal aqui (não está no footer).
?>
<?php require './sections/views/exclusive-modal.view.php'; ?>
<?php require './sections/footer.php'; ?>