<?php
/**
 * Página pública da Loja (micro-landing)
 * Espera:
 *  - $store           array com dados da loja
 *  - $activeDeals     array de ofertas ativas
 *  - $pastDeals       array de ofertas passadas
 *  - $storeWhatsappLink (string opcional)
 *  - $storeLocations  array[id => título] (opcional)
 */

require './sections/header.php';

// Normalizações
$store          = is_array($store) ? $store : [];
$activeDeals    = is_array($activeDeals) ? $activeDeals : [];
$pastDeals      = is_array($pastDeals) ? $pastDeals : [];
$storeTitle     = trim($store['store_title'] ?? '');
$storeDesc      = trim($store['store_description'] ?? '');
$storeLogo      = trim($store['store_image'] ?? ($store['store_logo'] ?? ''));
$storeUrl       = trim($store['store_url'] ?? $store['store_website'] ?? '');
$storeAddress   = trim($store['store_address'] ?? '');
$storeHours     = trim($store['store_hours'] ?? '');

$storeOpenState = null;
if (function_exists('isStoreOpenNow')) {
  $storeOpenState = isStoreOpenNow($storeHours);
}

$storeLocations = isset($storeLocations) && is_array($storeLocations) ? $storeLocations : [];

?>
<div class="uk-section uk-section-default">
  <div class="uk-container">

    <div class="uk-grid-medium" uk-grid>
      <div class="uk-width-1-1 uk-width-auto@m">
        <div class="uk-card uk-card-default uk-card-body uk-border-rounded">
          <div class="uk-flex uk-flex-middle">
            <div class="uk-margin-right">
              <div class="uk-cover-container" style="width:96px;height:96px;">
                <?php if ($storeLogo): ?>
                  <img src="<?php echo $urlPath->image($storeLogo); ?>" alt="<?php echo echoOutput($storeTitle); ?>" uk-cover>
                <?php else: ?>
                  <div class="uk-background-muted uk-border-rounded uk-flex uk-flex-middle uk-flex-center" style="width:96px;height:96px;">
                    <span class="uk-text-large uk-text-bold">
                      <?php echo strtoupper(mb_substr($storeTitle, 0, 1, 'UTF-8')); ?>
                    </span>
                  </div>
                <?php endif; ?>
              </div>
            </div>

            <div>
              <h1 class="uk-margin-remove"><?php echo echoOutput($storeTitle); ?></h1>
              <?php if (!empty($storeLocations)): ?>
                <p class="uk-text-meta uk-margin-small-top">
                  <span uk-icon="location"></span>
                  <?php echo implode(' · ', array_map('echoOutput', $storeLocations)); ?>
                </p>
              <?php endif; ?>
              <?php if ($storeDesc !== ''): ?>
                <p class="uk-margin-small-top uk-text-muted">
                  <?php echo nl2br(echoOutput(mb_strimwidth($storeDesc, 0, 180, '...', 'UTF-8'))); ?>
                </p>
              <?php endif; ?>
              <?php if ($storeAddress !== ''): ?>
                <p class="uk-margin-small-top">
                  <span uk-icon="location"></span>
                  <?php echo echoOutput($storeAddress); ?>
                </p>
              <?php endif; ?>
              <?php if ($storeHours !== ''): ?>
                <p class="uk-margin-small-top uk-text-meta">
                  <span uk-icon="clock"></span>
                  <?php echo echoOutput($storeHours); ?>
                  <?php if ($storeOpenState === true): ?>
                    <span class="uk-label uk-label-success uk-margin-small-left">Aberto agora</span>
                  <?php elseif ($storeOpenState === false): ?>
                    <span class="uk-label uk-label-danger uk-margin-small-left">Fechado</span>
                  <?php endif; ?>
                </p>
              <?php endif; ?>

            </div>
          </div>

          <div class="uk-margin-top uk-grid-small" uk-grid>
            <?php if (!empty($storeWhatsappLink)): ?>
              <div>
                <a class="uk-button uk-button-primary uk-border-pill" href="<?php echo htmlspecialchars($storeWhatsappLink, ENT_QUOTES, 'UTF-8'); ?>" target="_blank" rel="noopener">
                  <span uk-icon="whatsapp"></span>
                  <span class="uk-margin-small-left">Falar no WhatsApp</span>
                </a>
              </div>
            <?php endif; ?>

            <?php if ($storeUrl !== '' && (empty($storeWhatsappLink) || strpos($storeUrl, 'wa.me/') === false)): ?>
              <div>
                <a class="uk-button uk-button-default uk-border-pill" href="<?php echo htmlspecialchars($storeUrl, ENT_QUOTES, 'UTF-8'); ?>" target="_blank" rel="noopener">
                  <span uk-icon="link"></span>
                  <span class="uk-margin-small-left">Visitar site / rede social</span>
                </a>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>

    <div class="uk-margin-large-top">
      <h3 class="uk-heading-line"><span>Ofertas ativas</span></h3>

      <?php if (!empty($activeDeals)): ?>
        <div class="uk-grid-medium uk-child-width-1-1 uk-child-width-1-2@s uk-child-width-1-3@m" uk-grid>
          <?php foreach ($activeDeals as $item): ?>
            <div>
              <a href="<?php echo $urlPath->home() . '?deal_id=' . (int)($item['deal_id'] ?? 0); ?>" class="uk-link-reset">
                <div class="tas_card uk-card uk-card-default uk-border-rounded uk-overflow-hidden">
                  <div class="uk-card-media-top uk-cover-container">
                    <img src="<?php echo $urlPath->image($item['deal_image']); ?>" alt="<?php echo echoOutput($item['deal_title']); ?>" uk-cover>
                    <canvas width="480" height="260"></canvas>
                  </div>
                  <div class="uk-card-body">
                    <h4 class="uk-margin-remove-bottom"><?php echo echoOutput($item['deal_title']); ?></h4>
                    <?php if (!empty($item['location_title'])): ?>
                      <p class="uk-text-meta uk-margin-small-top">
                        <span uk-icon="location"></span>
                        <?php echo echoOutput($item['location_title']); ?>
                      </p>
                    <?php endif; ?>
                    <?php if (!empty($item['deal_price'])): ?>
                      <p class="uk-margin-small-top uk-text-bold">
                        <?php echo getPrice($item['deal_price']); ?>
                      </p>
                    <?php endif; ?>
                  </div>
                </div>
              </a>
            </div>
          <?php endforeach; ?>
        </div>
      <?php else: ?>
        <p class="uk-text-muted">Esta loja ainda não possui ofertas ativas.</p>
      <?php endif; ?>
    </div>

    <div class="uk-margin-large-top">
      <h3 class="uk-heading-line"><span>Informações do local</span></h3>

      <div class="uk-grid-small" uk-grid>
        <div class="uk-width-1-1 uk-width-1-3@m">
          <div class="uk-card uk-card-default uk-card-body uk-border-rounded">
            <?php if ($storeAddress !== ''): ?>
              <p class="uk-margin-remove-bottom">
                <strong>Endereço:</strong><br>
                <?php echo echoOutput($storeAddress); ?>
              </p>
            <?php endif; ?>
            <?php if ($storeHours !== ''): ?>
              <p class="uk-margin-small-top uk-margin-remove-bottom">
                <strong>Horário de atendimento:</strong><br>
                <?php echo echoOutput($storeHours); ?>
              </p>
            <?php endif; ?>
            <?php if ($storeWhatsappLink !== ''): ?>
              <p class="uk-margin-small-top uk-margin-remove-bottom">
                <strong>WhatsApp:</strong><br>
                <a href="<?php echo htmlspecialchars($storeWhatsappLink, ENT_QUOTES, 'UTF-8'); ?>" target="_blank" rel="noopener">
                  <?php echo echoOutput($storeWhatsapp ?? 'Chamar no WhatsApp'); ?>
                </a>
              </p>
            <?php endif; ?>
          </div>
        </div>

        <?php if ($storeAddress !== ''): ?>
        <div class="uk-width-1-1 uk-width-2-3@m">
          <div class="uk-card uk-card-default uk-border-rounded uk-overflow-hidden">
            <div class="uk-card-media-top">
              <iframe
                src="https://www.google.com/maps?q=<?php echo urlencode($storeAddress); ?>&output=embed"
                width="100%"
                height="260"
                style="border:0;"
                allowfullscreen=""
                loading="lazy"
                referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
          </div>
        </div>
        <?php endif; ?>
      </div>
    </div>

    <div class="uk-margin-large-top">
      <h3 class="uk-heading-line"><span>Histórico de ofertas</span></h3>

      <?php if (!empty($pastDeals)): ?>
        <div class="uk-grid-medium uk-child-width-1-1 uk-child-width-1-2@s uk-child-width-1-3@m" uk-grid>
          <?php foreach ($pastDeals as $item): ?>
            <div>
              <div class="tas_card uk-card uk-card-default uk-border-rounded uk-overflow-hidden uk-opacity-medium">
                <div class="uk-card-media-top uk-cover-container">
                  <img src="<?php echo $urlPath->image($item['deal_image']); ?>" alt="<?php echo echoOutput($item['deal_title']); ?>" uk-cover>
                  <canvas width="480" height="260"></canvas>
                </div>
                <div class="uk-card-body">
                  <h4 class="uk-margin-remove-bottom"><?php echo echoOutput($item['deal_title']); ?></h4>
                  <?php if (!empty($item['location_title'])): ?>
                    <p class="uk-text-meta uk-margin-small-top">
                      <span uk-icon="location"></span>
                      <?php echo echoOutput($item['location_title']); ?>
                    </p>
                  <?php endif; ?>
                  <?php if (!empty($item['deal_expire'])): ?>
                    <p class="uk-text-meta uk-margin-small-top">
                      Expirou em: <?php echo echoOutput($item['deal_expire']); ?>
                    </p>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      <?php else: ?>
        <p class="uk-text-muted">Ainda não há ofertas encerradas para esta loja.</p>
      <?php endif; ?>
    </div>

    <div class="uk-margin-large-top">
      <h3 class="uk-heading-line"><span>Avaliações</span></h3>
      <p class="uk-text-muted">Sistema de avaliações em breve. Você já pode usar as ofertas e cupons desta loja normalmente.</p>
    </div>

  </div>
</div>


<?php
// Footer público com links rápidos, boletim e apps
require __DIR__ . '/../sections/footer.php';
?>