<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Client_qr extends ClientsController
{
    public function __construct()
    {
        parent::__construct();
        if (!is_client_logged_in()) {
            redirect(site_url('clients/login'));
        }
        $this->load->model('qrassociados/qrassociados_model');
        $this->load->model('clients_model');
    }

    public function my_qr()
    {
        $contact_id = get_contact_user_id();
        $contact    = $this->clients_model->get_contact($contact_id);
        if (!$contact) {
            show_404();
        }
        $client_id = $contact->userid;

        $module_path = FCPATH . 'modules/qrassociados/';
        $qr_dir      = $module_path . 'uploads/clients/';
        if (!is_dir($qr_dir)) { @mkdir($qr_dir, 0755, true); }
        $file_path = $qr_dir . 'client_' . $client_id . '.png';

        $track_url = site_url('qrassociados/track/go/'.$client_id);
        if (!file_exists($file_path)) {

    $done = false;

    if (class_exists('QRcode') && method_exists('QRcode','png')) {
        try {
            QRcode::png($track_url, $file_path, QR_ECLEVEL_L, 6, 2);
            if (is_file($file_path) && filesize($file_path) > 0) {
                $done = true;
            }
        } catch (Throwable $e) {}
    }

    if (!$done) {
        $qr_api = 'https://quickchart.io/qr?text=' . urlencode($track_url) . '&size=300&margin=2';
        $img = @file_get_contents($qr_api);
        if ($img !== false) { @file_put_contents($file_path, $img); }
    }
}

        $data['title']        = 'Meu QR Code';
        $data['qr_image_url'] = base_url('modules/qrassociados/uploads/clients/client_' . (int)$client_id . '.png');
        $data['qr_link']      = $this->qrassociados_model->get_destination_url($client_id);
        $data['total']        = $this->qrassociados_model->count_hits($client_id);
        $data['latest']       = $this->qrassociados_model->latest_hits($client_id, 10);
        $data['series']       = $this->qrassociados_model->hits_grouped_last_days($client_id, 30);
        $data['top10']        = $this->qrassociados_model->ranking_with_client_names(null, null, 10);
        $data['client_id']    = $client_id;

        $this->data($data);
        $this->view('client/my_qr');
        $this->layout();
    }
}
