<?php defined('BASEPATH') or exit('No direct script access allowed');

class Qrassociados_tools extends AdminController
{
    public function upload()
    {
        if (!is_admin()) { access_denied('modules'); }
        if (empty($_FILES['module_zip']['name'])) {
            set_alert('warning', 'Selecione um arquivo .zip');
            redirect(admin_url('mods'));
        }
        $tmp = $_FILES['module_zip']['tmp_name'];
        $name = $_FILES['module_zip']['name'];
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        if ($ext !== 'zip') {
            set_alert('danger', 'Envie um arquivo .zip');
            redirect(admin_url('mods'));
        }
        $modulesDir = FCPATH . 'modules';
        if (!is_dir($modulesDir)) { @mkdir($modulesDir, 0755, true); }
        $zip = new ZipArchive();
        if ($zip->open($tmp) === true) {
            $zip->extractTo($modulesDir);
            $zip->close();
            set_alert('success', 'Módulo enviado e extraído em /modules.');
        } else {
            set_alert('danger', 'Falha ao abrir o .zip.');
        }
        redirect(admin_url('mods'));
    }

    public function toggle()
    {
        if (!is_admin()) { access_denied('modules'); }
        $module = $this->input->get('module', true);
        $active = (int) $this->input->get('active');
        if (!$module) { redirect(admin_url('mods')); }
        $this->db->where('module_name', $module);
        $exists = $this->db->get(db_prefix().'modules')->row();
        if ($exists) {
            $this->db->where('module_name', $module);
            $this->db->update(db_prefix().'modules', ['active' => $active]);
        } else {
            $this->db->insert(db_prefix().'modules', [
                'module_name' => $module,
                'installed_version' => '1.0.0',
                'active' => $active,
            ]);
        }
        set_alert('success', $active ? 'Módulo ativado.' : 'Módulo desativado.');
        redirect(admin_url('mods'));
    }
}
