<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Track extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('qrassociados/qrassociados_model');
        $this->load->helper('url');
    }

    public function go($client_id = 0)
    {
        $client_id = (int)$client_id;
        if ($client_id <= 0) { show_404(); }
        $ip  = $this->input->ip_address();
        $ua  = isset($_SERVER['HTTP_USER_AGENT']) ? substr($_SERVER['HTTP_USER_AGENT'], 0, 1000) : '';
        $ref = isset($_SERVER['HTTP_REFERER']) ? substr($_SERVER['HTTP_REFERER'], 0, 1000) : '';

        $this->qrassociados_model->log_hit($client_id, $ip, $ua, $ref);
        $dest = $this->qrassociados_model->get_destination_url($client_id);
        if (!$dest) { $dest = site_url(''); }
        redirect($dest);
    }
}
