<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Qrassociados_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function get_destination_url($client_id)
    {
        $row = $this->db->get_where(db_prefix().'qrassociados_settings', ['client_id' => (int)$client_id])->row();
        if ($row && !empty($row->destination_url)) {
            return $row->destination_url;
        }
        return 'https://cupons.ndmidia.com.br/?c=' . (int)$client_id;
    }

    public function set_destination_url($client_id, $url)
    {
        $client_id = (int)$client_id;
        $exists = $this->db->get_where(db_prefix().'qrassociados_settings', ['client_id' => $client_id])->row();
        if ($exists) {
            $this->db->where('client_id', $client_id)->update(db_prefix().'qrassociados_settings', ['destination_url' => $url]);
        } else {
            $this->db->insert(db_prefix().'qrassociados_settings', ['client_id' => $client_id, 'destination_url' => $url]);
        }
        return $this->db->affected_rows() >= 0;
    }

    public function log_hit($client_id, $ip, $ua, $ref)
    {
        $this->db->insert(db_prefix().'qrassociados_hits', [
            'client_id'  => (int)$client_id,
            'ip'         => $ip,
            'user_agent' => $ua,
            'referrer'   => $ref,
        ]);
    }

    public function count_hits($client_id, $from = null, $to = null)
    {
        $this->db->from(db_prefix().'qrassociados_hits');
        $this->db->where('client_id', (int)$client_id);
        if ($from) $this->db->where('created_at >=', $from);
        if ($to)   $this->db->where('created_at <=', $to);
        return (int)$this->db->count_all_results();
    }

    public function latest_hits($client_id, $limit = 10)
    {
        return $this->db->order_by('created_at', 'DESC')
                        ->get_where(db_prefix().'qrassociados_hits', ['client_id' => (int)$client_id], $limit)
                        ->result();
    }

    public function hits_grouped_last_days($client_id, $days = 30)
{
    $t = db_prefix().'qrassociados_hits';
    $sql = "SELECT DATE(created_at) d, COUNT(*) c
            FROM {$t}
            WHERE client_id = ? AND created_at >= DATE_SUB(CURDATE(), INTERVAL ? DAY)
            GROUP BY DATE(created_at)
            ORDER BY d ASC";
    return $this->db->query($sql, [(int)$client_id, (int)$days])->result();
}

    public function ranking($from = null, $to = null, $limit = 10)
{
    $where = '';
    $params = [];
    if ($from) { $where .= ' AND created_at >= ?'; $params[] = $from; }
    if ($to)   { $where .= ' AND created_at <= ?'; $params[] = $to; }
    $t = db_prefix().'qrassociados_hits';
    $sql = "SELECT client_id, COUNT(*) total
            FROM {$t}
            WHERE 1=1 {$where}
            GROUP BY client_id
            ORDER BY total DESC
            LIMIT ".$limit;
    return $this->db->query($sql, $params)->result();
}

public function ranking_with_client_names($from = null, $to = null, $limit = 10)
    {
        $results = $this->ranking($from, $to, $limit);
        $out = [];
        foreach ($results as $r) {
            $this->db->select('company');
            $row = $this->db->get_where(db_prefix().'clients', ['userid' => $r->client_id])->row();
            $name = $row ? $row->company : ('Cliente #'.$r->client_id);
            $out[] = (object)[ 'client_id' => $r->client_id, 'total' => (int)$r->total, 'name' => $name ];
        }
        return $out;
    }
}
