<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <h4 class="no-margin">QR Associados</h4>
            <hr class="hr-panel-heading" />

            <form class="form-inline" method="get" action="">
              <div class="form-group">
                <label>De</label>
                <input type="date" name="from" class="form-control" value="<?php echo html_escape($from); ?>" />
              </div>
              <div class="form-group" style="margin-left:10px;">
                <label>Até</label>
                <input type="date" name="to" class="form-control" value="<?php echo html_escape($to); ?>" />
              </div>
              <button type="submit" class="btn btn-primary" style="margin-left:10px;">Filtrar</button>
              <a class="btn btn-default" href="<?php echo admin_url('qrassociados'); ?>" style="margin-left:5px;">Limpar</a>
            </form>

            <div class="table-responsive" style="margin-top:15px;">
              <table class="table table-striped">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Cliente</th>
                    <th>Total</th>
                    <th>Ações</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $i=1; foreach($rank as $r): ?>
                  <tr>
                    <td><?php echo $i++; ?></td>
                    <td><?php echo html_escape($r->name); ?> (ID <?php echo (int)$r->client_id; ?>)</td>
                    <td><?php echo (int)$r->total; ?></td>
                    <td>
                      <a class="btn btn-default btn-sm" href="<?php echo admin_url('clients/client/' . (int)$r->client_id . '?group=qrassociados_tab'); ?>">Ver no cliente</a>
                    </td>
                  </tr>
                  <?php endforeach; if (empty($rank)): ?>
                  <tr><td colspan="4">Sem dados para o período.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php init_tail(); ?>
</body>
</html>
